/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.ten_shadows;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.base.TenShadowsSummon;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class RabbitEscapeEntity
extends TenShadowsSummon {
    private static final int COUNT = 16;
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation SWING = RawAnimation.begin().thenPlay("attack.swing");
    @Nullable
    private UUID leaderUUID;
    @Nullable
    private RabbitEscapeEntity cachedLeader;
    private boolean original;

    public RabbitEscapeEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public RabbitEscapeEntity(LivingEntity owner, boolean tame) {
        this((EntityType<? extends TamableAnimal>)((EntityType)JJKEntities.RABBIT_ESCAPE.get()), owner.m_9236_());
        this.setOwner(owner);
        this.m_7105_(tame);
        Vec3 direction = RotationUtil.calculateViewVector(0.0f, owner.m_146908_());
        Vec3 pos = owner.m_20182_().m_82546_(direction.m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_()));
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, owner.m_146908_(), owner.m_146909_());
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        this.m_20334_(look.f_82479_ * (this.f_19796_.m_188500_() * 2.0 + 1.0) + this.f_19796_.m_188500_() * (double)(this.f_19796_.m_188499_() ? 1 : -1) * 0.5, look.f_82480_ * (this.f_19796_.m_188500_() * 4.0 + 2.0) + this.f_19796_.m_188500_() * (double)(this.f_19796_.m_188499_() ? 1 : -1) * 0.5, look.f_82481_ * (this.f_19796_.m_188500_() * 2.0 + 1.0) + this.f_19796_.m_188500_() * (double)(this.f_19796_.m_188499_() ? 1 : -1) * 0.5);
        this.f_20886_ = this.f_20885_ = this.m_146908_();
    }

    public RabbitEscapeEntity(RabbitEscapeEntity leader) {
        this((LivingEntity)leader, leader.m_21824_());
        this.setLeader(leader);
        this.setOwner(leader.m_269323_());
    }

    @Override
    public boolean m_6779_(@NotNull LivingEntity pTarget) {
        RabbitEscapeEntity rabbit;
        if (this.getLeader() == pTarget || pTarget instanceof RabbitEscapeEntity && (rabbit = (RabbitEscapeEntity)pTarget).getLeader() == pTarget) {
            return false;
        }
        return super.m_6779_(pTarget);
    }

    @Override
    protected void m_8024_() {
        RabbitEscapeEntity leader;
        if (this.m_5448_() != null) {
            double d0 = this.m_21133_(Attributes.f_22277_);
            AABB bounds = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(d0, 10.0, d0);
            this.m_9236_().m_6443_(RabbitEscapeEntity.class, bounds, EntitySelector.f_20408_).stream().filter(entity -> entity != this).filter(entity -> entity.m_5448_() == null).filter(entity -> entity == this.m_269323_() || this.m_269323_() == entity || entity.m_269323_() == this).filter(entity -> !entity.m_7307_((Entity)this.m_5448_())).filter(entity -> entity.getLeader() != null && entity.getLeader() == this.getLeader() || this.getLeader() == entity || entity.getLeader() == this).forEach(entity -> entity.m_6710_(this.m_5448_()));
        } else {
            RabbitEscapeEntity leader2 = this.getLeader();
            if (leader2 != null && !leader2.m_213877_() && leader2.m_6084_()) {
                if ((double)this.m_20270_((Entity)leader2) >= 1.0) {
                    this.f_21365_.m_24960_((Entity)leader2, 10.0f, (float)this.m_8132_());
                    this.f_21344_.m_5624_((Entity)leader2, 1.0);
                }
            } else if (!this.original) {
                this.m_146870_();
            }
        }
        if (!(this.original || (leader = this.getLeader()) != null && !leader.m_213877_() && leader.m_6084_())) {
            this.m_146870_();
            return;
        }
    }

    public void setLeader(@Nullable RabbitEscapeEntity leader) {
        if (leader != null) {
            this.leaderUUID = leader.m_20148_();
            this.cachedLeader = leader;
        }
    }

    @Nullable
    public RabbitEscapeEntity getLeader() {
        if (this.cachedLeader != null && !this.cachedLeader.m_213877_()) {
            return this.cachedLeader;
        }
        if (this.leaderUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedLeader = (RabbitEscapeEntity)((ServerLevel)this.m_9236_()).m_8791_(this.leaderUUID);
            return this.cachedLeader;
        }
        return null;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.leaderUUID != null) {
            pCompound.m_128362_("leader", this.leaderUUID);
        }
        pCompound.m_128379_("original", this.original);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128403_("leader")) {
            this.leaderUUID = pCompound.m_128342_("leader");
        }
        this.original = pCompound.m_128471_("original");
    }

    @Override
    protected boolean shouldDespawn() {
        return this.original && super.shouldDespawn();
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        LivingEntity owner = this.m_269323_();
        if (owner == null) {
            return;
        }
        if (this.getLeader() == null) {
            this.original = true;
            for (int i = 0; i < 16; ++i) {
                RabbitEscapeEntity entity = new RabbitEscapeEntity(this);
                entity.m_146884_(this.m_20182_());
                entity.m_7105_(true);
                this.m_9236_().m_7967_((Entity)entity);
            }
        }
    }

    private PlayState walkPredicate(AnimationState<RabbitEscapeEntity> animationState) {
        if (animationState.isMoving()) {
            return animationState.setAndContinue(WALK);
        }
        return PlayState.STOP;
    }

    private PlayState swingPredicate(AnimationState<RabbitEscapeEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(SWING);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Walk", this::walkPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swing", this::swingPredicate)});
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    protected boolean canFly() {
        return false;
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return false;
    }

    @Override
    public boolean canJump() {
        return true;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    protected void m_7324_(@NotNull Entity p_20971_) {
    }

    @Override
    public Summon<?> getAbility() {
        return (Summon)JJKAbilities.RABBIT_ESCAPE.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22268_(Attributes.f_22279_, 0.66).m_22268_(Attributes.f_22276_, 0.01).m_22268_(Attributes.f_22281_, 4.8);
    }
}

