/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.event;

import java.util.ArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.AbilityHandler;
import radon.jujutsu_kaisen.ability.AbilityTriggerEvent;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.LivingHitByDomainEvent;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.misc.Barrage;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.chant.ServerChantHandler;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.entity.sorcerer.HeianSukunaEntity;
import radon.jujutsu_kaisen.util.HelperMethods;

public class MobEventHandler {

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class MobEventHandlerForgeEvents {
        @SubscribeEvent
        public static void onLivingHitByDomain(LivingHitByDomainEvent event) {
            Mob mob;
            LivingEntity victim = event.getEntity();
            if (victim instanceof ISorcerer && victim instanceof Mob && (mob = (Mob)victim).m_6779_(event.getAttacker())) {
                mob.m_6710_(event.getAttacker());
            }
        }

        @SubscribeEvent
        public static void onMobSpawn(MobSpawnEvent.FinalizeSpawn event) {
            if (!(event.getSpawnType() != MobSpawnType.NATURAL && event.getSpawnType() != MobSpawnType.CHUNK_GENERATION || VeilHandler.canSpawn(event.getEntity(), event.getX(), event.getY(), event.getZ()))) {
                event.setSpawnCancelled(true);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            DamageSource source = event.getSource();
            Entity entity = source.m_7639_();
            if (!(entity instanceof LivingEntity)) return;
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            if (attacker instanceof TamableAnimal) {
                TamableAnimal tamable1 = (TamableAnimal)attacker;
                if (attacker instanceof ISorcerer) {
                    if (tamable1.m_21824_() && tamable1.m_269323_() == victim) {
                        event.setCanceled(true);
                        return;
                    }
                    if (!(victim instanceof TamableAnimal)) return;
                    TamableAnimal tamable2 = (TamableAnimal)victim;
                    if (!(victim instanceof ISorcerer)) return;
                    if (tamable1.m_7306_((Entity)tamable2)) return;
                    if (!tamable1.m_21824_()) return;
                    if (!tamable2.m_21824_()) return;
                    if (tamable1.m_269323_() != tamable2.m_269323_()) return;
                    event.setCanceled(true);
                    return;
                }
            }
            if (!(victim instanceof TamableAnimal)) return;
            TamableAnimal tamable = (TamableAnimal)victim;
            if (!(victim instanceof ISorcerer)) return;
            if (!tamable.m_21824_()) return;
            if (tamable.m_269323_() != attacker) return;
            event.setCanceled(true);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onLivingHurt(LivingHurtEvent event) {
            ISorcerer sorcerer;
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            DamageSource source = event.getSource();
            if (victim instanceof ISorcerer && (sorcerer = (ISorcerer)victim).canChant() && !source.m_269533_(DamageTypeTags.f_268490_)) {
                if (!JJKAbilities.hasToggled(victim, (Ability)JJKAbilities.CURSED_ENERGY_FLOW.get())) {
                    AbilityHandler.trigger(victim, (Ability)JJKAbilities.CURSED_ENERGY_FLOW.get());
                }
                if (!source.m_269533_(DamageTypeTags.f_276146_) && !JJKAbilities.isChanneling(victim, (Ability)JJKAbilities.CURSED_ENERGY_SHIELD.get())) {
                    AbilityHandler.trigger(victim, (Ability)JJKAbilities.CURSED_ENERGY_SHIELD.get());
                }
            }
        }

        @SubscribeEvent
        public static void onAbilityTrigger(AbilityTriggerEvent.Pre event) {
            Level level;
            Ability ability = event.getAbility();
            LivingEntity owner = event.getEntity();
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (owner instanceof HeianSukunaEntity) {
                HeianSukunaEntity entity = (HeianSukunaEntity)owner;
                if (ability == JJKAbilities.BARRAGE.get()) {
                    entity.setBarrage(Barrage.DURATION * 2);
                }
            }
            if ((level = owner.m_9236_()) instanceof ServerLevel) {
                ArrayList<String> chants;
                ServerLevel level2 = (ServerLevel)level;
                if (owner instanceof Mob && !(chants = new ArrayList<String>(cap.getFirstChants(ability))).isEmpty() && HelperMethods.RANDOM.m_188503_(Math.max(1, (int)(50.0f * cap.getMaximumOutput()))) == 0) {
                    for (int i = 0; i < HelperMethods.RANDOM.m_188503_(chants.size()); ++i) {
                        ServerChantHandler.onChant(owner, (String)chants.get(i));
                        for (ServerPlayer player : level2.m_6907_()) {
                            ResourceLocation key;
                            if ((double)player.m_20270_((Entity)owner) > 64.0 || (key = owner.m_9236_().m_9598_().m_175515_(Registries.f_256939_).m_7981_((Object)owner.m_6095_())) == null) continue;
                            player.m_213846_((Component)Component.m_237113_((String)String.format("<%s> %s", owner.m_7755_().getString(), chants.get(i))));
                        }
                    }
                }
            }
        }
    }
}

