/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.network.packet.s2c;

import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.ClientWrapper;

public class SyncSorcererDataS2CPacket {
    private final CompoundTag nbt;

    public SyncSorcererDataS2CPacket(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public SyncSorcererDataS2CPacket(FriendlyByteBuf buf) {
        this(buf.m_130260_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(this.nbt);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Player player = ClientWrapper.getPlayer();
            assert (player != null);
            ISorcererData oldCap = (ISorcererData)player.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            SorcererData newCap = new SorcererData();
            newCap.deserializeNBT(this.nbt);
            Set<Ability> oldToggled = oldCap.getToggled();
            Set<Ability> newToggled = newCap.getToggled();
            oldToggled.removeAll(newToggled);
            for (Ability ability : oldToggled) {
                oldCap.toggle(ability);
            }
            oldCap.deserializeNBT(this.nbt);
        }));
        ctx.setPacketHandled(true);
    }
}

