/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.util;

import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import radon.jujutsu_kaisen.entity.NyoiStaffEntity;

public class RotationUtil {
    private static Vec2 getTargetAdjustedRotation(Vec3 start, Entity entity) {
        Targeting targeting;
        LivingEntity target;
        if (entity instanceof Targeting && (target = (targeting = (Targeting)entity).m_5448_()) != null) {
            Vec3 end = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
            double d0 = end.f_82479_ - start.f_82479_;
            double d1 = end.f_82480_ - start.f_82480_;
            double d2 = end.f_82481_ - start.f_82481_;
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            float yaw = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
            float pitch = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))));
            entity.m_146922_(yaw);
            entity.f_19859_ = yaw;
            entity.m_146926_(pitch);
            entity.f_19860_ = pitch;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.f_20885_ = yaw;
                living.f_20886_ = yaw;
                living.f_20883_ = yaw;
                living.f_20884_ = yaw;
            }
            return new Vec2(pitch, yaw);
        }
        return new Vec2(entity.m_146909_(), entity.m_146908_());
    }

    public static float getTargetAdjustedYRot(Vec3 start, Entity entity) {
        Vec2 rot = RotationUtil.getTargetAdjustedRotation(start, entity);
        return rot.f_82471_;
    }

    public static float getTargetAdjustedXRot(Vec3 start, Entity entity) {
        Vec2 rot = RotationUtil.getTargetAdjustedRotation(start, entity);
        return rot.f_82470_;
    }

    public static Vec3 getTargetAdjustedLookAngle(Vec3 start, Entity entity) {
        Vec2 rot = RotationUtil.getTargetAdjustedRotation(start, entity);
        return RotationUtil.calculateViewVector(rot.f_82471_, rot.f_82470_);
    }

    public static float getTargetAdjustedYRot(Entity entity) {
        return RotationUtil.getTargetAdjustedYRot(entity.m_146892_(), entity);
    }

    public static float getTargetAdjustedXRot(Entity entity) {
        return RotationUtil.getTargetAdjustedXRot(entity.m_146892_(), entity);
    }

    public static Vec3 getTargetAdjustedLookAngle(Entity entity) {
        return RotationUtil.getTargetAdjustedLookAngle(entity.m_146892_(), entity);
    }

    public static boolean hasLineOfSight(Vec3 start, Entity entity, Entity target) {
        if (target.m_9236_() != entity.m_9236_()) {
            return false;
        }
        Vec3 end = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
        if (end.m_82554_(start) > 128.0) {
            return false;
        }
        return entity.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).m_6662_() == HitResult.Type.MISS;
    }

    public static boolean hasLineOfSight(Entity entity, Entity target) {
        return RotationUtil.hasLineOfSight(entity.m_146892_(), entity, target);
    }

    public static Vec3 calculateViewVector(float yaw, float pitch) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static float getYaw(Vec3 vec) {
        return (float)(-Mth.m_14136_((double)vec.f_82479_, (double)vec.f_82481_) * 57.29577951308232);
    }

    public static HitResult getHitResult(Entity entity, Vec3 start, Vec3 end) {
        return RotationUtil.getHitResult(entity, start, end, target -> !target.m_5833_() && target.m_6087_());
    }

    public static HitResult getHitResult(Entity entity, Vec3 start, Vec3 end, Predicate<Entity> filter) {
        AABB bounds;
        EntityHitResult entityHit;
        Level level = entity.m_9236_();
        BlockHitResult blockHit = level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            end = blockHit.m_82450_();
        }
        if ((entityHit = ProjectileUtil.m_37304_((Level)level, null, (Vec3)start, (Vec3)end, (AABB)(bounds = AABB.m_165882_((Vec3)start, (double)40.0, (double)40.0, (double)40.0)).m_82369_(end.m_82546_(start)).m_82400_(20.0), filter)) != null) {
            return entityHit;
        }
        return blockHit;
    }

    public static HitResult getLookAtHit(Entity entity, double range, Predicate<Entity> filter) {
        Vec3 start = entity.m_146892_();
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle(entity);
        Vec3 end = start.m_82549_(look.m_82490_(range));
        return RotationUtil.getHitResult(entity, start, end, filter);
    }

    public static HitResult getLookAtHit(Entity entity, double range) {
        return RotationUtil.getLookAtHit(entity, range, target -> !target.m_5833_() && target.m_6087_());
    }

    public static LivingEntity getExpandedHit(Entity entity, Vec3 start, Vec3 end) {
        return RotationUtil.getExpandedHit(entity, start, end, target -> !target.m_5833_() && target.m_6087_());
    }

    public static LivingEntity getExpandedHit(Entity entity, Vec3 start, Vec3 end, Predicate<Entity> filter) {
        Level level = entity.m_9236_();
        BlockHitResult blockHit = level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            end = blockHit.m_82450_();
        }
        AABB bounds = AABB.m_165882_((Vec3)start, (double)3.0, (double)3.0, (double)3.0).m_82369_(end.m_82546_(start)).m_82400_(0.25);
        LivingEntity targeted = null;
        for (LivingEntity select2 : level.m_6443_(LivingEntity.class, bounds, select -> select != entity)) {
            if (targeted == null) {
                targeted = select2;
                continue;
            }
            Float dist1 = Float.valueOf(entity.m_20270_((Entity)select2));
            Float dist2 = Float.valueOf(entity.m_20270_((Entity)targeted));
            if (!(dist2.floatValue() > dist1.floatValue())) continue;
            targeted = select2;
        }
        return targeted;
    }

    public static LivingEntity getExpandedLookAt(Entity entity, double range, Predicate<Entity> filter) {
        Vec3 start = entity.m_146892_();
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle(entity);
        Vec3 end = start.m_82549_(look.m_82490_(range));
        return RotationUtil.getExpandedHit(entity, start, end, filter);
    }

    public static LivingEntity getExpandedLookAt(Entity entity, double range) {
        return RotationUtil.getExpandedLookAt(entity, range, target -> !target.m_5833_() && target.m_6087_());
    }

    public static NyoiStaffEntity getNyoiHit(Entity entity, Vec3 start, Vec3 end) {
        return RotationUtil.getNyoiHit(entity, start, end, target -> !target.m_5833_() && target.m_6087_());
    }

    public static NyoiStaffEntity getNyoiHit(Entity entity, Vec3 start, Vec3 end, Predicate<Entity> filter) {
        Level level = entity.m_9236_();
        BlockHitResult blockHit = level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            end = blockHit.m_82450_();
        }
        AABB bounds = AABB.m_165882_((Vec3)start, (double)3.0, (double)3.0, (double)3.0).m_82369_(end.m_82546_(start)).m_82400_(0.25);
        NyoiStaffEntity targeted = null;
        for (NyoiStaffEntity select2 : level.m_6443_(NyoiStaffEntity.class, bounds, select -> select != entity)) {
            if (targeted == null) {
                targeted = select2;
                continue;
            }
            Float dist1 = Float.valueOf(entity.m_20270_((Entity)select2));
            Float dist2 = Float.valueOf(entity.m_20270_((Entity)targeted));
            if (!(dist2.floatValue() > dist1.floatValue())) continue;
            targeted = select2;
        }
        return targeted;
    }

    public static NyoiStaffEntity getNyoiLookAt(Entity entity, double range, Predicate<Entity> filter) {
        Vec3 start = entity.m_146892_();
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle(entity);
        Vec3 end = start.m_82549_(look.m_82490_(range));
        return RotationUtil.getNyoiHit(entity, start, end, filter);
    }

    public static NyoiStaffEntity getNyoiLookAt(Entity entity, double range) {
        return RotationUtil.getNyoiLookAt(entity, range, target -> !target.m_5833_() && target.m_6087_());
    }
}

