/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.base;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import radon.jujutsu_kaisen.JujutsuKaisen;
import radon.jujutsu_kaisen.ability.AbilityDisplayInfo;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedEnergyNature;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.chant.ChantHandler;
import radon.jujutsu_kaisen.compat.CuffedCompat;
import radon.jujutsu_kaisen.compat.PlayerReviveCompat;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.util.RotationUtil;

public abstract class Ability {
    public static float getPower(Ability ability, LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getAbilityPower() * (1.0f + 0.5f * ChantHandler.getChant(owner, ability));
    }

    public float getPower(LivingEntity owner) {
        return Ability.getPower(this, owner);
    }

    public boolean isScalable(LivingEntity owner) {
        return this.getActivationType(owner) != ActivationType.TOGGLED;
    }

    public boolean isChantable() {
        return false;
    }

    protected boolean isNotDisabledFromDA() {
        return false;
    }

    public boolean canDisable() {
        return true;
    }

    public boolean isCursedEnergyColor() {
        return false;
    }

    public boolean isDisplayed(LivingEntity owner) {
        return this.getPointsCost() > 0;
    }

    protected int getPointsCost() {
        return 0;
    }

    public boolean isDomain() {
        return false;
    }

    public int getRealPointsCost(LivingEntity owner) {
        return this.getPointsCost();
    }

    public boolean isUnlocked(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.isUnlocked(this);
    }

    public boolean canUnlock(LivingEntity owner) {
        if (this.isBlocked(owner)) {
            return false;
        }
        if (owner instanceof Player) {
            Player player = (Player)owner;
            if (player.m_150110_().f_35937_) {
                return true;
            }
        }
        if (!this.isUnlockable() || this.getPointsCost() == 0) {
            return false;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getPoints() >= this.getRealPointsCost(owner);
    }

    public boolean isUnlockable() {
        return this.getPointsCost() > 0;
    }

    public boolean isBlocked(LivingEntity owner) {
        Ability parent = this.getParent(owner);
        return parent != null && !parent.isUnlocked(owner);
    }

    public Vec2 getDisplayCoordinates() {
        return Vec2.f_82462_;
    }

    public AbilityDisplayInfo getDisplay(LivingEntity owner) {
        Vec2 coordinates = this.getDisplayCoordinates();
        return new AbilityDisplayInfo(JJKAbilities.getKey(this).m_135815_(), coordinates.f_82470_, coordinates.f_82471_);
    }

    @Nullable
    public Ability getParent(LivingEntity owner) {
        return null;
    }

    public Classification getClassification() {
        return Classification.NONE;
    }

    public boolean isMelee() {
        return false;
    }

    public boolean usesHands() {
        return true;
    }

    public abstract boolean shouldTrigger(PathfinderMob var1, @Nullable LivingEntity var2);

    public abstract ActivationType getActivationType(LivingEntity var1);

    public abstract void run(LivingEntity var1);

    public List<Ability> getRequirements() {
        return List.of();
    }

    protected int getCooldown() {
        return 0;
    }

    public boolean isTechnique() {
        return true;
    }

    public int getRealCooldown(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (this.isMelee() && cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
            return this.getCooldown() / 2;
        }
        if (this.isMelee() && cap.getNature() == CursedEnergyNature.DIVERGENT) {
            return this.getCooldown() * 3 / 4;
        }
        return this.getCooldown();
    }

    public MenuType getMenuType() {
        return MenuType.RADIAL;
    }

    public boolean isValid(LivingEntity owner) {
        Player player;
        if (owner == null || owner instanceof Player && (player = (Player)owner).m_5833_()) {
            return false;
        }
        if (this.isUnlockable() && !this.isUnlocked(owner)) {
            return false;
        }
        if (!owner.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return false;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (this.isTechnique() && cap.hasToggled((Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get()) && (!this.isNotDisabledFromDA() || !cap.hasToggled(this))) {
            return false;
        }
        if (this.isTechnique() && this.canDisable() && cap.hasDisable()) {
            return false;
        }
        if (this.usesHands() && !this.isDomain() && (cap.hasToggled((Ability)JJKAbilities.HOLLOW_WICKER_BASKET.get()) || cap.hasDisarmed()) && !cap.hasTrait(Trait.PERFECT_BODY)) {
            return false;
        }
        for (Ability ability : this.getRequirements()) {
            if (ability.isUnlocked(owner)) continue;
            return false;
        }
        return true;
    }

    private void addDuration(LivingEntity owner) {
        IDurationable durationable;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        Ability ability = this;
        if (ability instanceof IDurationable && (durationable = (IDurationable)((Object)ability)).getRealDuration(owner) > 0) {
            cap.addDuration(this);
        }
    }

    public void charge(LivingEntity owner) {
        block5: {
            ISorcererData cap;
            block4: {
                cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (!(owner instanceof Player)) break block4;
                Player player = (Player)owner;
                if (player.m_150110_().f_35937_) break block5;
            }
            cap.useEnergy(this.getRealCost(owner));
            if (this.getRealCooldown(owner) > 0) {
                cap.addCooldown(this);
            }
        }
    }

    public Status getStatus(LivingEntity owner) {
        block16: {
            ISorcererData cap;
            block15: {
                if (this != JJKAbilities.WHEEL.get() && this != JJKAbilities.CURSED_ENERGY_FLOW.get() && owner.m_21023_((MobEffect)JJKEffects.UNLIMITED_VOID.get())) {
                    return Status.FAILURE;
                }
                cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (!(owner instanceof Player)) break block15;
                Player player = (Player)owner;
                if (player.m_150110_().f_35937_ || ((Boolean)ConfigHolder.SERVER.turboMode.get()).booleanValue()) break block16;
            }
            if (this.isTechnique() && cap.hasBurnout()) {
                return Status.BURNOUT;
            }
            if (this.isTechnique() && this.canDisable() && cap.hasDisable()) {
                return Status.DISABLE;
            }
            if (this.usesHands() && !this.isDomain() && (cap.hasToggled((Ability)JJKAbilities.HOLLOW_WICKER_BASKET.get()) || cap.hasDisarmed()) && !cap.hasTrait(Trait.PERFECT_BODY)) {
                return Status.DISARMED;
            }
            if (owner instanceof Player) {
                Player player = (Player)owner;
                if (JujutsuKaisen.PlayerReviveInstalled && PlayerReviveCompat.IsBleedingOut(player)) {
                    return Status.FAILURE;
                }
                if (JujutsuKaisen.CuffedInstalled) {
                    if (this.usesHands() && CuffedCompat.armsRestrained(player)) {
                        return Status.DISARMED;
                    }
                    if (CuffedCompat.legsRestrained(player) && !this.usesHands() && this.getClassification() != Classification.CURSED_SPEECH) {
                        return Status.FAILURE;
                    }
                    if (CuffedCompat.headRestrained(player) && this.getClassification() == Classification.CURSED_SPEECH) {
                        return Status.FAILURE;
                    }
                }
            }
            if (!cap.isCooldownDone(this)) {
                return Status.COOLDOWN;
            }
            if (!this.checkCost(owner)) {
                return Status.ENERGY;
            }
        }
        return Status.SUCCESS;
    }

    public Status isTriggerable(LivingEntity owner) {
        if (!JJKAbilities.getAbilities(owner).contains(this)) {
            return Status.UNUSUABLE;
        }
        MobEffectInstance instance = owner.m_21124_((MobEffect)JJKEffects.STUN.get());
        if (instance != null && instance.m_19564_() > 0 && this != JJKAbilities.HEAL.get() && this != JJKAbilities.RCT1.get() && this != JJKAbilities.RCT2.get() && this != JJKAbilities.RCT3.get() && this != JJKAbilities.CURSED_ENERGY_SHIELD.get() && this != JJKAbilities.HOLLOW_WICKER_BASKET.get() && this != JJKAbilities.SIMPLE_DOMAIN.get() && this != JJKAbilities.SIMPLE_DOMAIN_ENLARGEMENT.get()) {
            return Status.FAILURE;
        }
        Status status = this.getStatus(owner);
        this.addDuration(owner);
        return status;
    }

    public Status isStillUsable(LivingEntity owner) {
        if (!JJKAbilities.getAbilities(owner).contains(this)) {
            return Status.UNUSUABLE;
        }
        if (this instanceof IAttack || this instanceof ICharged) {
            return this.getStatus(owner);
        }
        Status status = this.getStatus(owner);
        if (status == Status.SUCCESS || status == Status.COOLDOWN) {
            this.charge(owner);
        }
        return status;
    }

    public boolean checkCost(LivingEntity owner) {
        block3: {
            ISorcererData cap;
            block2: {
                cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (!(owner instanceof Player)) break block2;
                Player player = (Player)owner;
                if (player.m_150110_().f_35937_) break block3;
            }
            float cost = this.getRealCost(owner);
            return cap.getEnergy() >= cost;
        }
        return true;
    }

    public Component getName() {
        ResourceLocation key = JJKAbilities.getKey(this);
        return Component.m_237115_((String)String.format("ability.%s.%s", key.m_135827_(), key.m_135815_()));
    }

    public abstract float getCost(LivingEntity var1);

    public boolean shouldLog(LivingEntity owner) {
        return this.getActivationType(owner) == ActivationType.TOGGLED;
    }

    public Component getEnableMessage() {
        ResourceLocation key = JJKAbilities.getKey(this);
        if (key == null) {
            return Component.m_237119_();
        }
        return Component.m_237115_((String)String.format("ability.%s.%s.enable", key.m_135827_(), key.m_135815_()));
    }

    public Component getDisableMessage() {
        ResourceLocation key = JJKAbilities.getKey(this);
        if (key == null) {
            return Component.m_237119_();
        }
        return Component.m_237115_((String)String.format("ability.%s.%s.disable", key.m_135827_(), key.m_135815_()));
    }

    @Nullable
    public BlockHitResult getBlockHit(LivingEntity owner, double range) {
        Vec3 look;
        Vec3 end;
        Vec3 start = owner.m_146892_();
        HitResult result = RotationUtil.getHitResult((Entity)owner, start, end = start.m_82549_((look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner)).m_82490_(range)));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return (BlockHitResult)result;
        }
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).m_82443_();
            Vec3 offset = entity.m_20182_().m_82492_(0.0, 5.0, 0.0);
            return owner.m_9236_().m_45547_(new ClipContext(entity.m_20182_(), offset, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        }
        return null;
    }

    public float getRealCost(LivingEntity owner) {
        float cost = this.getCost(owner);
        float output = ChantHandler.getOutput(owner, this);
        if (!owner.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return cost;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        CursedTechnique copied = cap.getCurrentCopied();
        if (copied != null && List.of(copied.getAbilities()).contains(this)) {
            cost *= 1.5f;
        }
        if (cap.hasTrait(Trait.SIX_EYES) && (this.isTechnique() || this.isDomain())) {
            cost *= 0.5f;
        }
        if (output > 0.0f) {
            output = Mth.m_14036_((float)(output * 0.8f), (float)1.0f, (float)100.0f);
            cost *= this.isScalable(owner) || this.isChantable() ? output : 1.0f;
        }
        return Float.parseFloat(String.format(Locale.ROOT, "%.2f", Float.valueOf(cost)));
    }

    public static enum ActivationType {
        INSTANT,
        TOGGLED,
        CHANNELED;

    }

    public static enum Classification {
        NONE,
        CURSED_SPEECH,
        SLASHING,
        FIRE,
        WATER,
        PLANTS,
        BLUE,
        LIGHTNING,
        PROJECTION;

    }

    public static interface IDurationable {
        default public int getDuration() {
            return 0;
        }

        default public int getRealDuration(LivingEntity owner) {
            int duration = this.getDuration();
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (duration > 0) {
                duration = (int)((float)duration * cap.getRealPower());
            }
            return duration;
        }
    }

    public static enum Status {
        FAILURE,
        UNUSUABLE,
        SUCCESS,
        ENERGY,
        COOLDOWN,
        BURNOUT,
        DISABLE,
        DISARMED,
        SILENCED;

    }

    public static interface IAttack {
        public boolean attack(DamageSource var1, LivingEntity var2, LivingEntity var3);
    }

    public static interface ICharged
    extends IChannelened {
        default public boolean onRelease(LivingEntity owner) {
            return true;
        }
    }

    public static interface IToggled {
        public void onEnabled(LivingEntity var1);

        public void onDisabled(LivingEntity var1);

        default public void applyModifiers(LivingEntity owner) {
        }

        default public void removeModifiers(LivingEntity owner) {
        }
    }

    public static interface IChannelened {
        default public void onStart(LivingEntity owner) {
        }

        default public void onStop(LivingEntity owner) {
        }

        default public int getCharge(LivingEntity owner) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            return cap.getCharge();
        }
    }

    public static interface ITenShadowsAttack {
        public void perform(LivingEntity var1, @Nullable LivingEntity var2);
    }

    public static interface IDomainAttack {
        default public void performEntity(LivingEntity owner, LivingEntity target, DomainExpansionEntity domain) {
        }

        default public void performBlock(LivingEntity owner, DomainExpansionEntity domain, BlockPos pos) {
        }
    }
}

