/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.idle_transfiguration;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.idle_transfiguration.IdleTransfiguration;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.idle_transfiguration.base.TransfiguredSoulEntity;
import radon.jujutsu_kaisen.util.HelperMethods;

public class SoulDecimation
extends Ability
implements Ability.IToggled,
Ability.IAttack {
    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public void run(LivingEntity owner) {
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.hasToggled((Ability)JJKAbilities.IDLE_TRANSFIGURATION.get())) {
            cap.toggle((Ability)JJKAbilities.IDLE_TRANSFIGURATION.get());
        }
        return super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 0.0f;
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    @Override
    public boolean attack(DamageSource source, LivingEntity owner, LivingEntity target) {
        if (owner.m_9236_().f_46443_) {
            return false;
        }
        if (!HelperMethods.isMelee(source)) {
            return false;
        }
        MobEffectInstance existing = target.m_21124_((MobEffect)JJKEffects.TRANSFIGURED_SOUL.get());
        int amplifier = 0;
        if (existing != null) {
            amplifier = existing.m_19564_();
        }
        float attackerStrength = IdleTransfiguration.calculateStrength(owner);
        float victimStrength = IdleTransfiguration.calculateStrength(target);
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        int required = 1;
        float cost = Math.min(4, amplifier) * 50;
        if ((target instanceof TransfiguredSoulEntity || amplifier >= required) && cap.getEnergy() >= cost) {
            cap.useEnergy(cost);
            target.m_21195_((MobEffect)JJKEffects.TRANSFIGURED_SOUL.get());
            target.m_6469_(JJKDamageSources.soulAttack(owner), target.m_21233_() * Math.min(6.0f, (float)amplifier * 1.5f) / 10.0f);
        }
        return true;
    }
}

