/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.misc.Dash;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.client.particle.MirageParticle;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class QuickDash
extends Dash {
    public static final double RANGE = 80.0;
    private static final float DASH = 2.0f;
    private static final float MAX_DASH = 3.0f;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null) {
            return false;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
            return HelperMethods.RANDOM.m_188503_(2) == 0;
        }
        return HelperMethods.RANDOM.m_188503_(10) == 0;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.isCooldownDone((Ability)JJKAbilities.DASH.get()) ? super.isTriggerable(owner) : Ability.Status.FAILURE;
    }

    private static double getDistanceGround(LivingEntity entity) {
        Vec3 pos = entity.m_20182_();
        Vec3 down = pos.m_82520_(0.0, -256.0, 0.0);
        BlockHitResult result = entity.m_9236_().m_45547_(new ClipContext(pos, down, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)entity));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return pos.f_82480_ - result.m_82450_().f_82480_;
        }
        return Double.MAX_VALUE;
    }

    private static float getRange(LivingEntity owner) {
        return (float)(80.0 * (double)(JJKAbilities.hasTrait(owner, Trait.HEAVENLY_RESTRICTION) ? 1.5f : 1.0f));
    }

    private static boolean canDash(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (owner.m_21023_((MobEffect)JJKEffects.DOMAINSTUN.get()) || owner.m_21023_((MobEffect)JJKEffects.STUN.get()) || cap.hasToggled((Ability)JJKAbilities.ANGEL_WINGS.get()) && QuickDash.getDistanceGround(owner) > 4.0) {
            return false;
        }
        boolean collision = false;
        AABB bounds = owner.m_20191_();
        int bound = 4;
        Cursor3D cursor = new Cursor3D(Mth.m_14107_((double)(bounds.f_82288_ - 1.0E-7)) - bound, Mth.m_14107_((double)(bounds.f_82289_ - 1.0E-7)) - bound, Mth.m_14107_((double)(bounds.f_82290_ - 1.0E-7)) - bound, Mth.m_14107_((double)(bounds.f_82291_ + 1.0E-7)) + bound, Mth.m_14107_((double)(bounds.f_82292_ + 1.0E-7)) + bound, Mth.m_14107_((double)(bounds.f_82293_ + 1.0E-7)) + bound);
        while (cursor.m_122304_()) {
            BlockState state;
            int i = cursor.m_122305_();
            int j = cursor.m_122306_();
            int k = cursor.m_122307_();
            int l = cursor.m_122308_();
            if (l == 3 || (state = owner.m_9236_().m_8055_(new BlockPos(i, j, k))).m_60795_()) continue;
            collision = true;
            break;
        }
        return collision || owner.m_146909_() >= 1.0f;
    }

    @Override
    public void run(LivingEntity owner) {
        int i;
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!QuickDash.canDash(owner)) {
            return;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        cap.addDash();
        cap.delayTickEvent(cap::subDash, 10);
        owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_184215_, SoundSource.MASTER, 2.0f, 1.25f);
        if (cap.getSpeedStacks() > 0 || cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
            owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)JJKSounds.DASH.get(), SoundSource.MASTER, 0.2f, 1.5f);
            owner.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.INVISIBILITY.get(), 4, 0, false, false, false));
            level2.m_8767_((ParticleOptions)new MirageParticle.MirageParticleOptions(owner.m_19879_()), owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), 0, 0.0, 0.0, 0.0, 1.0);
        }
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        HitResult hit = RotationUtil.getLookAtHit((Entity)owner, QuickDash.getRange(owner));
        float power = Math.min(3.0f, 2.0f * (1.0f + this.getPower(owner) * 0.1f));
        if (!owner.m_6144_()) {
            power *= 0.55f;
        }
        if (owner.m_20096_() && look.f_82480_ < 0.0) {
            look = owner.m_20154_().m_82542_(1.0, 0.0, 1.0);
        }
        Vec3 velocity = look.m_82541_().m_82490_((double)power);
        velocity = velocity.m_82559_(new Vec3(1.5, 1.0, 1.5));
        velocity = velocity.f_82480_ > 0.0 ? velocity.m_82559_(new Vec3(1.2, 0.6, 1.2)) : velocity.m_82559_(new Vec3(1.2, 1.3, 1.2));
        if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
            velocity = velocity.m_82559_(new Vec3(1.2, 1.0, 1.2));
            if (owner.m_6144_()) {
                owner.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.INVISIBILITY.get(), 8, 0, false, false, false));
            } else {
                owner.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.INVISIBILITY.get(), 4, 0, false, false, false));
                velocity = velocity.m_82559_(new Vec3(1.1, 1.0, 1.1));
            }
        }
        if (owner.m_20096_() && velocity.f_82480_ < 0.0) {
            velocity.m_82542_(1.0, 0.0, 1.0);
        }
        velocity = velocity.m_82549_(new Vec3(0.0, 0.6, 0.0));
        if (!owner.m_20096_() && owner.m_9236_().m_8055_(owner.m_20183_()).m_60819_().m_76178_()) {
            velocity = velocity.m_82549_(new Vec3(0.0, -0.75, 0.0));
        }
        owner.m_20256_(velocity);
        owner.f_19864_ = true;
        Vec3 pos = owner.m_20182_();
        for (i = 0; i < 32; ++i) {
            double xPos = owner.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.25f) - owner.m_20154_().m_82490_((double)0.35).f_82479_;
            double yPos = owner.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)owner.m_20206_();
            double zPos = owner.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.25f) - owner.m_20154_().m_82490_((double)0.35).f_82481_;
            double theta = HelperMethods.RANDOM.m_188500_() * 2.0 * Math.PI;
            double phi = HelperMethods.RANDOM.m_188500_() * Math.PI;
            double r = HelperMethods.RANDOM.m_188500_() * 0.2;
            double x = r * Math.sin(phi) * Math.cos(theta);
            double y = r * Math.sin(phi) * Math.sin(theta);
            double z = r * Math.cos(phi);
            Vec3 speed = look.m_82520_(x, y, z).m_82548_();
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123796_, xPos, yPos, zPos, 0, speed.f_82479_, speed.f_82480_, speed.f_82481_, 1.0);
        }
        for (i = 0; i < 4; ++i) {
            cap.delayTickEvent(() -> {
                for (int a = 0; a < 4; ++a) {
                    Vec3 pos2 = owner.m_146892_();
                    level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, pos2.f_82479_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 0.8, pos2.f_82480_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 0.8, pos2.f_82481_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 0.8, 0, 0.0, 0.0, 0.0, 1.0);
                }
            }, i);
        }
    }

    @Override
    public int getRealCooldown(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
            if (owner.m_6144_()) {
                return 16;
            }
            return 8;
        }
        if (owner.m_6144_()) {
            return 25;
        }
        return super.getSuperRealCooldown(owner);
    }
}

