/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.misc.Barrage;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedEnergyNature;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.SimpleDomainEntity;
import radon.jujutsu_kaisen.entity.projectile.WorldSlashProjectile;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class QuickDraw
extends Ability
implements Ability.IToggled {
    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    private static void attack(LivingEntity owner, LivingEntity entity) {
        if (entity.f_19802_ > 0) {
            return;
        }
        owner.m_7618_(EntityAnchorArgument.Anchor.EYES, entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0));
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        for (int i = 0; i < Barrage.DURATION; ++i) {
            boolean last = i == Barrage.DURATION - 1;
            cap.delayTickEvent(() -> {
                Vec3 pos;
                int j;
                cap.useEnergy(4.0f);
                if (owner instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)owner;
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
                }
                owner.m_21011_(InteractionHand.MAIN_HAND, true);
                Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
                for (j = 0; j < 4; ++j) {
                    pos = owner.m_146892_().m_82549_(look.m_82490_((double)owner.m_20270_((Entity)entity)));
                    ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)(owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SwordItem ? ParticleTypes.f_123766_ : ParticleTypes.f_123796_), pos.f_82479_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, pos.f_82480_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, pos.f_82481_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, 0, 0.0, 0.0, 0.0, 1.0);
                }
                for (j = 0; j < 4; ++j) {
                    pos = owner.m_146892_().m_82549_(look.m_82490_((double)owner.m_20270_((Entity)entity)));
                    ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, pos.f_82480_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, pos.f_82481_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, 0, 0.0, 0.0, 0.0, 1.0);
                }
                Vec3 pos2 = owner.m_146892_().m_82549_(look);
                owner.m_9236_().m_6263_(null, pos2.f_82479_, pos2.f_82480_, pos2.f_82481_, SoundEvents.f_11916_, SoundSource.MASTER, 1.0f, 0.3f);
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    player.m_5706_((Entity)entity);
                } else {
                    owner.m_7327_((Entity)entity);
                }
                if (!last) {
                    entity.f_19802_ = 1;
                }
            }, i * 2);
        }
    }

    @Override
    public void run(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        owner.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), 2, 1, false, false, false));
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.SIMPLE_DOMAIN.get())) {
            SimpleDomainEntity domain = cap.getSummonByClass(SimpleDomainEntity.class);
            if (domain == null) {
                return;
            }
            for (Entity entity : owner.m_9236_().m_45933_((Entity)owner, domain.m_20191_())) {
                LivingEntity living;
                if (entity == domain || entity.m_20270_((Entity)domain) > domain.getRadius() || !(entity instanceof LivingEntity) || (living = (LivingEntity)entity).m_21224_()) continue;
                QuickDraw.attack(owner, living);
            }
        }
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    @Override
    public int getCooldown() {
        return 100;
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 0.5f;
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        return (JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.SIMPLE_DOMAIN.get()) || JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.FALLING_BLOSSOM_EMOTION.get())) && super.isValid(owner);
    }

    @Override
    @Nullable
    public Ability getParent(LivingEntity owner) {
        return (Ability)JJKAbilities.SIMPLE_DOMAIN.get();
    }

    @Override
    public int getPointsCost() {
        return (Integer)ConfigHolder.SERVER.quickDrawCost.get();
    }

    @Override
    public Vec2 getDisplayCoordinates() {
        return new Vec2(5.0f, 5.0f);
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.DOMAIN;
    }

    @Override
    public boolean isDisplayed(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        CursedTechnique technique = cap.getTechnique();
        CursedEnergyNature nature = cap.getNature();
        return technique == CursedTechnique.TECHNIQUELESS && nature != CursedEnergyNature.DIVERGENT && super.isDisplayed(owner);
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            int remaining;
            int blocked;
            Projectile projectile;
            LivingEntity victim;
            block8: {
                block7: {
                    victim = event.getEntity();
                    if (victim.m_9236_().f_46443_ || !victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                        return;
                    }
                    ISorcererData cap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                    if (!cap.hasToggled((Ability)JJKAbilities.QUICK_DRAW.get()) && !cap.hasToggled((Ability)JJKAbilities.FALLING_BLOSSOM_EMOTION.get())) {
                        return;
                    }
                    Entity entity = event.getSource().m_7640_();
                    if (!(entity instanceof Projectile)) break block7;
                    projectile = (Projectile)entity;
                    if (!(event.getSource().m_7640_() instanceof WorldSlashProjectile)) break block8;
                }
                return;
            }
            ItemStack stack = victim.m_21120_(InteractionHand.MAIN_HAND);
            if (!(stack.m_41720_() instanceof SwordItem)) {
                return;
            }
            int amount = Math.round(event.getAmount());
            float reduced = amount - (blocked = Math.min(remaining = stack.m_41776_() - stack.m_41773_(), amount));
            if (reduced > 0.0f) {
                return;
            }
            victim.m_7618_(EntityAnchorArgument.Anchor.EYES, projectile.m_20182_().m_82520_(0.0, (double)(projectile.m_20206_() / 2.0f), 0.0));
            victim.m_21011_(InteractionHand.MAIN_HAND, true);
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_ || !victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData cap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (!cap.hasToggled((Ability)JJKAbilities.QUICK_DRAW.get()) && !cap.hasToggled((Ability)JJKAbilities.FALLING_BLOSSOM_EMOTION.get())) {
                return;
            }
            Entity entity = event.getSource().m_7640_();
            if (!(entity instanceof Projectile)) {
                return;
            }
            Projectile projectile = (Projectile)entity;
            ItemStack stack = victim.m_21120_(InteractionHand.MAIN_HAND);
            if (!(stack.m_41720_() instanceof SwordItem)) {
                return;
            }
            int amount = Math.round(event.getAmount());
            int remaining = stack.m_41776_() - stack.m_41773_();
            int blocked = Math.min(remaining, amount);
            victim.m_7618_(EntityAnchorArgument.Anchor.EYES, projectile.m_20182_().m_82520_(0.0, (double)(projectile.m_20206_() / 2.0f), 0.0));
            victim.m_21011_(InteractionHand.MAIN_HAND, true);
            float reduced = amount - blocked;
            event.setAmount(reduced);
        }
    }
}

