/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.shrine;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.projectile.FireArrowProjectile;

public class FireArrow
extends Ability {
    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null) {
            return false;
        }
        return owner.m_21223_() / owner.m_21233_() < 0.9f && target.m_21223_() / target.m_21233_() < 0.5f && owner.m_142582_((Entity)target);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        FireArrowProjectile arrow = new FireArrowProjectile(owner, this.getPower(owner));
        owner.m_9236_().m_7967_((Entity)arrow);
    }

    @Override
    public int getPointsCost() {
        return 50;
    }

    @Override
    public Vec2 getDisplayCoordinates() {
        return new Vec2(0.0f, 3.0f);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 350.0f;
    }

    @Override
    public int getCooldown() {
        return 600;
    }

    @Override
    public boolean isDisplayed(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        CursedTechnique technique = cap.getTechnique();
        return (technique == CursedTechnique.SHRINE || cap.hasStolen(CursedTechnique.SHRINE)) && super.isDisplayed(owner);
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.FIRE;
    }
}

