/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.ten_shadows;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.ability.AbilityTriggerEvent;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.DomainExpansion;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.block.JJKBlocks;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.ChimeraShadowGardenEntity;
import radon.jujutsu_kaisen.entity.ClosedDomainExpansionEntity;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.base.TenShadowsSummon;
import radon.jujutsu_kaisen.util.RotationUtil;

public class ChimeraShadowGarden
extends DomainExpansion
implements DomainExpansion.IClosedDomain {
    @Override
    public void onHitEntity(DomainExpansionEntity domain, LivingEntity owner, LivingEntity entity, boolean instant) {
    }

    @Override
    public void onHitBlock(DomainExpansionEntity domain, LivingEntity owner, BlockPos pos) {
    }

    @Override
    protected DomainExpansionEntity createBarrier(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap == null) {
            return null;
        }
        int radius = Math.round(this.getRadius(owner));
        ClosedDomainExpansionEntity domain = new ClosedDomainExpansionEntity(owner, this, radius);
        owner.m_9236_().m_7967_((Entity)domain);
        ChimeraShadowGardenEntity center = new ChimeraShadowGardenEntity(domain);
        Vec3 pos = owner.m_20182_().m_82546_(RotationUtil.calculateViewVector(0.0f, owner.m_146908_()).m_82542_((double)(center.m_20205_() / 2.0f), 0.0, (double)(center.m_20205_() / 2.0f)));
        center.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, 180.0f - RotationUtil.getTargetAdjustedYRot((Entity)owner), 0.0f);
        owner.m_9236_().m_7967_((Entity)center);
        if (owner.m_9236_() instanceof ServerLevel) {
            ArrayList<TenShadowsSummon> summons = new ArrayList<TenShadowsSummon>();
            for (Entity entity : cap.getSummons()) {
                TenShadowsSummon summon;
                if (!(entity instanceof TenShadowsSummon) || !(summon = (TenShadowsSummon)entity).m_21824_()) continue;
                summons.add(summon);
            }
            for (TenShadowsSummon summon : summons) {
                if (!summons.stream().noneMatch(x -> x.getJujutsuType() == summon.getJujutsuType() && x.isClone())) continue;
                summon.getAbility().spawn(owner, true);
            }
        }
        return domain;
    }

    @Override
    public List<Block> getBlocks() {
        return List.of((Block)JJKBlocks.TIME_CELL_MOON_PALACE.get());
    }

    @Override
    public List<Block> getFillBlocks() {
        return List.of((Block)JJKBlocks.TIME_CELL_MOON_PALACE.get());
    }

    @Override
    public List<Block> getFloorBlocks() {
        return List.of((Block)JJKBlocks.TIME_CELL_MOON_PALACE.get());
    }

    @Override
    public List<Block> getDecorationBlocks() {
        return List.of((Block)JJKBlocks.CHIMERA_SHADOW_GARDEN.get());
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ChimeraShadowGardenForgeEvents {
        @SubscribeEvent
        public static void onAbilityTrigger(AbilityTriggerEvent.Pre event) {
            Summon summon;
            Ability ability;
            LivingEntity owner = event.getEntity();
            if (JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.CHIMERA_SHADOW_GARDEN.get()) && (ability = event.getAbility()) instanceof Summon && (summon = (Summon)ability).isTamed(owner)) {
                summon.spawn(owner, true);
            }
        }
    }
}

