/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.ten_shadows;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.AbilityHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.ten_shadows.GreatSerpentEntity;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class GreatSerpentGrab
extends Ability {
    public static final double RANGE = 60.0;
    public LivingEntity enemy = null;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return HelperMethods.RANDOM.m_188503_(3) == 0 && target != null && this.getTarget((LivingEntity)owner) == target;
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        if (!super.isValid(owner)) {
            return false;
        }
        return JJKAbilities.hasTamed(owner, (EntityType)JJKEntities.GREAT_SERPENT.get()) && ((Summon)JJKAbilities.GREAT_SERPENT.get()).getStatus(owner) == Ability.Status.SUCCESS;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Nullable
    private LivingEntity getTarget(LivingEntity owner) {
        LivingEntity target = RotationUtil.getExpandedLookAt((Entity)owner, 60.0);
        if (target != null) {
            if (!owner.m_6779_(target)) {
                return null;
            }
            return target;
        }
        return null;
    }

    @Override
    public void run(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        LivingEntity target = this.enemy;
        AbilityHandler.trigger(owner, (Ability)JJKAbilities.GREAT_SERPENT.get());
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        GreatSerpentEntity serpent = cap.getSummonByClass(GreatSerpentEntity.class);
        if (serpent == null) {
            return;
        }
        serpent.grab(target);
        target = null;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        LivingEntity target;
        this.enemy = target = this.getTarget(owner);
        if (target == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 0.0f;
    }

    @Override
    protected int getCooldown() {
        return 400;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

