/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.capability.data.sorcerer;

import com.mojang.authlib.GameProfile;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import radon.jujutsu_kaisen.ability.AbilityStopEvent;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.misc.Slam;
import radon.jujutsu_kaisen.capability.data.sorcerer.AbsorbedCurse;
import radon.jujutsu_kaisen.capability.data.sorcerer.BindingVow;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedEnergyNature;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.DelayedTickEvent;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.Pact;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.client.visual.ClientVisualHandler;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.item.cursed_tool.HitenStaffItem;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.c2s.UnstealAbilityC2SPacket;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.network.packet.s2c.SyncVisualDataS2CPacket;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.PlayerUtil;
import radon.jujutsu_kaisen.util.SorcererUtil;

public class SorcererData
implements ISorcererData {
    private boolean initialized;
    private int cursedEnergyColor;
    private int points;
    private final Set<Ability> unlocked = new HashSet<Ability>();
    private float domainSize = 1.0f;
    @Nullable
    private CursedTechnique technique;
    @Nullable
    private CursedTechnique additional;
    private Set<CursedTechnique> copied;
    @Nullable
    private CursedTechnique currentCopied;
    private Set<CursedTechnique> stolen;
    @Nullable
    private CursedTechnique currentStolen;
    private final Set<CursedTechnique> absorbed;
    @Nullable
    private CursedTechnique currentAbsorbed;
    private GameProfile stolenSkinProfile;
    private ResourceLocation stolenSkinTexture;
    private int transfiguredSouls;
    private CursedEnergyNature nature = CursedEnergyNature.BASIC;
    private float experience;
    private float output = 1.0f;
    private float energy;
    private int dashes = 0;
    private int shieldTicks = 0;
    private float maxEnergy;
    private float extraEnergy;
    private float additionalEnergy;
    private JujutsuType type = JujutsuType.SORCERER;
    private int silenced;
    private int disarmed;
    private int disable;
    private int selfHit;
    private int burnout;
    private int brainDamage;
    private int brainDamageTimer;
    private long lastBlackFlashTime = -1L;
    private boolean addBlackFlash = false;
    @Nullable
    private Ability channeled;
    private int charge;
    private final Set<Ability> toggled;
    private final Set<Trait> traits;
    private final List<DelayedTickEvent> delayedTickEvents;
    private final Map<Ability, Integer> cooldowns;
    private final Map<Ability, Integer> durations;
    private final Map<Ability, Integer> disrupted;
    private final Set<Integer> summons;
    private final Map<UUID, Set<Pact>> acceptedPacts;
    private final Map<UUID, Set<Pact>> requestedPactsCreations;
    private final Map<UUID, Integer> createRequestExpirations;
    private final Map<UUID, Set<Pact>> requestedPactsRemovals;
    private final Set<BindingVow> bindingVows;
    private final Map<BindingVow, Integer> bindingVowCooldowns;
    private final Map<Ability, Set<String>> chants;
    private final List<AbsorbedCurse> curses;
    private final List<AbstractMap.SimpleEntry<Vec3, Float>> frames;
    private int speedStacks;
    private int noMotionTime;
    private int fingers;
    private static final UUID MAX_HEALTH_UUID = UUID.fromString("72ff5080-3a82-4a03-8493-3be970039cfe");
    private static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("4979087e-da76-4f8a-93ef-6e5847bfa2ee");
    private static final UUID ATTACK_SPEED_UUID = UUID.fromString("a2aef906-ed31-49e8-a56c-decccbfa2c1f");
    private static final UUID MOVEMENT_SPEED_UUID = UUID.fromString("9fe023ca-f22b-4429-a5e5-c099387d5441");
    private static final UUID PROJECTION_SORCERY_MOVEMENT_SPEED_UUID = UUID.fromString("23ecaba3-fbe8-44c1-93c4-5291aa9ee777");
    private static final UUID PROJECTION_ATTACK_SPEED_UUID = UUID.fromString("18cd1e25-656d-4172-b9f7-2f1b3daf4b89");
    private static final UUID PROJECTION_STEP_HEIGHT_UUID = UUID.fromString("1dbcbef7-8193-406a-b64d-8766ea505fdb");
    private LivingEntity owner;

    public SorcererData() {
        this.copied = new LinkedHashSet<CursedTechnique>();
        this.absorbed = new LinkedHashSet<CursedTechnique>();
        this.stolen = new LinkedHashSet<CursedTechnique>();
        this.toggled = new HashSet<Ability>();
        this.traits = new HashSet<Trait>();
        this.delayedTickEvents = new ArrayList<DelayedTickEvent>();
        this.cooldowns = new HashMap<Ability, Integer>();
        this.disrupted = new HashMap<Ability, Integer>();
        this.durations = new HashMap<Ability, Integer>();
        this.summons = new HashSet<Integer>();
        this.acceptedPacts = new HashMap<UUID, Set<Pact>>();
        this.requestedPactsCreations = new HashMap<UUID, Set<Pact>>();
        this.createRequestExpirations = new HashMap<UUID, Integer>();
        this.requestedPactsRemovals = new HashMap<UUID, Set<Pact>>();
        this.bindingVows = new HashSet<BindingVow>();
        this.bindingVowCooldowns = new HashMap<BindingVow, Integer>();
        this.chants = new HashMap<Ability, Set<String>>();
        this.curses = new ArrayList<AbsorbedCurse>();
        this.frames = new ArrayList<AbstractMap.SimpleEntry<Vec3, Float>>();
    }

    private void sync() {
        if (!this.owner.m_9236_().f_46443_) {
            ClientVisualHandler.ClientData data = new ClientVisualHandler.ClientData(this.getToggled(), this.channeled, this.getTraits(), this.getTechniques(), this.getTechnique(), this.getType(), this.getExperience(), this.getCursedEnergyColor());
            PacketHandler.broadcast(new SyncVisualDataS2CPacket(this.owner.m_20148_(), data.serializeNBT()));
        }
    }

    private void updateCooldowns() {
        Iterator<Map.Entry<Ability, Integer>> iter = this.cooldowns.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Ability, Integer> entry = iter.next();
            int remaining = entry.getValue();
            if (remaining > 0) {
                this.cooldowns.put(entry.getKey(), --remaining);
                continue;
            }
            iter.remove();
        }
    }

    private void updateDurations() {
        Iterator<Map.Entry<Ability, Integer>> iter = this.durations.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Ability, Integer> entry = iter.next();
            Ability ability = entry.getKey();
            if (!this.isChanneling(ability)) {
                iter.remove();
                continue;
            }
            int remaining = entry.getValue();
            if (remaining >= 0) {
                this.durations.put(entry.getKey(), --remaining);
                continue;
            }
            if (ability instanceof Ability.IToggled) {
                if (this.hasToggled(ability)) {
                    this.toggle(ability);
                }
            } else if (ability instanceof Ability.IChannelened && this.isChanneling(ability)) {
                this.channel(ability);
            }
            iter.remove();
        }
    }

    private void updateTickEvents() {
        this.delayedTickEvents.removeIf(DelayedTickEvent::finished);
        for (DelayedTickEvent current : new ArrayList<DelayedTickEvent>(this.delayedTickEvents)) {
            current.tick();
            if (!current.finished()) continue;
            current.run();
        }
    }

    private void updateToggled() {
        ArrayList<Ability> remove = new ArrayList<Ability>();
        for (Ability ability : new ArrayList<Ability>(this.toggled)) {
            if (this.disrupted.containsKey(ability)) {
                remove.add(ability);
                continue;
            }
            Ability.Status status = ability.isStillUsable(this.owner);
            if (status == Ability.Status.SUCCESS || status == Ability.Status.COOLDOWN || status == Ability.Status.ENERGY && ability instanceof Ability.IAttack) {
                ability.run(this.owner);
                ((Ability.IToggled)((Object)ability)).applyModifiers(this.owner);
                continue;
            }
            remove.add(ability);
        }
        for (Ability ability : remove) {
            this.toggle(ability);
        }
    }

    private void updateChanneled() {
        if (this.channeled != null) {
            if (this.disrupted.containsKey(this.channeled)) {
                return;
            }
            Ability.Status status = this.channeled.isStillUsable(this.owner);
            if (status == Ability.Status.SUCCESS || status == Ability.Status.COOLDOWN || status == Ability.Status.ENERGY && this.channeled instanceof Ability.IAttack) {
                this.channeled.run(this.owner);
            } else {
                this.channel(this.channeled);
            }
            ++this.charge;
        } else {
            this.charge = 0;
        }
    }

    private void updateSummons() {
        if (!this.owner.m_9236_().m_46749_(this.owner.m_20183_())) {
            return;
        }
        Level level = this.owner.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Iterator<Integer> iter = this.summons.iterator();
            while (iter.hasNext()) {
                Integer identifier = iter.next();
                Entity entity = level2.m_6815_(identifier.intValue());
                if (entity != null && entity.m_6084_() && !entity.m_213877_()) continue;
                iter.remove();
            }
        }
    }

    private void updateRequestExpirations() {
        Iterator<Map.Entry<UUID, Integer>> iter = this.createRequestExpirations.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<UUID, Integer> entry = iter.next();
            int remaining = entry.getValue();
            if (remaining > 0) {
                this.createRequestExpirations.put(entry.getKey(), --remaining);
                continue;
            }
            iter.remove();
            this.requestedPactsCreations.remove(entry.getKey());
        }
    }

    private void updateBindingVowCooldowns() {
        Iterator<Map.Entry<BindingVow, Integer>> iter = this.bindingVowCooldowns.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<BindingVow, Integer> entry = iter.next();
            int remaining = entry.getValue();
            if (remaining > 0) {
                this.bindingVowCooldowns.put(entry.getKey(), --remaining);
                continue;
            }
            iter.remove();
            this.bindingVowCooldowns.remove((Object)entry.getKey());
        }
    }

    private void updateBrainDamage() {
        if (this.brainDamage == 0) {
            return;
        }
        if (!this.owner.m_9236_().f_46443_) {
            this.owner.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, this.brainDamage - 1, false, false, false));
        }
        ++this.brainDamageTimer;
        if (this.brainDamageTimer >= 140) {
            this.brainDamageTimer = 0;
            --this.brainDamage;
            this.output = this.getMaximumOutput();
        }
    }

    private void checkAdvancements(ServerPlayer player) {
        if (this.traits.contains((Object)Trait.SIX_EYES)) {
            PlayerUtil.giveAdvancement(player, "six_eyes");
        }
        if (this.traits.contains((Object)Trait.HEAVENLY_RESTRICTION)) {
            PlayerUtil.giveAdvancement(player, "heavenly_restriction");
        }
        if (this.traits.contains((Object)Trait.VESSEL)) {
            PlayerUtil.giveAdvancement(player, "vessel");
        }
        if (this.unlocked.contains(JJKAbilities.RCT1.get())) {
            PlayerUtil.giveAdvancement(player, "reverse_cursed_technique");
        }
        if (this.traits.contains((Object)Trait.PERFECT_BODY)) {
            PlayerUtil.giveAdvancement(player, "perfect_body");
        }
    }

    @Override
    public void attack(DamageSource source, LivingEntity target) {
        Ability ability = this.channeled;
        if (ability instanceof Ability.IAttack) {
            Ability.IAttack attack = (Ability.IAttack)((Object)ability);
            if (this.channeled.getStatus(this.owner) == Ability.Status.SUCCESS && attack.attack(source, this.owner, target)) {
                this.channeled.charge(this.owner);
                this.charge = 0;
            }
        }
        for (Ability ability2 : this.toggled) {
            if (target.m_21224_()) break;
            if (!(ability2 instanceof Ability.IAttack)) continue;
            Ability.IAttack attack = (Ability.IAttack)((Object)ability2);
            if (ability2.getStatus(this.owner) != Ability.Status.SUCCESS || !attack.attack(source, this.owner, target)) continue;
            ability2.charge(this.owner);
        }
        if ((ability = this.owner) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)ability;
            PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(this.serializeNBT()), player);
        }
    }

    private void updateDisrupted() {
        Iterator<Map.Entry<Ability, Integer>> iter = this.disrupted.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Ability, Integer> entry = iter.next();
            int remaining = entry.getValue();
            if (remaining > 0) {
                this.disrupted.put(entry.getKey(), --remaining);
                continue;
            }
            iter.remove();
        }
    }

    @Override
    public void tick(LivingEntity owner) {
        float f;
        ServerPlayer player;
        LivingEntity livingEntity;
        if (this.owner == null) {
            this.owner = owner;
        }
        this.updateSummons();
        this.updateCooldowns();
        this.updateDurations();
        this.updateTickEvents();
        this.updateToggled();
        this.updateChanneled();
        this.updateDisrupted();
        this.updateRequestExpirations();
        this.updateBindingVowCooldowns();
        this.updateBrainDamage();
        if (Slam.TARGETS.containsKey(owner.m_20148_()) && (owner.m_20096_() || owner.m_20069_())) {
            Slam.onHitGround(owner, 0.0f);
        }
        if (!this.owner.m_9236_().f_46443_) {
            if (this.speedStacks > 0) {
                EntityUtil.applyModifier(this.owner, Attributes.f_22279_, PROJECTION_SORCERY_MOVEMENT_SPEED_UUID, "Movement speed", (double)this.speedStacks * 0.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
                EntityUtil.applyModifier(this.owner, Attributes.f_22283_, PROJECTION_ATTACK_SPEED_UUID, "Attack speed", this.speedStacks, AttributeModifier.Operation.MULTIPLY_TOTAL);
                EntityUtil.applyModifier(this.owner, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), PROJECTION_STEP_HEIGHT_UUID, "Step height addition", 2.0, AttributeModifier.Operation.ADDITION);
                ++this.noMotionTime;
                if (this.noMotionTime > 400) {
                    this.lowerSpeedStacks();
                }
            } else {
                EntityUtil.removeModifier(this.owner, Attributes.f_22279_, PROJECTION_SORCERY_MOVEMENT_SPEED_UUID);
                EntityUtil.removeModifier(this.owner, Attributes.f_22283_, PROJECTION_ATTACK_SPEED_UUID);
                EntityUtil.removeModifier(this.owner, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), PROJECTION_STEP_HEIGHT_UUID);
            }
            if ((livingEntity = this.owner) instanceof ServerPlayer) {
                player = (ServerPlayer)livingEntity;
                if (!this.initialized) {
                    this.initialized = true;
                    this.generate(player);
                }
                this.checkAdvancements(player);
            }
        }
        if (this.burnout > 0) {
            --this.burnout;
        }
        if (this.disable > 0) {
            --this.disable;
        }
        if (this.selfHit > 0) {
            --this.selfHit;
        }
        if (this.disarmed > 0) {
            --this.disarmed;
        }
        if (this.silenced > 0) {
            --this.silenced;
        }
        float f2 = ((Double)ConfigHolder.SERVER.cursedEnergyRegenerationAmount.get()).floatValue();
        livingEntity = this.owner;
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            f = (float)player.m_36324_().m_38702_() / 20.0f;
        } else {
            f = 1.0f;
        }
        this.energy = Math.min(this.energy + f2 * f, this.getMaxEnergy());
        if (this.traits.contains((Object)Trait.HEAVENLY_RESTRICTION)) {
            double health = Math.ceil((double)(this.getRealPower() - 1.0f) * 15.0 / 20.0) * 20.0 + 40.0;
            if ((double)this.owner.m_21233_() < health && EntityUtil.applyModifier(this.owner, Attributes.f_22276_, MAX_HEALTH_UUID, "Max health", health, AttributeModifier.Operation.ADDITION)) {
                this.owner.m_21153_(this.owner.m_21233_());
            }
            double damage = (double)this.getRealPower() * 3.9;
            EntityUtil.applyModifier(this.owner, Attributes.f_22281_, ATTACK_DAMAGE_UUID, "Attack damage", damage, AttributeModifier.Operation.ADDITION);
            double speed = this.getRealPower();
            EntityUtil.applyModifier(this.owner, Attributes.f_22283_, ATTACK_SPEED_UUID, "Attack speed", speed, AttributeModifier.Operation.ADDITION);
            float ratio = owner.m_21223_() / owner.m_21233_();
            double movement = (double)this.getRealPower() * 0.3;
            if ((double)ratio <= 0.5 && (double)ratio > 0.35) {
                movement *= 0.4;
            }
            if ((double)ratio <= 0.35 && (double)ratio > 0.2) {
                movement *= 0.25;
            }
            if ((double)ratio <= 0.2) {
                movement *= 0.15;
            }
            EntityUtil.applyModifier(this.owner, Attributes.f_22279_, MOVEMENT_SPEED_UUID, "Movement speed", Math.min(0.8, movement), AttributeModifier.Operation.ADDITION);
            if (this.owner.m_21223_() != this.owner.m_21233_()) {
                this.owner.m_5634_(0.022499999f);
            }
            EntityUtil.applyModifier(this.owner, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), PROJECTION_STEP_HEIGHT_UUID, "Step height addition", 2.0, AttributeModifier.Operation.ADDITION);
            if (!owner.m_9236_().m_8055_(owner.m_20183_()).m_60819_().m_76178_() && this.getDash() > 0) {
                Vec3 motion = owner.m_20184_();
                if (motion.f_82480_ < 0.0) {
                    double amount = 0.01;
                    if (owner.m_20069_()) {
                        amount = 0.15;
                    }
                    owner.m_20334_(motion.f_82479_, amount, motion.f_82481_);
                }
                owner.m_6853_(true);
            }
        } else {
            double health = Math.ceil((double)(this.getRealPower() - 1.0f) * 15.0 / 20.0) * 20.0 + 40.0;
            double damage = (double)this.getRealPower() * 1.0;
            LivingEntity livingEntity2 = this.owner;
            if (livingEntity2 instanceof Player) {
                Player player2 = (Player)livingEntity2;
                damage = (double)this.getRealPower() * 2.0;
            }
            EntityUtil.applyModifier(this.owner, Attributes.f_22281_, ATTACK_DAMAGE_UUID, "Attack damage", damage, AttributeModifier.Operation.ADDITION);
            if ((double)this.owner.m_21233_() != health && EntityUtil.applyModifier(this.owner, Attributes.f_22276_, MAX_HEALTH_UUID, "Max health", health, AttributeModifier.Operation.ADDITION)) {
                this.owner.m_21153_(this.owner.m_21233_());
            }
        }
    }

    @Override
    public void init(LivingEntity owner) {
        this.owner = owner;
    }

    @Override
    public int getCursedEnergyColor() {
        return this.cursedEnergyColor == 0 ? HelperMethods.getRGB24(ParticleColors.getCursedEnergyColor(this.type)) : this.cursedEnergyColor;
    }

    @Override
    public void setCursedEnergyColor(int color) {
        this.cursedEnergyColor = color;
        this.sync();
    }

    @Override
    public void disrupt(Ability ability, int duration) {
        this.disrupted.put(ability, duration);
    }

    @Override
    public float getMaximumOutput() {
        float output = 1.0f;
        if (this.toggled.contains(JJKAbilities.MYTHICAL_BEAST_AMBER.get())) {
            output = 1.5f;
        } else if (this.owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof HitenStaffItem && !this.traits.contains((Object)Trait.HEAVENLY_RESTRICTION)) {
            output = 1.1f;
        } else if (this.isInZone()) {
            output = 1.2f;
        } else if (this.traits.contains((Object)Trait.SIMURIAN)) {
            output = 1.1f;
        }
        return output * (1.0f - (float)this.brainDamage / 10.0f);
    }

    @Override
    public void increaseOutput() {
        this.output = Math.min(this.getMaximumOutput(), this.output + 0.1f);
    }

    @Override
    public void decreaseOutput() {
        this.output = Math.max(0.1f, this.output - 0.1f);
    }

    @Override
    public void maxOutput() {
        this.output = this.getMaximumOutput();
    }

    @Override
    public int getPoints() {
        return this.points;
    }

    @Override
    public void setPoints(int points) {
        this.points = points;
    }

    @Override
    public void addPoints(int points) {
        this.points += points;
    }

    @Override
    public void usePoints(int count) {
        this.points -= count;
    }

    @Override
    public boolean isUnlocked(Ability ability) {
        return this.unlocked.contains(ability);
    }

    @Override
    public void lock(Ability ability) {
        this.unlocked.remove(ability);
    }

    @Override
    public void unlock(Ability ability) {
        this.unlocked.add(ability);
    }

    @Override
    public void unlockAll(List<Ability> abilities) {
        this.unlocked.addAll(abilities);
    }

    @Override
    public void lockAll() {
        this.unlocked.clear();
    }

    @Override
    public void createPact(UUID recipient, Pact pact) {
        if (!this.acceptedPacts.containsKey(recipient)) {
            this.acceptedPacts.put(recipient, new HashSet());
        }
        this.acceptedPacts.get(recipient).add(pact);
    }

    @Override
    public void setStolenSkinProfile(GameProfile profile) {
        this.stolenSkinProfile = profile;
    }

    @Override
    public GameProfile getStolenSkinProfile() {
        return this.stolenSkinProfile;
    }

    @Override
    public void setStolenSkinTexture(ResourceLocation skin) {
        this.stolenSkinTexture = skin;
    }

    @Override
    public ResourceLocation getStolenSkinTexture() {
        return this.stolenSkinTexture;
    }

    @Override
    public boolean hasPact(UUID recipient, Pact pact) {
        return this.acceptedPacts.getOrDefault(recipient, Set.of()).contains((Object)pact);
    }

    @Override
    public void removePact(UUID recipient, Pact pact) {
        this.acceptedPacts.get(recipient).remove((Object)pact);
        if (this.acceptedPacts.get(recipient).isEmpty()) {
            this.acceptedPacts.remove(recipient);
        }
    }

    @Override
    public void createPactCreationRequest(UUID recipient, Pact pact) {
        if (!this.requestedPactsCreations.containsKey(recipient)) {
            this.requestedPactsCreations.put(recipient, new HashSet());
        }
        this.requestedPactsCreations.get(recipient).add(pact);
        this.createRequestExpirations.put(recipient, 600);
    }

    @Override
    public void createPactRemovalRequest(UUID recipient, Pact pact) {
        if (!this.requestedPactsRemovals.containsKey(recipient)) {
            this.requestedPactsRemovals.put(recipient, new HashSet());
        }
        this.requestedPactsRemovals.get(recipient).add(pact);
    }

    @Override
    public int getShieldTicks() {
        return this.shieldTicks;
    }

    @Override
    public void setShieldTicks(int ticks) {
        this.shieldTicks = ticks;
    }

    @Override
    public void removePactCreationRequest(UUID recipient, Pact pact) {
        ((Set)this.requestedPactsCreations.getOrDefault(recipient, new HashSet())).remove((Object)pact);
        this.createRequestExpirations.remove(recipient);
    }

    @Override
    public void removePactRemovalRequest(UUID recipient, Pact pact) {
        ((Set)this.requestedPactsRemovals.getOrDefault(recipient, new HashSet())).remove((Object)pact);
    }

    @Override
    public boolean hasRequestedPactCreation(UUID recipient, Pact pact) {
        return this.requestedPactsCreations.getOrDefault(recipient, Set.of()).contains((Object)pact);
    }

    @Override
    public boolean hasRequestedPactRemoval(UUID recipient, Pact pact) {
        return this.requestedPactsRemovals.getOrDefault(recipient, Set.of()).contains((Object)pact);
    }

    @Override
    public void addBindingVow(BindingVow vow) {
        this.bindingVows.add(vow);
    }

    @Override
    public void removeBindingVow(BindingVow vow) {
        this.bindingVows.remove((Object)vow);
    }

    @Override
    public boolean hasBindingVow(BindingVow vow) {
        return this.bindingVows.contains((Object)vow);
    }

    @Override
    public void addBindingVowCooldown(BindingVow vow) {
        this.bindingVowCooldowns.put(vow, 36000);
    }

    @Override
    public int getRemainingCooldown(BindingVow vow) {
        return this.bindingVowCooldowns.get((Object)vow);
    }

    @Override
    public boolean isCooldownDone(BindingVow vow) {
        return !this.bindingVowCooldowns.containsKey((Object)vow);
    }

    @Override
    public void addChant(Ability ability, String chant) {
        if (!this.chants.containsKey(ability)) {
            this.chants.put(ability, new LinkedHashSet());
        }
        this.chants.get(ability).add(chant);
    }

    @Override
    public void addChants(Ability ability, Set<String> chants) {
        this.chants.put(ability, chants);
    }

    @Override
    public void removeChant(Ability ability, String chant) {
        if (this.chants.containsKey(ability)) {
            this.chants.get(ability).remove(chant);
            if (this.chants.get(ability).isEmpty()) {
                this.chants.remove(ability);
            }
        }
    }

    @Override
    public boolean hasChant(Ability ability, String chant) {
        ArrayList<String> chants = new ArrayList<String>(this.chants.getOrDefault(ability, Set.of()));
        if (chants.contains(chant)) {
            return true;
        }
        chants.add(chant);
        for (Map.Entry<Ability, Set<String>> entry : this.chants.entrySet()) {
            if (entry.getKey() == ability) continue;
            ArrayList current = new ArrayList(entry.getValue());
            for (int i = 0; i < chants.size() && i <= current.size() - 1; ++i) {
                if (!((String)chants.get(i)).equals(current.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isChantsAvailable(Set<String> chants) {
        for (Set<String> entry : this.chants.values()) {
            if (!entry.containsAll(chants)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Ability getAbility(String chant) {
        for (Map.Entry<Ability, Set<String>> entry : this.chants.entrySet()) {
            if (!entry.getValue().contains(chant)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    @Nullable
    public Ability getAbility(Set<String> chants) {
        for (Map.Entry<Ability, Set<String>> entry : this.chants.entrySet()) {
            if (!entry.getValue().equals(chants)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Set<String> getFirstChants() {
        return this.chants.values().stream().map(set -> (String)set.stream().findFirst().orElseThrow()).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getFirstChants(Ability ability) {
        return this.chants.getOrDefault(ability, Set.of());
    }

    @Override
    public float getOutput() {
        return Math.min(this.getMaximumOutput(), this.output);
    }

    @Override
    public float getAbilityPower() {
        float power = this.getRealPower() * this.getOutput();
        CursedTechnique tech = this.technique;
        if (tech != null) {
            Ability domain = this.technique.getDomain();
            if (tech == CursedTechnique.BRAIN_TRANSPLANT && this.getCurrentStolen() != null) {
                domain = this.getCurrentStolen().getDomain();
            }
            if (domain != null && this.toggled.contains(domain)) {
                power *= 1.2f;
            }
        }
        return power;
    }

    @Override
    public float getRealPower() {
        return SorcererUtil.getPower(this.experience);
    }

    @Override
    public float getRealPower(float exp) {
        return SorcererUtil.getPower(exp);
    }

    @Override
    public float getExperience() {
        return this.experience;
    }

    @Override
    public void setExperience(float experience) {
        this.experience = experience;
        this.sync();
    }

    @Override
    public boolean addExperience(float amount) {
        SorcererGrade previous = SorcererUtil.getGrade(this.experience);
        if (this.experience >= ((Double)ConfigHolder.SERVER.maximumExperienceAmount.get()).floatValue()) {
            return false;
        }
        this.experience = Math.min(((Double)ConfigHolder.SERVER.maximumExperienceAmount.get()).floatValue(), this.experience + amount);
        SorcererGrade current = SorcererUtil.getGrade(this.experience);
        if (!this.owner.m_9236_().f_46443_ && this.owner instanceof Player && previous != current) {
            this.owner.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.rank_up", "jujutsu_kaisen"), (Object[])new Object[]{current.getName()}));
        }
        this.sync();
        return true;
    }

    @Override
    public float getDomainSize() {
        return this.domainSize;
    }

    @Override
    public void setDomainSize(float domainSize) {
        this.domainSize = domainSize;
    }

    @Override
    @Nullable
    public CursedTechnique getTechnique() {
        return this.technique;
    }

    @Override
    public Set<CursedTechnique> getTechniques() {
        HashSet<CursedTechnique> techniques = new HashSet<CursedTechnique>();
        if (this.getTechnique() != null) {
            techniques.add(this.getTechnique());
        }
        if (this.getCurrentCopied() != null) {
            techniques.add(this.getCurrentCopied());
        }
        if (this.getCurrentAbsorbed() != null) {
            techniques.add(this.getCurrentAbsorbed());
        }
        if (this.getCurrentStolen() != null) {
            techniques.add(this.getCurrentStolen());
        }
        if (this.getAdditional() != null) {
            techniques.add(this.getAdditional());
        }
        return techniques;
    }

    @Override
    public boolean hasTechnique(CursedTechnique technique) {
        return this.technique == technique || this.additional == technique || this.getCurrentCopied() == technique || this.currentAbsorbed == technique || this.currentStolen == technique;
    }

    @Override
    public void setTechnique(@Nullable CursedTechnique technique) {
        this.technique = technique;
        this.sync();
        for (Ability ability : new ArrayList<Ability>(this.unlocked)) {
            if (ability.isDisplayed(this.owner)) continue;
            this.lock(ability);
        }
    }

    @Override
    public CursedEnergyNature getNature() {
        return this.nature;
    }

    @Override
    public void setNature(CursedEnergyNature nature) {
        this.nature = nature;
    }

    @Override
    public void setGrade(SorcererGrade grade) {
        this.experience = grade.getRequiredExperience();
    }

    @Override
    public boolean hasTrait(Trait trait) {
        return this.traits.contains((Object)trait);
    }

    @Override
    public void addTrait(Trait trait) {
        this.traits.add(trait);
        this.sync();
    }

    @Override
    public void addTraits(List<Trait> traits) {
        this.traits.addAll(traits);
        this.sync();
    }

    @Override
    public void removeTrait(Trait trait) {
        this.traits.remove((Object)trait);
        this.sync();
    }

    @Override
    public Set<Trait> getTraits() {
        return this.traits;
    }

    @Override
    public void setTraits(Set<Trait> traits) {
        this.traits.clear();
        this.traits.addAll(traits);
        this.sync();
    }

    @Override
    public void setType(JujutsuType type) {
        this.type = type;
        this.sync();
    }

    @Override
    public JujutsuType getType() {
        return this.type;
    }

    @Override
    public void toggle(Ability ability) {
        if (!this.owner.m_9236_().f_46443_ && this.owner instanceof Player && ability.shouldLog(this.owner)) {
            if (this.hasToggled(ability)) {
                this.owner.m_213846_(ability.getDisableMessage());
            } else {
                this.owner.m_213846_(ability.getEnableMessage());
            }
        }
        if (this.toggled.contains(ability)) {
            this.toggled.remove(ability);
            ((Ability.IToggled)((Object)ability)).onDisabled(this.owner);
            ((Ability.IToggled)((Object)ability)).removeModifiers(this.owner);
            MinecraftForge.EVENT_BUS.post((Event)new AbilityStopEvent(this.owner, ability));
        } else {
            this.toggled.add(ability);
            ((Ability.IToggled)((Object)ability)).onEnabled(this.owner);
        }
        this.sync();
    }

    @Override
    public void clearToggled() {
        this.toggled.clear();
    }

    @Override
    public Set<Ability> getToggled() {
        return this.toggled;
    }

    @Override
    public void addCooldown(Ability ability) {
        this.cooldowns.put(ability, ability.getRealCooldown(this.owner));
    }

    @Override
    public void setCooldown(Ability ability, int time) {
        this.cooldowns.put(ability, time);
    }

    @Override
    public void clearCooldown(Ability ability) {
        this.cooldowns.put(ability, 1);
    }

    @Override
    public int getRemainingCooldown(Ability ability) {
        return this.cooldowns.getOrDefault(ability, 0);
    }

    @Override
    public boolean isCooldownDone(Ability ability) {
        return !this.cooldowns.containsKey(ability);
    }

    @Override
    public void addDuration(Ability ability) {
        this.durations.put(ability, ((Ability.IDurationable)((Object)ability)).getRealDuration(this.owner));
    }

    @Override
    public void increaseBrainDamage() {
        this.brainDamage = Math.min(10, this.brainDamage + 1);
    }

    @Override
    public int getBrainDamage() {
        return this.brainDamage;
    }

    @Override
    public void setBurnout(int duration) {
        this.burnout = duration;
    }

    @Override
    public void setDisable(int duration) {
        if (this.getDisable() >= duration) {
            return;
        }
        this.disable = duration;
    }

    @Override
    public void setDisarmed(int disarmed) {
        if (this.getDisarmed() >= disarmed) {
            return;
        }
        this.disarmed = disarmed;
    }

    @Override
    public void setSilenced(int silenced) {
        if (this.getSilenced() >= silenced) {
            return;
        }
        this.silenced = silenced;
    }

    @Override
    public void setSelfHit(int duration) {
        this.selfHit = duration;
    }

    @Override
    public int getBurnout() {
        return this.burnout;
    }

    @Override
    public int getDisable() {
        return this.disable;
    }

    @Override
    public int getDisarmed() {
        return this.disarmed;
    }

    @Override
    public int getSilenced() {
        return this.silenced;
    }

    @Override
    public int getSelfHit() {
        return this.selfHit;
    }

    @Override
    public boolean hasBurnout() {
        return this.burnout > 0;
    }

    @Override
    public boolean hasDisable() {
        return this.disable > 0;
    }

    @Override
    public boolean hasDisarmed() {
        return this.disarmed > 0;
    }

    @Override
    public boolean hasSelfHit() {
        return this.selfHit > 0;
    }

    @Override
    public boolean hasSilenced() {
        return this.silenced > 0;
    }

    @Override
    public void resetCooldowns() {
        this.cooldowns.clear();
    }

    @Override
    public void resetBurnout() {
        this.burnout = 0;
    }

    @Override
    public void resetDisable() {
        this.disable = 0;
    }

    @Override
    public void resetDisarmed() {
        this.disarmed = 0;
    }

    @Override
    public void resetSilenced() {
        this.silenced = 0;
    }

    @Override
    public void resetSelfHit() {
        this.selfHit = 0;
    }

    @Override
    public float getEnergy() {
        if (this.traits.contains((Object)Trait.HEAVENLY_RESTRICTION)) {
            return 0.0f;
        }
        return this.energy;
    }

    @Override
    public void addEnergy(float amount) {
        this.energy = Math.min(this.getMaxEnergy(), this.energy + amount);
        this.sync();
    }

    @Override
    public float getMaxEnergy() {
        long time = this.owner.m_9236_().m_6106_().m_6792_();
        boolean night = time >= 13000L && time < 24000L;
        float baseEnergy = this.maxEnergy == 0.0f ? ((Double)ConfigHolder.SERVER.cursedEnergyAmount.get()).floatValue() : this.maxEnergy;
        float baseCapacity = baseEnergy * this.getRealPower() * (float)Math.log(this.getRealPower() + 1.0f) * 0.5f;
        float maxEXP = this.getRealPower(((Double)ConfigHolder.SERVER.maximumExperienceAmount.get()).floatValue());
        float maxCapacity = baseEnergy * maxEXP * (float)Math.log(maxEXP + 1.0f) * 0.5f;
        float timeMultiplier = this.bindingVows.contains((Object)BindingVow.OVERTIME) ? (night ? 1.2f : 0.9f) : 1.0f;
        float finalEnergy = Math.min(maxCapacity * timeMultiplier, baseCapacity * timeMultiplier + this.extraEnergy);
        return finalEnergy += this.additionalEnergy;
    }

    @Override
    public void setMaxEnergy(float maxEnergy) {
        this.maxEnergy = maxEnergy;
    }

    @Override
    public void useEnergy(float amount) {
        this.energy -= amount;
    }

    @Override
    public void setEnergy(float energy) {
        this.energy = energy;
    }

    @Override
    public float getAdditionalEnergy() {
        return this.additionalEnergy;
    }

    @Override
    public void setAdditionalEnergy(float additionalEnergy) {
        this.additionalEnergy = additionalEnergy;
    }

    @Override
    public float getExtraEnergy() {
        return this.extraEnergy;
    }

    @Override
    public void addExtraEnergy(float amount) {
        this.extraEnergy += amount;
    }

    @Override
    public void resetExtraEnergy() {
        this.extraEnergy = 0.0f;
        this.extraEnergy = Math.min(this.maxEnergy * 0.25f, this.extraEnergy);
    }

    @Override
    public void onBlackFlash() {
        this.lastBlackFlashTime = this.owner.m_9236_().m_46467_();
        this.output = this.getMaximumOutput();
        this.energy += Math.max(750.0f, (this.getMaxEnergy() - this.energy * 2.0f) * 0.2f);
        LivingEntity livingEntity = this.owner;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PlayerUtil.giveAdvancement(player, "black_flash");
        }
    }

    @Override
    public long getLastBlackFlashTime() {
        return this.lastBlackFlashTime;
    }

    @Override
    public boolean addBlackFlash() {
        return this.addBlackFlash;
    }

    @Override
    public void moreBlackFlash(boolean bool) {
        this.addBlackFlash = bool;
    }

    @Override
    public void resetBlackFlash() {
        this.lastBlackFlashTime = -1L;
    }

    @Override
    public boolean isInZone() {
        return this.lastBlackFlashTime != -1L && (this.owner.m_9236_().m_46467_() - this.lastBlackFlashTime) / 20L < 75L;
    }

    @Override
    public void delayTickEvent(Runnable task, int delay) {
        this.delayedTickEvents.add(new DelayedTickEvent(task, delay));
    }

    @Override
    public void uncopy(CursedTechnique technique) {
        this.copied.remove((Object)technique);
    }

    @Override
    public void unsteal(CursedTechnique technique) {
        this.stolen.remove((Object)technique);
    }

    @Override
    public void resetCopy() {
        this.copied = new LinkedHashSet<CursedTechnique>();
        this.sync();
    }

    @Override
    public void resetSteal() {
        this.stolen = new LinkedHashSet<CursedTechnique>();
        this.sync();
    }

    @Override
    public void copy(@Nullable CursedTechnique technique) {
        this.copied.add(technique);
    }

    @Override
    public void steal(@Nullable CursedTechnique technique) {
        this.stolen.add(technique);
    }

    @Override
    public Set<CursedTechnique> getCopied() {
        if (!this.hasToggled((Ability)JJKAbilities.RIKA.get()) || !this.hasTechnique(CursedTechnique.MIMICRY)) {
            return Set.of();
        }
        return this.copied;
    }

    @Override
    public Set<CursedTechnique> getStolen() {
        if (!this.hasTechnique(CursedTechnique.BRAIN_TRANSPLANT)) {
            return Set.of();
        }
        return this.stolen;
    }

    @Override
    public CursedTechnique getLastStolen() {
        if (this.stolen.isEmpty()) {
            return null;
        }
        CursedTechnique last = null;
        Iterator<CursedTechnique> iterator = this.stolen.iterator();
        while (iterator.hasNext()) {
            CursedTechnique tech;
            last = tech = iterator.next();
        }
        return last;
    }

    @Override
    public CursedTechnique getLatestStolen() {
        if (this.stolen.isEmpty()) {
            return null;
        }
        return this.stolen.iterator().next();
    }

    @Override
    public void addStolen(CursedTechnique technique) {
        if (this.stolen.contains((Object)technique)) {
            if (this.owner.m_9236_().m_5776_()) {
                PacketHandler.sendToServer(new UnstealAbilityC2SPacket(technique));
            }
            this.stolen.remove((Object)technique);
        }
        this.stolen.add(technique);
        if (this.stolen.size() > (Integer)ConfigHolder.SERVER.maximumStolenTechniques.get()) {
            CursedTechnique first = this.stolen.iterator().next();
            if (this.owner.m_9236_().m_5776_()) {
                PacketHandler.sendToServer(new UnstealAbilityC2SPacket(first));
            }
            this.stolen.remove((Object)first);
        }
    }

    @Override
    public boolean hasStolen(CursedTechnique technique) {
        return this.stolen.contains((Object)technique);
    }

    @Override
    public void setCurrentCopied(@Nullable CursedTechnique technique) {
        this.currentCopied = this.currentCopied == technique ? null : technique;
        this.sync();
    }

    @Override
    public void setCurrentStolen(@Nullable CursedTechnique technique) {
        this.currentStolen = this.currentStolen == technique ? null : technique;
        this.sync();
    }

    @Override
    @Nullable
    public CursedTechnique getCurrentCopied() {
        if (!this.toggled.contains(JJKAbilities.RIKA.get())) {
            return null;
        }
        return this.currentCopied;
    }

    @Override
    @Nullable
    public CursedTechnique getCurrentStolen() {
        if (!this.hasTechnique(CursedTechnique.BRAIN_TRANSPLANT)) {
            return null;
        }
        return this.currentStolen;
    }

    @Override
    public void absorb(@Nullable CursedTechnique technique) {
        this.absorbed.add(technique);
    }

    @Override
    public void unabsorb(CursedTechnique technique) {
        this.absorbed.remove((Object)technique);
        this.currentAbsorbed = null;
    }

    @Override
    public Set<CursedTechnique> getAbsorbed() {
        if (!this.hasTechnique(CursedTechnique.CURSE_MANIPULATION)) {
            return Set.of();
        }
        return this.absorbed;
    }

    @Override
    public void setCurrentAbsorbed(@Nullable CursedTechnique technique) {
        this.currentAbsorbed = this.currentAbsorbed == technique ? null : technique;
        this.sync();
    }

    @Override
    @Nullable
    public CursedTechnique getCurrentAbsorbed() {
        if (!this.hasTechnique(CursedTechnique.CURSE_MANIPULATION)) {
            return null;
        }
        return this.currentAbsorbed;
    }

    @Override
    public int getTransfiguredSouls() {
        return this.transfiguredSouls;
    }

    @Override
    public void increaseTransfiguredSouls() {
        ++this.transfiguredSouls;
    }

    @Override
    public void decreaseTransfiguredSouls() {
        --this.transfiguredSouls;
    }

    @Override
    public void useTransfiguredSouls(int amount) {
        this.transfiguredSouls -= amount;
    }

    @Override
    @Nullable
    public Ability getChanneled() {
        return this.channeled;
    }

    @Override
    public void channel(@Nullable Ability ability) {
        if (this.channeled != null) {
            Ability.ICharged charged;
            ((Ability.IChannelened)((Object)this.channeled)).onStop(this.owner);
            Ability ability2 = this.channeled;
            if (ability2 instanceof Ability.ICharged && (charged = (Ability.ICharged)((Object)ability2)).onRelease(this.owner)) {
                this.channeled.charge(this.owner);
            }
            if (!this.owner.m_9236_().f_46443_ && this.channeled.shouldLog(this.owner)) {
                this.owner.m_213846_(this.channeled.getDisableMessage());
            }
            MinecraftForge.EVENT_BUS.post((Event)new AbilityStopEvent(this.owner, ability));
        }
        if (this.channeled == ability) {
            this.channeled = null;
        } else {
            this.channeled = ability;
            if (this.channeled != null) {
                ((Ability.IChannelened)((Object)this.channeled)).onStart(this.owner);
                if (!this.owner.m_9236_().f_46443_ && this.channeled.shouldLog(this.owner)) {
                    this.owner.m_213846_(this.channeled.getEnableMessage());
                }
            }
        }
        this.sync();
    }

    @Override
    public boolean isChanneling(Ability ability) {
        return this.channeled == ability;
    }

    @Override
    public int getCharge() {
        return this.charge;
    }

    @Override
    public void addSummon(Entity entity) {
        this.summons.add(entity.m_19879_());
    }

    @Override
    public void removeSummon(Entity entity) {
        this.summons.remove(entity.m_19879_());
    }

    @Override
    public List<Entity> getSummons() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Integer identifier : this.summons) {
            Entity entity = this.owner.m_9236_().m_6815_(identifier.intValue());
            if (entity == null) continue;
            entities.add(entity);
        }
        return entities;
    }

    @Override
    @Nullable
    public <T extends Entity> T getSummonByClass(Class<T> clazz) {
        EntityTypeTest test = EntityTypeTest.m_156916_(clazz);
        for (Integer identifier : this.summons) {
            Entity summon;
            Entity entity = this.owner.m_9236_().m_6815_(identifier.intValue());
            if (entity == null || (summon = (Entity)test.m_141992_((Object)entity)) == null) continue;
            return (T)summon;
        }
        return null;
    }

    @Override
    public <T extends Entity> void unsummonByClass(Class<T> clazz) {
        EntityTypeTest test = EntityTypeTest.m_156916_(clazz);
        Iterator<Integer> iter = this.summons.iterator();
        while (iter.hasNext()) {
            Entity summon;
            Integer identifier = iter.next();
            Entity entity = this.owner.m_9236_().m_6815_(identifier.intValue());
            if (entity == null || (summon = (Entity)test.m_141992_((Object)entity)) == null) continue;
            iter.remove();
            summon.m_146870_();
        }
    }

    @Override
    public <T extends Entity> void removeSummonByClass(Class<T> clazz) {
        EntityTypeTest test = EntityTypeTest.m_156916_(clazz);
        Iterator<Integer> iter = this.summons.iterator();
        while (iter.hasNext()) {
            Entity summon;
            Integer identifier = iter.next();
            Entity entity = this.owner.m_9236_().m_6815_(identifier.intValue());
            if (entity == null || (summon = (Entity)test.m_141992_((Object)entity)) == null) continue;
            iter.remove();
        }
    }

    @Override
    public <T extends Entity> boolean hasSummonOfClass(Class<T> clazz) {
        EntityTypeTest test = EntityTypeTest.m_156916_(clazz);
        for (Integer identifier : this.summons) {
            Entity summon;
            Entity entity = this.owner.m_9236_().m_6815_(identifier.intValue());
            if (entity == null || (summon = (Entity)test.m_141992_((Object)entity)) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addCurse(AbsorbedCurse curse) {
        this.curses.add(curse);
    }

    @Override
    public void removeCurse(AbsorbedCurse curse) {
        this.curses.remove(curse);
    }

    @Override
    public List<AbsorbedCurse> getCurses() {
        if (!this.hasTechnique(CursedTechnique.CURSE_MANIPULATION)) {
            return List.of();
        }
        ArrayList<AbsorbedCurse> sorted = new ArrayList<AbsorbedCurse>(this.curses);
        return sorted;
    }

    @Override
    @Nullable
    public AbsorbedCurse getCurse(EntityType<?> type) {
        for (AbsorbedCurse curse : this.getCurses()) {
            if (curse.getType() != type) continue;
            return curse;
        }
        return null;
    }

    @Override
    public boolean hasCurse(EntityType<?> type) {
        for (AbsorbedCurse curse : this.getCurses()) {
            if (curse.getType() != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<AbstractMap.SimpleEntry<Vec3, Float>> getFrames() {
        return this.frames;
    }

    @Override
    public void addFrame(Vec3 frame, float yaw) {
        this.frames.add(new AbstractMap.SimpleEntry<Vec3, Float>(frame, Float.valueOf(yaw)));
    }

    @Override
    public void removeFrame(AbstractMap.SimpleEntry<Vec3, Float> frame) {
        this.frames.remove(frame);
    }

    @Override
    public void resetFrames() {
        this.frames.clear();
    }

    @Override
    public void generate(ServerPlayer owner) {
        this.initialized = true;
        this.technique = null;
        this.nature = CursedEnergyNature.BASIC;
        this.traits.remove((Object)Trait.SIX_EYES);
        this.traits.remove((Object)Trait.HEAVENLY_RESTRICTION);
        this.traits.remove((Object)Trait.VESSEL);
        this.traits.remove((Object)Trait.PERFECT_BODY);
        this.traits.remove((Object)Trait.RCT_OUTPUT);
        this.traits.remove((Object)Trait.INCARNATED);
        HashSet<CursedTechnique> taken = new HashSet<CursedTechnique>();
        HashSet<Trait> traits = new HashSet<Trait>();
        if (((Boolean)ConfigHolder.SERVER.uniqueTraits.get()).booleanValue() || ((Boolean)ConfigHolder.SERVER.uniqueTraits.get()).booleanValue()) {
            GameProfileCache cache = owner.f_8924_.m_129927_();
            if (cache == null) {
                throw new NullPointerException();
            }
            for (GameProfileCache.GameProfileInfo info : cache.m_10976_()) {
                GameProfile profile = info.m_11028_();
                if (profile.getId() == owner.m_20148_()) continue;
                ServerPlayer player = owner.f_8924_.m_6846_().m_11255_(profile.getName());
                if (player == null) {
                    player = owner.f_8924_.m_6846_().m_215624_(profile);
                    owner.f_8924_.m_6846_().m_11224_(player);
                }
                if (!player.getCapability(SorcererDataHandler.INSTANCE).isPresent()) continue;
                ISorcererData cap = (ISorcererData)player.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                taken.addAll(cap.getTechniques());
                traits.addAll(cap.getTraits());
            }
        }
        if ((!((Boolean)ConfigHolder.SERVER.uniqueTraits.get()).booleanValue() || traits.contains((Object)Trait.HEAVENLY_RESTRICTION)) && HelperMethods.RANDOM.m_188503_(((Integer)ConfigHolder.SERVER.heavenlyRestrictionRarity.get()).intValue()) == 0) {
            this.addTrait(Trait.HEAVENLY_RESTRICTION);
        } else {
            List<CursedTechnique> unlockable = ConfigHolder.SERVER.getUnlockableTechniques();
            if (((Boolean)ConfigHolder.SERVER.uniqueTechniques.get()).booleanValue()) {
                unlockable.removeAll(taken);
            }
            this.technique = unlockable.get(HelperMethods.RANDOM.m_188503_(unlockable.size()));
            if (HelperMethods.RANDOM.m_188503_(((Integer)ConfigHolder.SERVER.cursedEnergyNatureRarity.get()).intValue()) == 0) {
                this.nature = HelperMethods.randomEnum(CursedEnergyNature.class, Set.of(CursedEnergyNature.BASIC));
                owner.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.nature", "jujutsu_kaisen"), (Object[])new Object[]{this.nature.getName()}));
            }
            JujutsuType jujutsuType = this.type = HelperMethods.RANDOM.m_188503_(((Integer)ConfigHolder.SERVER.curseRarity.get()).intValue()) == 0 ? JujutsuType.CURSE : JujutsuType.SORCERER;
            if ((!((Boolean)ConfigHolder.SERVER.uniqueTraits.get()).booleanValue() || traits.contains((Object)Trait.VESSEL)) && this.type == JujutsuType.SORCERER && HelperMethods.RANDOM.m_188503_(((Integer)ConfigHolder.SERVER.vesselRarity.get()).intValue()) == 0) {
                this.addTrait(Trait.VESSEL);
            }
            if ((!((Boolean)ConfigHolder.SERVER.uniqueTraits.get()).booleanValue() || traits.contains((Object)Trait.SIX_EYES)) && HelperMethods.RANDOM.m_188503_(((Integer)ConfigHolder.SERVER.sixEyesRarity.get()).intValue()) == 0) {
                this.addTrait(Trait.SIX_EYES);
            }
            if ((!((Boolean)ConfigHolder.SERVER.uniqueTraits.get()).booleanValue() || traits.contains((Object)Trait.PERFECT_BODY)) && HelperMethods.RANDOM.m_188503_(((Integer)ConfigHolder.SERVER.perfectBodyRarity.get()).intValue()) == 0) {
                this.addTrait(Trait.PERFECT_BODY);
            }
            if ((!((Boolean)ConfigHolder.SERVER.uniqueTraits.get()).booleanValue() || traits.contains((Object)Trait.RCT_OUTPUT)) && HelperMethods.RANDOM.m_188503_(((Integer)ConfigHolder.SERVER.rctOutputRarity.get()).intValue()) == 0) {
                this.addTrait(Trait.RCT_OUTPUT);
            }
            if ((!((Boolean)ConfigHolder.SERVER.uniqueTraits.get()).booleanValue() || traits.contains((Object)Trait.INCARNATED)) && HelperMethods.RANDOM.m_188503_(((Integer)ConfigHolder.SERVER.incarnatedRarity.get()).intValue()) == 0) {
                this.addTrait(Trait.INCARNATED);
            }
            assert (this.technique != null);
            owner.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.technique", "jujutsu_kaisen"), (Object[])new Object[]{this.technique.getName()}));
            if (this.type == JujutsuType.CURSE) {
                owner.m_213846_((Component)Component.m_237115_((String)String.format("chat.%s.curse", "jujutsu_kaisen")));
            } else {
                owner.m_213846_((Component)Component.m_237115_((String)String.format("chat.%s.sorcerer", "jujutsu_kaisen")));
            }
        }
        this.energy = this.getMaxEnergy();
        PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(this.serializeNBT()), owner);
    }

    @Override
    public int getSpeedStacks() {
        return this.speedStacks;
    }

    @Override
    public int getDash() {
        return this.dashes;
    }

    @Override
    public void addDash() {
        ++this.dashes;
    }

    @Override
    public void subDash() {
        --this.dashes;
    }

    @Override
    public void resetDash() {
        this.dashes = 0;
    }

    @Override
    public void addSpeedStack() {
        this.noMotionTime = 0;
        this.speedStacks = Math.min(5, this.speedStacks + 1);
    }

    @Override
    public void resetSpeedStacks() {
        this.speedStacks = 0;
        this.noMotionTime = 0;
    }

    @Override
    public void lowerSpeedStacks() {
        this.speedStacks = Math.min(0, this.speedStacks - 1);
        this.noMotionTime = 0;
    }

    @Override
    public int getFingers() {
        return this.fingers;
    }

    @Override
    public void setFingers(int count) {
        this.fingers = count;
    }

    @Override
    public int addFingers(int count) {
        int real = Math.min(count, 20 - this.fingers);
        this.fingers += real;
        return real;
    }

    @Override
    public boolean hasToggled(Ability ability) {
        return this.toggled.contains(ability);
    }

    @Override
    @Nullable
    public CursedTechnique getAdditional() {
        return this.additional;
    }

    @Override
    public void setAdditional(@Nullable CursedTechnique technique) {
        this.additional = technique;
        this.sync();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("initialized", this.initialized);
        nbt.m_128405_("cursed_energy_color", this.cursedEnergyColor);
        nbt.m_128405_("points", this.points);
        nbt.m_128350_("domain_size", this.domainSize);
        if (this.technique != null) {
            nbt.m_128405_("technique", this.technique.ordinal());
        }
        if (this.additional != null) {
            nbt.m_128405_("additional", this.additional.ordinal());
        }
        if (this.currentCopied != null) {
            nbt.m_128405_("current_copied", this.currentCopied.ordinal());
        }
        if (this.currentStolen != null) {
            nbt.m_128405_("current_stolen", this.currentStolen.ordinal());
        }
        if (nbt.m_128441_("current_absorbed")) {
            this.currentAbsorbed = CursedTechnique.values()[nbt.m_128451_("current_absorbed")];
        }
        nbt.m_128405_("transfigured_souls", this.transfiguredSouls);
        nbt.m_128405_("nature", this.nature.ordinal());
        nbt.m_128350_("experience", this.experience);
        nbt.m_128350_("output", this.output);
        nbt.m_128350_("energy", this.energy);
        nbt.m_128350_("max_energy", this.maxEnergy);
        nbt.m_128350_("extra_energy", this.extraEnergy);
        nbt.m_128350_("additional_energy", this.additionalEnergy);
        nbt.m_128405_("type", this.type.ordinal());
        nbt.m_128405_("burnout", this.burnout);
        nbt.m_128405_("disable", this.disable);
        nbt.m_128405_("disarmed", this.disarmed);
        nbt.m_128405_("silenced", this.silenced);
        nbt.m_128405_("self_hit", this.selfHit);
        nbt.m_128405_("brain_damage", this.brainDamage);
        nbt.m_128405_("brain_damage_timer", this.brainDamageTimer);
        nbt.m_128405_("charge", this.charge);
        nbt.m_128356_("last_black_flash_time", this.lastBlackFlashTime);
        nbt.m_128405_("speed_stacks", this.speedStacks);
        nbt.m_128405_("fingers", this.fingers);
        if (this.stolenSkinProfile != null) {
            CompoundTag prof = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)prof, (GameProfile)this.stolenSkinProfile);
            nbt.m_128365_("stolen_profile", (Tag)prof);
        }
        ListTag unlockedTag = new ListTag();
        for (Ability ability : this.unlocked) {
            ResourceLocation resourceLocation = JJKAbilities.getKey(ability);
            if (resourceLocation == null) continue;
            unlockedTag.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
        }
        nbt.m_128365_("unlocked", (Tag)unlockedTag);
        ListTag copiedTag = new ListTag();
        for (CursedTechnique cursedTechnique : this.copied) {
            copiedTag.add((Object)IntTag.m_128679_((int)cursedTechnique.ordinal()));
        }
        nbt.m_128365_("copied", (Tag)copiedTag);
        ListTag listTag = new ListTag();
        for (CursedTechnique cursedTechnique : this.stolen) {
            listTag.add((Object)IntTag.m_128679_((int)cursedTechnique.ordinal()));
        }
        nbt.m_128365_("stolen", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (CursedTechnique cursedTechnique : this.absorbed) {
            listTag2.add((Object)IntTag.m_128679_((int)cursedTechnique.ordinal()));
        }
        nbt.m_128365_("absorbed", (Tag)listTag2);
        ListTag listTag3 = new ListTag();
        for (Ability ability : this.toggled) {
            ResourceLocation resourceLocation = JJKAbilities.getKey(ability);
            if (resourceLocation == null) continue;
            listTag3.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
        }
        nbt.m_128365_("toggled", (Tag)listTag3);
        ListTag listTag4 = new ListTag();
        for (Trait trait : this.traits) {
            listTag4.add((Object)IntTag.m_128679_((int)trait.ordinal()));
        }
        nbt.m_128365_("traits", (Tag)listTag4);
        ListTag listTag5 = new ListTag();
        for (Map.Entry<Ability, Integer> entry : this.cooldowns.entrySet()) {
            ResourceLocation resourceLocation = JJKAbilities.getKey(entry.getKey());
            if (resourceLocation == null) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("identifier", resourceLocation.toString());
            compoundTag.m_128405_("cooldown", entry.getValue().intValue());
            listTag5.add((Object)compoundTag);
        }
        nbt.m_128365_("cooldowns", (Tag)listTag5);
        ListTag listTag6 = new ListTag();
        for (Integer n : this.summons) {
            listTag6.add((Object)IntTag.m_128679_((int)n));
        }
        nbt.m_128365_("summons", (Tag)listTag6);
        ListTag listTag7 = new ListTag();
        for (Map.Entry<UUID, Set<Pact>> entry : this.acceptedPacts.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128362_("recipient", entry.getKey());
            ListTag listTag8 = new ListTag();
            for (Pact pact : entry.getValue()) {
                listTag8.add((Object)IntTag.m_128679_((int)pact.ordinal()));
            }
            compoundTag.m_128365_("entries", (Tag)listTag8);
            listTag7.add((Object)compoundTag);
        }
        nbt.m_128365_("accepted_pacts", (Tag)listTag7);
        ListTag listTag9 = new ListTag();
        for (BindingVow bindingVow : this.bindingVows) {
            listTag9.add((Object)IntTag.m_128679_((int)bindingVow.ordinal()));
        }
        nbt.m_128365_("binding_vows", (Tag)listTag9);
        ListTag listTag10 = new ListTag();
        for (Map.Entry<BindingVow, Integer> entry : this.bindingVowCooldowns.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_("vow", entry.getKey().ordinal());
            compoundTag.m_128405_("cooldown", entry.getValue().intValue());
        }
        nbt.m_128365_("binding_vow_cooldowns", (Tag)listTag10);
        ListTag listTag11 = new ListTag();
        for (Map.Entry<Ability, Set<String>> entry : this.chants.entrySet()) {
            ResourceLocation key = JJKAbilities.getKey(entry.getKey());
            if (key == null) continue;
            CompoundTag data = new CompoundTag();
            data.m_128359_("ability", key.toString());
            ListTag chants = new ListTag();
            for (String chant : entry.getValue()) {
                chants.add((Object)StringTag.m_129297_((String)chant));
            }
            data.m_128365_("entries", (Tag)chants);
            listTag11.add((Object)data);
        }
        nbt.m_128365_("chants", (Tag)listTag11);
        ListTag listTag12 = new ListTag();
        for (AbsorbedCurse curse : this.curses) {
            listTag12.add((Object)curse.serializeNBT());
        }
        nbt.m_128365_("curses", (Tag)listTag12);
        ListTag listTag13 = new ListTag();
        for (Map.Entry<Ability, Integer> entry : this.disrupted.entrySet()) {
            ResourceLocation key = JJKAbilities.getKey(entry.getKey());
            if (key == null) continue;
            CompoundTag data = new CompoundTag();
            data.m_128359_("identifier", key.toString());
            data.m_128405_("duration", entry.getValue().intValue());
            listTag13.add((Object)data);
        }
        nbt.m_128365_("disrupted", (Tag)listTag13);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag data;
        CompoundTag data2;
        this.initialized = nbt.m_128471_("initialized");
        this.cursedEnergyColor = nbt.m_128451_("cursed_energy_color");
        this.points = nbt.m_128451_("points");
        this.domainSize = nbt.m_128457_("domain_size");
        if (nbt.m_128441_("technique")) {
            this.technique = CursedTechnique.values()[nbt.m_128451_("technique")];
        }
        if (nbt.m_128441_("additional")) {
            this.additional = CursedTechnique.values()[nbt.m_128451_("additional")];
        }
        if (nbt.m_128441_("current_copied")) {
            this.currentCopied = CursedTechnique.values()[nbt.m_128451_("current_copied")];
        }
        if (nbt.m_128441_("current_stolen")) {
            this.currentStolen = CursedTechnique.values()[nbt.m_128451_("current_stolen")];
        }
        if (nbt.m_128441_("current_absorbed")) {
            this.currentAbsorbed = CursedTechnique.values()[nbt.m_128451_("current_absorbed")];
        }
        this.stolenSkinProfile = nbt.m_128441_("stolen_profile") ? NbtUtils.m_129228_((CompoundTag)nbt.m_128469_("stolen_profile")) : null;
        this.transfiguredSouls = nbt.m_128451_("transfigured_souls");
        this.nature = CursedEnergyNature.values()[nbt.m_128451_("nature")];
        this.experience = nbt.m_128457_("experience");
        this.output = nbt.m_128457_("output");
        this.energy = nbt.m_128457_("energy");
        this.maxEnergy = nbt.m_128457_("max_energy");
        this.extraEnergy = nbt.m_128457_("extra_energy");
        this.additionalEnergy = nbt.m_128457_("additional_energy");
        this.type = JujutsuType.values()[nbt.m_128451_("type")];
        this.burnout = nbt.m_128451_("burnout");
        this.disable = nbt.m_128451_("disable");
        this.brainDamage = nbt.m_128451_("brain_damage");
        this.brainDamageTimer = nbt.m_128451_("brain_damage_timer");
        this.charge = nbt.m_128451_("charge");
        this.lastBlackFlashTime = nbt.m_128454_("last_black_flash_time");
        this.speedStacks = nbt.m_128451_("speed_stacks");
        this.fingers = nbt.m_128451_("fingers");
        this.unlocked.clear();
        for (Tag tag : nbt.m_128437_("unlocked", 8)) {
            this.unlocked.add(JJKAbilities.getValue(new ResourceLocation(tag.m_7916_())));
        }
        this.copied.clear();
        for (Tag tag : nbt.m_128437_("copied", 3)) {
            this.copied.add(CursedTechnique.values()[((IntTag)tag).m_7047_()]);
        }
        this.stolen.clear();
        for (Tag tag : nbt.m_128437_("stolen", 3)) {
            this.stolen.add(CursedTechnique.values()[((IntTag)tag).m_7047_()]);
        }
        this.absorbed.clear();
        for (Tag tag : nbt.m_128437_("absorbed", 3)) {
            this.absorbed.add(CursedTechnique.values()[((IntTag)tag).m_7047_()]);
        }
        this.toggled.clear();
        for (Tag key : nbt.m_128437_("toggled", 8)) {
            this.toggled.add(JJKAbilities.getValue(new ResourceLocation(key.m_7916_())));
        }
        this.traits.clear();
        for (Tag key : nbt.m_128437_("traits", 3)) {
            this.traits.add(Trait.values()[((IntTag)key).m_7047_()]);
        }
        this.cooldowns.clear();
        for (Tag key : nbt.m_128437_("cooldowns", 10)) {
            data2 = (CompoundTag)key;
            this.cooldowns.put(JJKAbilities.getValue(new ResourceLocation(data2.m_128461_("identifier"))), data2.m_128451_("cooldown"));
        }
        this.disrupted.clear();
        for (Tag key : nbt.m_128437_("disrupted", 10)) {
            data2 = (CompoundTag)key;
            this.disrupted.put(JJKAbilities.getValue(new ResourceLocation(data2.m_128461_("identifier"))), data2.m_128451_("duration"));
        }
        this.summons.clear();
        ListTag summonsTag = nbt.m_128437_("summons", 3);
        for (int i = 0; i < summonsTag.size(); ++i) {
            this.summons.add(summonsTag.m_128763_(i));
        }
        this.acceptedPacts.clear();
        for (Tag key : nbt.m_128437_("accepted_pacts", 10)) {
            data = (CompoundTag)key;
            HashSet<Pact> pacts = new HashSet<Pact>();
            for (Tag entry : data.m_128437_("entries", 3)) {
                pacts.add(Pact.values()[((IntTag)entry).m_7047_()]);
            }
            this.acceptedPacts.put(data.m_128342_("recipient"), pacts);
        }
        this.bindingVows.clear();
        for (Tag key : nbt.m_128437_("binding_vows", 3)) {
            this.bindingVows.add(BindingVow.values()[((IntTag)key).m_7047_()]);
        }
        this.bindingVowCooldowns.clear();
        for (Tag key : nbt.m_128437_("binding_vow_cooldowns", 10)) {
            data = (CompoundTag)key;
            this.bindingVowCooldowns.put(BindingVow.values()[data.m_128451_("vow")], data.m_128451_("cooldown"));
        }
        this.chants.clear();
        for (Tag key : nbt.m_128437_("chants", 10)) {
            data = (CompoundTag)key;
            LinkedHashSet<String> chants = new LinkedHashSet<String>();
            for (Tag entry : data.m_128437_("entries", 8)) {
                chants.add(entry.m_7916_());
            }
            this.chants.put(JJKAbilities.getValue(new ResourceLocation(data.m_128461_("ability"))), chants);
        }
        this.curses.clear();
        for (Tag key : nbt.m_128437_("curses", 10)) {
            CompoundTag curse = (CompoundTag)key;
            this.curses.add(new AbsorbedCurse(curse));
        }
    }
}

