/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.client.particle.JJKParticleRenderTypes;
import radon.jujutsu_kaisen.client.particle.JJKParticles;

public class TravelParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final Vec3 target;
    private final boolean glow;
    private final float opacity;

    protected TravelParticle(ClientLevel pLevel, double pX, double pY, double pZ, TravelParticleOptions options, SpriteSet pSprites) {
        super(pLevel, pX, pY, pZ);
        this.f_107663_ = Math.max(options.scalar(), (this.f_107223_.m_188501_() - 0.5f) * options.scalar());
        this.f_107225_ = options.lifetime();
        this.target = new Vec3(options.target());
        Vector3f color = options.color();
        this.f_107227_ = color.x;
        this.f_107228_ = color.y;
        this.f_107229_ = color.z;
        this.opacity = options.opacity();
        this.f_107230_ = this.opacity * (1.0f - (float)this.f_107224_ / (float)this.f_107225_);
        this.glow = options.glow();
        this.sprites = pSprites;
        this.m_108337_(this.sprites.m_213979_(this.f_107208_.f_46441_));
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107230_ = this.opacity * (1.0f - (float)this.f_107224_ / (float)this.f_107225_);
        this.m_108337_(this.sprites.m_213979_(this.f_107208_.f_46441_));
        Vec3 pos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 direction = this.target.m_82546_(pos);
        double factor = (double)this.f_107224_ / (double)this.f_107225_;
        Vec3 newPos = pos.m_82549_(direction.m_82490_(factor));
        this.m_107264_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return this.glow ? JJKParticleRenderTypes.GLOW : JJKParticleRenderTypes.TRANSLUCENT;
    }

    public record TravelParticleOptions(Vector3f target, Vector3f color, float scalar, float opacity, boolean glow, int lifetime) implements ParticleOptions
    {
        public static ParticleOptions.Deserializer<TravelParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<TravelParticleOptions>(){

            @NotNull
            public TravelParticleOptions fromCommand(@NotNull ParticleType<TravelParticleOptions> type, @NotNull StringReader reader) throws CommandSyntaxException {
                Vector3f target = TravelParticleOptions.readTargetVector3f(reader);
                reader.expect(' ');
                Vector3f color = TravelParticleOptions.readColorVector3f(reader);
                reader.expect(' ');
                return new TravelParticleOptions(target, color, reader.readFloat(), reader.readFloat(), reader.readBoolean(), reader.readInt());
            }

            @NotNull
            public TravelParticleOptions fromNetwork(@NotNull ParticleType<TravelParticleOptions> type, @NotNull FriendlyByteBuf buf) {
                return new TravelParticleOptions(TravelParticleOptions.readTargetFromNetwork(buf), TravelParticleOptions.readColorFromNetwork(buf), buf.readFloat(), buf.readFloat(), buf.readBoolean(), buf.readInt());
            }
        };

        public static Vector3f readTargetVector3f(StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float f0 = reader.readFloat();
            reader.expect(' ');
            float f1 = reader.readFloat();
            reader.expect(' ');
            float f2 = reader.readFloat();
            return new Vector3f(f0, f1, f2);
        }

        public static Vector3f readColorVector3f(StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float f0 = reader.readFloat();
            reader.expect(' ');
            float f1 = reader.readFloat();
            reader.expect(' ');
            float f2 = reader.readFloat();
            return new Vector3f(f0, f1, f2);
        }

        public static Vector3f readTargetFromNetwork(FriendlyByteBuf buf) {
            return new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
        }

        public static Vector3f readColorFromNetwork(FriendlyByteBuf buf) {
            return new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
        }

        @NotNull
        public ParticleType<?> m_6012_() {
            return (ParticleType)JJKParticles.TRAVEL.get();
        }

        public void m_7711_(FriendlyByteBuf buf) {
            buf.writeFloat(this.target.x);
            buf.writeFloat(this.target.y);
            buf.writeFloat(this.target.z);
            buf.writeFloat(this.color.x);
            buf.writeFloat(this.color.y);
            buf.writeFloat(this.color.z);
            buf.writeFloat(this.scalar);
            buf.writeFloat(this.opacity);
            buf.writeBoolean(this.glow);
            buf.writeInt(this.lifetime);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f %.2f %.2f %b %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.target.x), Float.valueOf(this.target.y), Float.valueOf(this.target.z), Float.valueOf(this.color.x), Float.valueOf(this.color.y), Float.valueOf(this.color.z), Float.valueOf(this.scalar), Float.valueOf(this.opacity), this.glow, this.lifetime);
        }
    }

    public static class Provider
    implements ParticleProvider<TravelParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSpriteSet) {
            this.sprites = pSpriteSet;
        }

        public TravelParticle createParticle(@NotNull TravelParticleOptions options, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new TravelParticle(level, x, y, z, options, this.sprites);
        }
    }
}

