/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.slice;

import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import radon.jujutsu_kaisen.client.slice.Collider;

public class AABBCollider
extends Collider {
    public AABB box;
    public float density = -1.0f;

    public AABBCollider(AABB box) {
        this.box = box;
        this.localCentroid = box.m_82399_();
    }

    public AABBCollider(AABB box, float density) {
        this.box = box;
        float w = (float)(box.f_82291_ - box.f_82288_);
        float h = (float)(box.f_82292_ - box.f_82289_);
        float d = (float)(box.f_82293_ - box.f_82290_);
        float vol = w * h * d;
        this.mass = density * vol;
        this.localCentroid = box.m_82399_();
        float iMass = this.mass / 12.0f;
        this.localInertiaTensor = new Matrix3f(iMass * (h * h + d * d), 0.0f, 0.0f, 0.0f, iMass * (w * w + d * d), 0.0f, 0.0f, 0.0f, iMass * (w * w + h * h));
    }

    @Override
    public Vec3 support(Vec3 direction) {
        return new Vec3(direction.f_82479_ > 0.0 ? this.box.f_82291_ : this.box.f_82288_, direction.f_82480_ > 0.0 ? this.box.f_82292_ : this.box.f_82289_, direction.f_82481_ > 0.0 ? this.box.f_82293_ : this.box.f_82290_);
    }

    @Override
    public Collider copy() {
        if (this.density == -1.0f) {
            return new AABBCollider(this.box);
        }
        return new AABBCollider(this.box, this.density);
    }
}

