/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.base.DomainExpansion;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.OpenDomainExpansionEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.CameraShakeS2CPacket;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MalevolentShrineEntity
extends OpenDomainExpansionEntity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MalevolentShrineEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public MalevolentShrineEntity(LivingEntity owner, DomainExpansion ability, int width, int height) {
        super((EntityType)JJKEntities.MALEVOLENT_SHRINE.get(), owner, ability, width, height);
    }

    @Override
    public AABB getBounds() {
        int width = this.getWidth();
        int height = this.getHeight();
        return new AABB(this.m_20185_() - (double)width, this.m_20186_() - (double)height / 2.0, this.m_20189_() - (double)width, this.m_20185_() + (double)width, this.m_20186_() + (double)height / 2.0, this.m_20189_() + (double)width);
    }

    @Override
    public boolean isInsideBarrier(BlockPos pos) {
        int width = this.getWidth();
        int height = this.getHeight();
        BlockPos center = this.m_20183_();
        BlockPos relative = pos.m_121996_((Vec3i)center);
        return relative.m_123342_() > -height / 2 && relative.m_123331_(Vec3i.f_123288_) < (double)(width * width);
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        for (LivingEntity entity : this.getAffected()) {
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0, false, false));
            player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)ForgeRegistries.SOUND_EVENTS.getHolder((Object)((SoundEvent)JJKSounds.MALEVOLENT_SHRINE.get())).orElseThrow(), SoundSource.MASTER, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, this.f_19796_.m_188505_()));
        }
    }

    @Override
    public boolean checkSureHitEffect() {
        return this.getTime() >= 40 && super.checkSureHitEffect();
    }

    @Override
    protected void doSureHitEffect(@NotNull LivingEntity owner) {
        super.doSureHitEffect(owner);
        BlockPos center = this.m_20183_();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.first) {
            for (int i = 0; i < width; ++i) {
                int j = 0;
                while (j < height) {
                    int delay = i * 4;
                    int horizontal = i;
                    int vertical = j++;
                    ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                    cap.delayTickEvent(() -> {
                        if (this.m_213877_()) {
                            return;
                        }
                        for (int x = -horizontal; x <= horizontal; ++x) {
                            for (int z = -horizontal; z <= horizontal; ++z) {
                                BlockPos pos;
                                double distance = Math.sqrt(x * x + vertical * vertical + z * z);
                                if (!(distance < (double)horizontal) || !(distance >= (double)(horizontal - 1)) || !this.isAffected(pos = center.m_7918_(x, vertical, z))) continue;
                                owner.m_9236_().m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11913_, SoundSource.MASTER, 1.0f, (1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f) * 0.5f);
                                if (!HelperMethods.isDestroyable((BlockGetter)this.m_9236_(), owner, pos)) continue;
                                owner.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 35);
                                if (this.f_19796_.m_188503_(10) != 0) continue;
                                ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0, 0.0, 0.0, 0.0, 0.0);
                            }
                        }
                    }, delay);
                }
            }
            this.first = false;
        }
        int size = width * height / 4;
        AABB bounds = this.getBounds();
        for (BlockPos pos : BlockPos.m_235641_((RandomSource)this.f_19796_, (int)size, (int)((int)bounds.f_82288_), (int)((int)bounds.f_82289_), (int)((int)bounds.f_82290_), (int)((int)bounds.f_82291_), (int)((int)bounds.f_82292_), (int)((int)bounds.f_82293_))) {
            if (!this.isAffected(pos)) continue;
            this.ability.onHitBlock(this, owner, pos);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getTime() >= 40 && this.getTime() % 10 == 0) {
            for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.getBounds())) {
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer player = (ServerPlayer)entity;
                PacketHandler.sendToClient(new CameraShakeS2CPacket(1.0f, 5.0f, 20), player);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

