/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.ai.goal;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;

public class NearestAttackableSorcererGoal
extends TargetGoal {
    private static final int DEFAULT_RANDOM_INTERVAL = 10;
    protected final int randomInterval;
    @Nullable
    protected LivingEntity target;
    protected TargetingConditions targetConditions;

    public NearestAttackableSorcererGoal(Mob pMob, boolean pMustSee) {
        this(pMob, 10, pMustSee, false, null);
    }

    public NearestAttackableSorcererGoal(Mob pMob, boolean pMustSee, Predicate<LivingEntity> pTargetPredicate) {
        this(pMob, 10, pMustSee, false, pTargetPredicate);
    }

    public NearestAttackableSorcererGoal(Mob pMob, boolean pMustSee, boolean pMustReach) {
        this(pMob, 10, pMustSee, pMustReach, null);
    }

    public NearestAttackableSorcererGoal(Mob pMob, int pRandomInterval, boolean pMustSee, boolean pMustReach, @Nullable Predicate<LivingEntity> pTargetPredicate) {
        super(pMob, pMustSee, pMustReach);
        this.randomInterval = NearestAttackableSorcererGoal.m_186073_((int)pRandomInterval);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(pTargetPredicate);
    }

    public boolean m_8036_() {
        if (this.randomInterval > 0 && this.f_26135_.m_217043_().m_188503_(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    protected AABB getTargetSearchArea(double pTargetDistance) {
        return this.f_26135_.m_20191_().m_82377_(pTargetDistance, 4.0, pTargetDistance);
    }

    protected void findTarget() {
        this.target = this.f_26135_.m_9236_().m_45982_(this.f_26135_.m_9236_().m_6443_(LivingEntity.class, this.getTargetSearchArea(this.m_7623_()), entity -> {
            if (!entity.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return false;
            }
            ISorcererData cap = (ISorcererData)entity.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            return cap.getType() == JujutsuType.SORCERER;
        }), this.targetConditions, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_());
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.target);
        super.m_8056_();
    }

    public void setTarget(@Nullable LivingEntity pTarget) {
        this.target = pTarget;
    }
}

