/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.base;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;

public abstract class JJKPartEntity<T extends Entity>
extends PartEntity<T> {
    private EntityDimensions size;
    protected int newPosRotationIncrements;
    protected double interpTargetX;
    protected double interpTargetY;
    protected double interpTargetZ;
    protected double interpTargetYaw;
    protected double interpTargetPitch;
    public float renderYawOffset;
    public float prevRenderYawOffset;

    public JJKPartEntity(T parent) {
        super(parent);
        this.m_6034_(parent.m_20185_(), parent.m_20186_(), parent.m_20189_());
    }

    public boolean m_6087_() {
        return true;
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.getParent().m_142340_();
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        return !this.m_6673_(pSource) && this.getParent().m_6469_(pSource, pAmount);
    }

    public boolean m_6673_(DamageSource pSource) {
        return pSource.m_7639_() == this.getParent() || super.m_6673_(pSource);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        return this.size;
    }

    public boolean m_142391_() {
        return false;
    }

    protected void setSize(EntityDimensions size) {
        this.size = size;
        this.m_6210_();
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        JJKPartEntity.assignPartIDs((Entity)this);
    }

    public final void updateLastPos() {
        this.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        ++this.f_19797_;
    }

    public void m_8119_() {
        this.updateLastPos();
        super.m_8119_();
        if (this.newPosRotationIncrements > 0) {
            double d0 = this.m_20185_() + (this.interpTargetX - this.m_20185_()) / (double)this.newPosRotationIncrements;
            double d2 = this.m_20186_() + (this.interpTargetY - this.m_20186_()) / (double)this.newPosRotationIncrements;
            double d4 = this.m_20189_() + (this.interpTargetZ - this.m_20189_()) / (double)this.newPosRotationIncrements;
            double d6 = Mth.m_14175_((double)(this.interpTargetYaw - (double)this.m_146908_()));
            this.m_146922_((float)((double)this.m_146908_() + d6 / (double)this.newPosRotationIncrements));
            this.m_146926_((float)((double)this.m_146909_() + (this.interpTargetPitch - (double)this.m_146909_()) / (double)this.newPosRotationIncrements));
            --this.newPosRotationIncrements;
            this.m_6034_(d0, d2, d4);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset < -180.0f) {
            this.prevRenderYawOffset -= 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset >= 180.0f) {
            this.prevRenderYawOffset += 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
    }

    public abstract ResourceLocation getRenderer();

    public void m_20234_(int pId) {
        super.m_20234_(pId + 1);
    }

    public boolean m_142038_() {
        return this.getParent().m_142038_();
    }

    public boolean m_20145_() {
        return this.getParent().m_20145_();
    }

    public static void assignPartIDs(Entity parent) {
        PartEntity[] parts = parent.getParts();
        if (parts == null) {
            return;
        }
        int length = parts.length;
        for (int i = 0; i < length; ++i) {
            PartEntity part = parts[i];
            part.m_20234_(parent.m_19879_() + i);
        }
    }

    public void m_19915_(float pYRot, float pXRot) {
        super.m_19915_(pYRot, pXRot);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
    }
}

