/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.item.armor;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.client.render.item.armor.InventoryCurseRenderer;
import radon.jujutsu_kaisen.sound.JJKSounds;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class InventoryCurseItem
extends ArmorItem
implements GeoItem,
MenuProvider,
ICurioItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public InventoryCurseItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    @NotNull
    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        return slotContext.entity() instanceof Player ? super.getDropRule(slotContext, source, lootingLevel, recentlyHit, stack) : ICurio.DropRule.DESTROY;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private InventoryCurseRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new InventoryCurseRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)String.format("%s.desc", this.m_5524_()));
    }

    public static void addItem(ItemStack inventory, int slot, ItemStack stack) {
        CompoundTag nbt = inventory.m_41784_();
        ListTag itemsTag = nbt.m_128437_("items", 10);
        itemsTag.add(slot, (Tag)stack.m_41739_(new CompoundTag()));
        nbt.m_128365_("items", (Tag)itemsTag);
    }

    public static void removeItem(ItemStack inventory, int slot) {
        CompoundTag nbt = inventory.m_41784_();
        ListTag itemsTag = nbt.m_128437_("items", 10);
        if (itemsTag.size() >= slot) {
            itemsTag.remove(slot);
        }
        nbt.m_128365_("items", (Tag)itemsTag);
    }

    public static void clear(ItemStack inventory) {
        CompoundTag nbt = inventory.m_41784_();
        nbt.m_128473_("items");
    }

    public static ItemStack getItem(ItemStack inventory, int slot) {
        CompoundTag nbt = inventory.m_41784_();
        ListTag itemsTag = nbt.m_128437_("items", 10);
        return ItemStack.m_41712_((CompoundTag)itemsTag.m_128728_(slot));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        CompoundTag nbt = pPlayer.m_6844_(EquipmentSlot.CHEST).m_41784_();
        AtomicInteger previous = new AtomicInteger(nbt.m_128437_("items", 10).size());
        SimpleContainer container = new SimpleContainer(9);
        container.m_7797_(nbt.m_128437_("items", 10));
        container.m_19164_(pContainer -> {
            nbt.m_128365_("items", (Tag)((SimpleContainer)pContainer).m_7927_());
            int current = nbt.m_128437_("items", 10).size();
            if (current > previous.get()) {
                pPlayer.m_9236_().m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), (SoundEvent)JJKSounds.SWALLOW.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
            previous.set(current);
        });
        return new ChestMenu(MenuType.f_39957_, pContainerId, pPlayerInventory, (Container)container, container.m_6643_() / 9);
    }
}

