/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.network.packet.c2s;

import java.nio.charset.Charset;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.menu.BountyMenu;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SetCostS2CPacket;
import radon.jujutsu_kaisen.util.SorcererUtil;

public class RequestCostC2SPacket {
    private final CharSequence name;

    public RequestCostC2SPacket(CharSequence name) {
        this.name = name;
    }

    public RequestCostC2SPacket(FriendlyByteBuf buf) {
        this(buf.readCharSequence(buf.readInt(), Charset.defaultCharset()));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.name.length());
        buf.writeCharSequence(this.name, Charset.defaultCharset());
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            assert (sender != null);
            ServerPlayer target = sender.f_8924_.m_6846_().m_11255_(String.valueOf(this.name));
            if (target != null) {
                target.getCapability(SorcererDataHandler.INSTANCE).ifPresent(cap -> {
                    int cost = Mth.m_14143_((float)(64.0f * ((float)(SorcererUtil.getGrade(cap.getExperience()).ordinal() + 1) / (float)SorcererGrade.values().length)));
                    AbstractContainerMenu patt1816$temp = sender.f_36096_;
                    if (patt1816$temp instanceof BountyMenu) {
                        BountyMenu menu = (BountyMenu)patt1816$temp;
                        menu.setCost(cost);
                    }
                    PacketHandler.sendToClient(new SetCostS2CPacket(cost), sender);
                });
            }
        });
        ctx.setPacketHandled(true);
    }
}

