/*
 * Decompiled with CFR 0.152.
 */
package de.domenikyt1.createdomeniksmod.block.custom;

import com.mojang.serialization.MapCodec;
import de.domenikyt1.createdomeniksmod.block.ModBlocks;
import de.domenikyt1.createdomeniksmod.block.entity.ModBlockEntities;
import de.domenikyt1.createdomeniksmod.block.entity.custom.AltarBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class AltarBlock
extends BaseEntityBlock {
    public static final VoxelShape S1 = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    public static final VoxelShape S2 = Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    public static final VoxelShape S3 = Block.box((double)5.0, (double)4.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0);
    public static final VoxelShape S4 = Block.box((double)4.0, (double)13.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    public static final VoxelShape U1 = Block.box((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)S1, (VoxelShape[])new VoxelShape[]{S2, S3, S4, U1});
    public static final MapCodec<AltarBlock> CODEC = AltarBlock.simpleCodec(AltarBlock::new);

    public AltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return super.getOcclusionShape(state, level, pos);
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new AltarBlockEntity(pPos, pState);
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof AltarBlockEntity) {
            AltarBlockEntity altarBlockEntity = (AltarBlockEntity)blockEntity;
            altarBlockEntity.drops();
            pLevel.updateNeighbourForOutputSignal(pPos, (Block)this);
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof AltarBlockEntity) {
            AltarBlockEntity altarBlockEntity = (AltarBlockEntity)blockEntity;
            if (pStack.is(ModBlocks.PEDESTAL.asItem())) {
                for (Vector2i offset : AltarBlockEntity.offsets) {
                    if (this.isPositionEmpty(pLevel, pPos.offset(offset.x, 0, offset.y))) {
                        this.placePedestal(pLevel, pPos.offset(offset.x, 0, offset.y));
                        if (!pPlayer.isCreative()) {
                            pStack.shrink(1);
                        }
                        pLevel.playSound(pPlayer, pPos.offset(offset.x, 0, offset.y), SoundEvents.STONE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        break;
                    }
                    if (this.hasSidePedestal(pLevel, pPos.offset(offset.x, 0, offset.y))) continue;
                    pPlayer.displayClientMessage((Component)Component.literal((String)"Remove all obstacles in the way!"), false);
                    break;
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (pPlayer.isCrouching() && !pLevel.isClientSide()) {
                ((ServerPlayer)pPlayer).openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)altarBlockEntity, (Component)Component.literal((String)"Pedestal")), pPos);
                return ItemInteractionResult.SUCCESS;
            }
            if (altarBlockEntity.inventory.getStackInSlot(0).isEmpty() && !pStack.isEmpty()) {
                altarBlockEntity.inventory.insertItem(0, pStack.copy(), false);
                if (!pPlayer.isCreative()) {
                    pStack.shrink(1);
                }
                pLevel.playSound(pPlayer, pPos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 2.0f);
            } else if (pStack.isEmpty()) {
                ItemStack stackOnPedestal = altarBlockEntity.inventory.extractItem(0, 1, false);
                pPlayer.setItemInHand(InteractionHand.MAIN_HAND, stackOnPedestal);
                altarBlockEntity.clearContents();
                pLevel.playSound(pPlayer, pPos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    private boolean isPositionEmpty(Level level, BlockPos pos) {
        return level.getBlockState(pos).isAir();
    }

    private boolean hasSidePedestal(Level level, BlockPos pos) {
        return level.getBlockState(pos).is(ModBlocks.PEDESTAL);
    }

    private void placePedestal(Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, ((Block)ModBlocks.PEDESTAL.get()).defaultBlockState());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return AltarBlock.createTickerHelper(pBlockEntityType, ModBlockEntities.SACRIFICE_ALTAR_BE.get(), (level, blockPos, blockState, pedestalBlockEntity) -> pedestalBlockEntity.tick(level, blockPos, blockState));
    }
}

