/*
 * Decompiled with CFR 0.152.
 */
package de.domenikyt1.createdomeniksmod.register.item.armor;

import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public abstract class AbstractArmorItem
extends ArmorItem {
    public AbstractArmorItem(Holder<ArmorMaterial> pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public boolean isFullSetActive(LivingEntity living) {
        return AbstractArmorItem.isFullSetActive(living, (Holder<ArmorMaterial>)this.getMaterial());
    }

    public static boolean isFullSetActive(LivingEntity living, Holder<ArmorMaterial> materials) {
        ArmorItem armorItem;
        ArmorItem armorItem2;
        ArmorItem armorItem3;
        if (living == null) {
            return false;
        }
        Item item = living.getItemBySlot(EquipmentSlot.HEAD).getItem();
        ArmorItem head = item instanceof ArmorItem ? (armorItem3 = (ArmorItem)item) : null;
        Item chestPlate = living.getItemBySlot(EquipmentSlot.CHEST).getItem();
        if (chestPlate instanceof ElytraItem || chestPlate instanceof AirItem) {
            return false;
        }
        ArmorItem chest = (ArmorItem)living.getItemBySlot(EquipmentSlot.CHEST).getItem();
        Item item2 = living.getItemBySlot(EquipmentSlot.LEGS).getItem();
        ArmorItem legs = item2 instanceof ArmorItem ? (armorItem2 = (ArmorItem)item2) : null;
        Item item3 = living.getItemBySlot(EquipmentSlot.FEET).getItem();
        ArmorItem feet = item3 instanceof ArmorItem ? (armorItem = (ArmorItem)item3) : null;
        return head != null && legs != null && feet != null && head.getMaterial() == materials && chest.getMaterial() == materials && legs.getMaterial() == materials && feet.getMaterial() == materials;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeMods(EquipmentSlot slot) {
        return null;
    }

    public static ResourceLocation makeCustomTextureLocation(String nameSpace, String id) {
        return ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)("textures/models/armor/custom/" + id + ".png"));
    }

    public static <T extends AbstractArmorItem> Map<ArmorItem.Type, DeferredItem<T>> createRegistry(DeferredRegister.Items registry, String baseName, Function<ArmorItem.Type, T> creator) {
        return (Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            for (ArmorItem.Type type : ArmorItem.Type.values()) {
                if (type == ArmorItem.Type.BODY) continue;
                map.put(type, registry.register(baseName + "_" + type.getName(), () -> (AbstractArmorItem)((Object)((Object)((Object)creator.apply(type))))));
            }
        });
    }
}

