/*
 * Decompiled with CFR 0.152.
 */
package de.domenikyt1.createdomeniksmod.register.item.custom;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ElementiumMaceItem
extends Item {
    private int DEFAULT_ATTACK_DAMAGE = 5;
    private float DEFAULT_ATTACK_SPEED = -3.4f;
    public float SMASH_ATTACK_FALL_THRESHOLD = 1.5f;
    private float SMASH_ATTACK_HEAVY_THRESHOLD = 5.0f;
    public float SMASH_ATTACK_KNOCKBACK_RADIUS = 3.5f;
    private float SMASH_ATTACK_KNOCKBACK_POWER = 0.7f;
    private int DamagePerBlock;
    private double BaseAttackDamage;
    private double BaseAttackSpeed;

    public ElementiumMaceItem(Item.Properties properties, int damageperblock, double baseattackdamage, double baseattackspeed) {
        super(properties.component(DataComponents.TOOL, (Object)ElementiumMaceItem.createToolProperties(damageperblock)).attributes(ElementiumMaceItem.createAttributes(baseattackdamage, baseattackspeed)));
        this.DamagePerBlock = damageperblock;
        this.BaseAttackDamage = baseattackdamage;
        this.BaseAttackSpeed = baseattackspeed;
    }

    public static ItemAttributeModifiers createAttributes(double baseAttackDamage, double baseAttackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, baseAttackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, baseAttackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties(int damagePerBlock) {
        return new Tool(List.of(), 1.0f, damagePerBlock);
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public int getEnchantmentValue() {
        return 15;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        ServerPlayer serverplayer;
        if (attacker instanceof ServerPlayer && ElementiumMaceItem.canSmashAttack((LivingEntity)(serverplayer = (ServerPlayer)attacker))) {
            ServerLevel serverlevel = (ServerLevel)attacker.level();
            if (serverplayer.isIgnoringFallDamageFromCurrentImpulse() && serverplayer.currentImpulseImpactPos != null) {
                if (serverplayer.currentImpulseImpactPos.y > serverplayer.position().y) {
                    serverplayer.currentImpulseImpactPos = serverplayer.position();
                }
            } else {
                serverplayer.currentImpulseImpactPos = serverplayer.position();
            }
            serverplayer.setIgnoreFallDamageFromCurrentImpulse(true);
            serverplayer.setDeltaMovement(serverplayer.getDeltaMovement().with(Direction.Axis.Y, (double)0.01f));
            serverplayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverplayer));
            if (target.onGround()) {
                serverplayer.setSpawnExtraParticlesOnFall(true);
                SoundEvent soundevent = serverplayer.fallDistance > 5.0f ? SoundEvents.MACE_SMASH_GROUND_HEAVY : SoundEvents.MACE_SMASH_GROUND;
                serverlevel.playSound((Player)null, serverplayer.getX(), serverplayer.getY(), serverplayer.getZ(), soundevent, serverplayer.getSoundSource(), 1.0f, 1.0f);
            } else {
                serverlevel.playSound((Player)null, serverplayer.getX(), serverplayer.getY(), serverplayer.getZ(), SoundEvents.MACE_SMASH_AIR, serverplayer.getSoundSource(), 1.0f, 1.0f);
            }
            ElementiumMaceItem.knockback((Level)serverlevel, (Player)serverplayer, (Entity)target);
        }
        return true;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        if (ElementiumMaceItem.canSmashAttack(attacker)) {
            attacker.resetFallDistance();
        }
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(Items.BREEZE_ROD);
    }

    public float getAttackDamageBonus(Entity target, float damage, DamageSource damageSource) {
        Entity var5 = damageSource.getDirectEntity();
        if (var5 instanceof LivingEntity) {
            float var10000;
            LivingEntity livingentity = (LivingEntity)var5;
            if (!ElementiumMaceItem.canSmashAttack(livingentity)) {
                return 0.0f;
            }
            float f3 = 3.0f;
            float f = 8.0f;
            float f1 = livingentity.fallDistance;
            float f2 = f1 <= 3.0f ? 4.0f * f1 : (f1 <= 8.0f ? 12.0f + 2.0f * (f1 - 3.0f) : 22.0f + f1 - 8.0f);
            Level var10 = livingentity.level();
            if (var10 instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)var10;
                var10000 = f2 + EnchantmentHelper.modifyFallBasedDamage((ServerLevel)serverlevel, (ItemStack)livingentity.getWeaponItem(), (Entity)target, (DamageSource)damageSource, (float)0.0f) * f1;
            } else {
                var10000 = f2;
            }
            return var10000;
        }
        return 0.0f;
    }

    private static void knockback(Level level, Player player, Entity entity) {
        level.levelEvent(2013, entity.getOnPos(), 750);
        level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(3.5), ElementiumMaceItem.knockbackPredicate(player, entity)).forEach(p_347296_ -> {
            Vec3 vec3 = p_347296_.position().subtract(entity.position());
            double d0 = ElementiumMaceItem.getKnockbackPower(player, p_347296_, vec3);
            Vec3 vec31 = vec3.normalize().scale(d0);
            if (d0 > 0.0) {
                p_347296_.push(vec31.x, (double)0.7f, vec31.z);
                if (p_347296_ instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)p_347296_;
                    serverplayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverplayer));
                }
            }
        });
    }

    private static Predicate<LivingEntity> knockbackPredicate(Player player, Entity entity) {
        return p_344407_ -> {
            ArmorStand armorstand;
            TamableAnimal tamableanimal;
            boolean flag = !p_344407_.isSpectator();
            boolean flag1 = p_344407_ != player && p_344407_ != entity;
            boolean flag2 = !player.isAlliedTo((Entity)p_344407_);
            boolean flag6 = p_344407_ instanceof TamableAnimal && (tamableanimal = (TamableAnimal)p_344407_).isTame() && player.getUUID().equals(tamableanimal.getOwnerUUID());
            boolean flag3 = !flag6;
            flag6 = !(p_344407_ instanceof ArmorStand) || !(armorstand = (ArmorStand)p_344407_).isMarker();
            boolean flag4 = flag6;
            boolean flag5 = entity.distanceToSqr((Entity)p_344407_) <= Math.pow(3.5, 2.0);
            return flag && flag1 && flag2 && flag3 && flag4 && flag5;
        };
    }

    private static double getKnockbackPower(Player player, LivingEntity entity, Vec3 entityPos) {
        return (3.5 - entityPos.length()) * (double)0.7f * (double)(player.fallDistance > 5.0f ? 2 : 1) * (1.0 - entity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
    }

    public static boolean canSmashAttack(LivingEntity entity) {
        return entity.fallDistance > 1.5f && !entity.isFallFlying();
    }
}

