/*
 * Decompiled with CFR 0.152.
 */
package de.domenikyt1.createdomeniksmod.register.block.custom;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class AsphaltBlock
extends Block {
    private final int amplifier;

    public AsphaltBlock(BlockBehaviour.Properties properties, int amplifier) {
        super(properties);
        this.amplifier = amplifier;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 5, this.amplifier, true, false));
        }
        super.stepOn(level, pos, state, entity);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (!Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.empty());
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.createdomeniksmod.info.shift"));
        } else {
            tooltipComponents.add((Component)Component.empty());
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.createdomeniksmod.speed_multiplier0"));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.createdomeniksmod.speed_multiplier1"));
            tooltipComponents.add((Component)Component.literal((String)("\u00a7a" + this.amplifier)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

