/*
 * Decompiled with CFR 0.152.
 */
package de.domenikyt1.createdomeniksmod.register.block.entity.custom;

import de.domenikyt1.createdomeniksmod.networking.PedestalCraftCountS2C;
import de.domenikyt1.createdomeniksmod.networking.ResetSacrificedEntityS2C;
import de.domenikyt1.createdomeniksmod.register.block.CDMBlocks;
import de.domenikyt1.createdomeniksmod.register.block.entity.ModBlockEntities;
import de.domenikyt1.createdomeniksmod.register.block.entity.custom.PedestalBlockEntity;
import de.domenikyt1.createdomeniksmod.register.recipe.ModRecipes;
import de.domenikyt1.createdomeniksmod.register.recipe.PedestalRecipe;
import de.domenikyt1.createdomeniksmod.register.recipe.PedestalRecipeInput;
import de.domenikyt1.createdomeniksmod.register.screen.custom.PedestalMenu;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class AltarBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler inventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 64;
        }

        protected void onContentsChanged(int slot) {
            AltarBlockEntity.this.setChanged();
            if (!AltarBlockEntity.this.level.isClientSide()) {
                AltarBlockEntity.this.level.sendBlockUpdated(AltarBlockEntity.this.getBlockPos(), AltarBlockEntity.this.getBlockState(), AltarBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private float rotation;
    public int count = 0;
    private int maxCount = 80;
    public EntityType<?> entityLastSacrificed = null;
    public static List<Vector2i> offsets = List.of(new Vector2i(3, 0), new Vector2i(2, 2), new Vector2i(0, 3), new Vector2i(-2, 2), new Vector2i(-3, 0), new Vector2i(-2, -2), new Vector2i(0, -3), new Vector2i(2, -2));

    public AltarBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.SACRIFICE_ALTAR_BE.get(), pPos, pBlockState);
    }

    public void setSacrificedEntity(EntityType<?> entityType) {
        this.entityLastSacrificed = entityType;
    }

    public void clearContents() {
        this.inventory.setStackInSlot(0, ItemStack.EMPTY);
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("inventory", (Tag)this.inventory.serializeNBT(pRegistries));
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.inventory.deserializeNBT(pRegistries, pTag.getCompound("inventory"));
    }

    public float getRenderingRotation() {
        this.rotation += 0.5f;
        if (this.rotation >= 360.0f) {
            this.rotation = 0.0f;
        }
        return this.rotation;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (!this.hasRecipe() || this.entityLastSacrificed == null) {
            return;
        }
        if (this.countFinished()) {
            this.count = 0;
            this.exchangeItemInMainPedestal();
            this.removeItemsFromSidePedestals();
            this.spawnVisualLightningBolt((ServerLevel)level, blockPos);
            this.spawnExplosionParticles((ServerLevel)level);
            this.resetSacrificedEntity();
        } else {
            this.countUp();
            this.spawnCraftingParticles(level);
        }
    }

    private void countUp() {
        ++this.count;
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PedestalCraftCountS2C("Count Up", this.getBlockPos(), this.count), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void resetSacrificedEntity() {
        this.entityLastSacrificed = null;
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ResetSacrificedEntityS2C("Reset Entity", this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void spawnVisualLightningBolt(ServerLevel level, BlockPos blockPos) {
        ((LightningBolt)EntityType.LIGHTNING_BOLT.spawn(level, blockPos, MobSpawnType.TRIGGERED)).setVisualOnly(true);
    }

    private void spawnExplosionParticles(ServerLevel level) {
        double x = this.getBlockPos().getX();
        double y = this.getBlockPos().getY();
        double z = this.getBlockPos().getZ();
        level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x + 0.5, y + (double)1.2f, z + 0.5, 0, 0.0, 0.0, 0.0, 0.25);
    }

    private void spawnCraftingParticles(Level level) {
        offsets.forEach(offset -> {
            ItemStack stack = ((PedestalBlockEntity)level.getBlockEntity((BlockPos)this.getBlockPos().offset((int)offset.x, (int)0, (int)offset.y))).inventory.getStackInSlot(0);
            double x = this.getBlockPos().offset(offset.x, 0, offset.y).getX();
            double y = this.getBlockPos().offset(offset.x, 0, offset.y).getY();
            double z = this.getBlockPos().offset(offset.x, 0, offset.y).getZ();
            BlockPos direction = this.getBlockPos().subtract((Vec3i)this.getBlockPos().offset(offset.x, 0, offset.y));
            ((ServerLevel)level).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), x + 0.5, y + (double)1.2f, z + 0.5, 0, (double)direction.getX(), (double)direction.getY(), (double)direction.getZ(), 0.25);
        });
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean countFinished() {
        return this.count >= this.maxCount;
    }

    public boolean hasRecipe() {
        Optional<RecipeHolder<PedestalRecipe>> recipe = this.getCurrentRecipe();
        return recipe.isPresent();
    }

    private Optional<RecipeHolder<PedestalRecipe>> getCurrentRecipe() {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.PEDESTAL_TYPE.get(), (RecipeInput)new PedestalRecipeInput(this.inventory.getStackInSlot(0), offsets.stream().map(offset -> {
            if (this.hasSidePedestals()) {
                return ((PedestalBlockEntity)this.level.getBlockEntity((BlockPos)this.getBlockPos().offset((int)offset.x, (int)0, (int)offset.y))).inventory.getStackInSlot(0);
            }
            return ItemStack.EMPTY;
        }).toList(), this.entityLastSacrificed), this.level);
    }

    private void exchangeItemInMainPedestal() {
        Optional<RecipeHolder<PedestalRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            this.inventory.extractItem(0, 64, false);
            this.inventory.insertItem(0, ((PedestalRecipe)recipe.get().value()).getResultItem(null), false);
        }
    }

    private void removeItemsFromSidePedestals() {
        offsets.forEach(offset -> ((PedestalBlockEntity)this.level.getBlockEntity((BlockPos)this.getBlockPos().offset((int)offset.x, (int)0, (int)offset.y))).inventory.setStackInSlot(0, ItemStack.EMPTY));
    }

    private boolean hasItemInMainPedestal() {
        return this.inventory.getStackInSlot(0).is(Items.DIAMOND);
    }

    private boolean doSidePedestalsHaveItems() {
        return offsets.stream().allMatch(offset -> this.hasItemInInventory((Vector2i)offset, Items.REDSTONE));
    }

    private boolean hasSidePedestals() {
        return offsets.stream().allMatch(this::isSidePedestal);
    }

    private boolean isSidePedestal(Vector2i offset) {
        return this.level.getBlockState(this.getBlockPos().offset(offset.x, 0, offset.y)).is(CDMBlocks.PEDESTAL);
    }

    private boolean hasItemInInventory(Vector2i offset, Item item) {
        return ((PedestalBlockEntity)this.level.getBlockEntity((BlockPos)this.getBlockPos().offset((int)offset.x, (int)0, (int)offset.y))).inventory.getStackInSlot(0).is(item);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"blockentity.livestreammods.pedestal");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new PedestalMenu(pContainerId, pPlayerInventory, this);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }
}

