/*
 * Decompiled with CFR 0.152.
 */
package de.domenikyt1.createdomeniksmod.register.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.domenikyt1.createdomeniksmod.register.block.CDMBlocks;
import de.domenikyt1.createdomeniksmod.register.block.custom.PedestalBlock;
import de.domenikyt1.createdomeniksmod.register.block.entity.custom.AltarBlockEntity;
import java.util.List;
import net.kaupenjoe.livestreammods.render.ModRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Vector2i;

public class AltarBlockEntityRenderer
implements BlockEntityRenderer<AltarBlockEntity> {
    List<Vector2i> offsets = List.of(new Vector2i(3, 0), new Vector2i(2, 2), new Vector2i(0, 3), new Vector2i(2, -2), new Vector2i(-2, 2), new Vector2i(-2, -2), new Vector2i(0, -3), new Vector2i(-3, 0));
    public Entity entity = null;

    public AltarBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(AltarBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack stack = pBlockEntity.inventory.getStackInSlot(0);
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        pPoseStack.pushPose();
        pPoseStack.translate(0.5f, 1.15f, 0.5f);
        pPoseStack.scale(0.5f, 0.5f, 0.5f);
        pPoseStack.mulPose(Axis.YP.rotationDegrees(pBlockEntity.getRenderingRotation()));
        itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, this.getLightLevel(pBlockEntity.getLevel(), pBlockEntity.getBlockPos()), OverlayTexture.NO_OVERLAY, pPoseStack, pBufferSource, pBlockEntity.getLevel(), 1);
        pPoseStack.popPose();
        this.offsets.forEach(offset -> {
            if (pBlockEntity.getLevel().getBlockState(pBlockEntity.getBlockPos().offset(offset.x, 0, offset.y)).isAir()) {
                AltarBlockEntityRenderer.renderSidePedestal(pBlockEntity, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, offset.x, offset.y);
            }
        });
        pPoseStack.pushPose();
        pPoseStack.translate(0.5f, 0.5f + (float)pBlockEntity.count * 0.01f, 0.5f);
        pPoseStack.scale(0.5f + (float)pBlockEntity.count * 0.05f, 0.5f + (float)pBlockEntity.count * 0.05f, 0.5f + (float)pBlockEntity.count * 0.05f);
        pPoseStack.mulPose(Axis.YP.rotationDegrees(pBlockEntity.getRenderingRotation() * 0.15f * (float)pBlockEntity.count));
        this.entity = pBlockEntity.entityLastSacrificed != null ? pBlockEntity.entityLastSacrificed.create((Level)Minecraft.getInstance().level) : null;
        if (this.entity != null) {
            entityRenderDispatcher.render(this.entity, 0.0, 1.25, 0.0, 0.0f, pPartialTick, pPoseStack, pBufferSource, pPackedLight);
        }
        pPoseStack.popPose();
    }

    private static void renderSidePedestal(AltarBlockEntity pBlockEntity, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, float xOffset, float zOffset) {
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        BlockState state = ((PedestalBlock)((Object)CDMBlocks.PEDESTAL.get())).defaultBlockState();
        BakedModel model = blockRenderer.getBlockModel(state);
        pPoseStack.pushPose();
        pPoseStack.translate(xOffset, 0.0f, zOffset);
        RenderType translucentType = ModRenderTypes.GHOST;
        VertexConsumer consumer = pBufferSource.getBuffer(translucentType).setColor(1.0f, 1.0f, 1.0f, 0.5f);
        blockRenderer.getModelRenderer().renderModel(pPoseStack.last(), consumer, state, model, 1.0f, 1.0f, 1.0f, pPackedLight, pPackedOverlay, ModelData.EMPTY, translucentType);
        pPoseStack.popPose();
    }

    public boolean shouldRenderOffScreen(AltarBlockEntity blockEntity) {
        return true;
    }

    public AABB getRenderBoundingBox(AltarBlockEntity blockEntity) {
        return AABB.INFINITE;
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

