/*
 * Decompiled with CFR 0.152.
 */
package de.domenikyt1.createdomeniksmod.register.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.domenikyt1.createdomeniksmod.register.recipe.PedestalRecipe;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class PedestalRecipeSerializer
implements RecipeSerializer<PedestalRecipe> {
    public static final Codec<Ingredient> MULTI_INGREDIENT_CODEC = Codec.either((Codec)Ingredient.CODEC_NONEMPTY, (Codec)Ingredient.CODEC_NONEMPTY.listOf()).xmap(either -> {
        if (either.left().isPresent()) {
            return (Ingredient)either.left().get();
        }
        return Ingredient.fromValues(((List)either.right().get()).stream().flatMap(i -> Arrays.stream(i.getItems())).map(stack -> new Ingredient.ItemValue(stack)));
    }, ingredient -> Either.left((Object)ingredient));
    public static final MapCodec<PedestalRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)MULTI_INGREDIENT_CODEC.listOf().fieldOf("ingredients").flatXmap(list -> {
        Object[] aingredient = (Ingredient[])list.toArray(Ingredient[]::new);
        return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
    }, DataResult::success).forGetter(PedestalRecipe::getIngredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(PedestalRecipe::output), (App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entityType").forGetter(PedestalRecipe::entityType)).apply((Applicative)inst, PedestalRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PedestalRecipe> STREAM_CODEC = StreamCodec.of(PedestalRecipeSerializer::toNetwork, PedestalRecipeSerializer::fromNetwork);

    public MapCodec<PedestalRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, PedestalRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    private static PedestalRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        int i = buffer.readVarInt();
        NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
        nonnulllist.replaceAll(p -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
        ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        EntityType entityType = (EntityType)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE).decode((Object)buffer);
        return new PedestalRecipe((NonNullList<Ingredient>)nonnulllist, itemstack, entityType);
    }

    private static void toNetwork(RegistryFriendlyByteBuf buffer, PedestalRecipe recipe) {
        buffer.writeVarInt(recipe.ingredients().size());
        for (Ingredient ingredient : recipe.ingredients()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
        }
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output());
        ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE).encode((Object)buffer, recipe.entityType());
    }
}

