/*
 * Decompiled with CFR 0.152.
 */
package de.domenikyt1.createdomeniksmod.register.block.custom;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SailBlock
extends DirectionalBlock {
    public static final MapCodec<SailBlock> CODEC = SailBlock.simpleCodec(SailBlock::new);
    private static final VoxelShape UP = Block.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    private static final VoxelShape DOWN = Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    private static final VoxelShape EAST = Block.box((double)5.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST = Block.box((double)6.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)11.0);
    private static final VoxelShape SOUTH = Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)10.0);

    public SailBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
            case Direction.EAST -> EAST;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
        };
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

