/*
 * Decompiled with CFR 0.152.
 */
package de.domenikyt1.createdomeniksmod.register.event;

import de.domenikyt1.createdomeniksmod.networking.ClientPayloadHandler;
import de.domenikyt1.createdomeniksmod.networking.PedestalCraftCountS2C;
import de.domenikyt1.createdomeniksmod.networking.ResetSacrificedEntityS2C;
import de.domenikyt1.createdomeniksmod.register.block.entity.custom.AltarBlockEntity;
import de.domenikyt1.createdomeniksmod.register.item.custom.ExcavatorItem;
import de.domenikyt1.createdomeniksmod.register.item.custom.HammerItem;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="createdomeniksmod")
public class ModEvents {
    private static final Set<BlockPos> HARVESTED_BLOCKS = new HashSet<BlockPos>();
    private static final Set<BlockPos> HARVESTED_BLOCKS1 = new HashSet<BlockPos>();

    @SubscribeEvent
    public static void onAnimalSacrifice(LivingDeathEvent event) {
        Level level = event.getEntity().level();
        AABB blocksAround = AABB.ofSize((Vec3)event.getEntity().blockPosition().getCenter(), (double)5.0, (double)3.0, (double)5.0);
        Stream position = BlockPos.betweenClosedStream((AABB)blocksAround);
        position.forEach(pos -> {
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            if (patt0$temp instanceof AltarBlockEntity) {
                AltarBlockEntity altarBlockEntity = (AltarBlockEntity)patt0$temp;
                altarBlockEntity.setSacrificedEntity(event.getEntity().getType());
            }
        });
    }

    @SubscribeEvent
    public static void onHammerUsage(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack mainHandItem = player.getMainHandItem();
        Item item = mainHandItem.getItem();
        if (item instanceof HammerItem) {
            HammerItem hammer = (HammerItem)item;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockPos initialBlockPos = event.getPos();
                if (HARVESTED_BLOCKS.contains(initialBlockPos)) {
                    return;
                }
                for (BlockPos pos : HammerItem.getBlocksToBeDestroyed(1, initialBlockPos, serverPlayer)) {
                    if (pos == initialBlockPos || !hammer.isCorrectToolForDrops(mainHandItem, event.getLevel().getBlockState(pos))) continue;
                    HARVESTED_BLOCKS.add(pos);
                    serverPlayer.gameMode.destroyBlock(pos);
                    HARVESTED_BLOCKS.remove(pos);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onExcavatorUsage(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack mainHandItem = player.getMainHandItem();
        Item item = mainHandItem.getItem();
        if (item instanceof ExcavatorItem) {
            ExcavatorItem excavator = (ExcavatorItem)item;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockPos initialBlockPos = event.getPos();
                if (HARVESTED_BLOCKS1.contains(initialBlockPos)) {
                    return;
                }
                for (BlockPos pos : ExcavatorItem.getBlocksToBeDestroyed(1, initialBlockPos, serverPlayer)) {
                    if (pos == initialBlockPos || !excavator.isCorrectToolForDrops(mainHandItem, event.getLevel().getBlockState(pos))) continue;
                    HARVESTED_BLOCKS1.add(pos);
                    serverPlayer.gameMode.destroyBlock(pos);
                    HARVESTED_BLOCKS1.remove(pos);
                }
            }
        }
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1").executesOn(HandlerThread.MAIN);
        registrar.commonToClient(ResetSacrificedEntityS2C.TYPE, ResetSacrificedEntityS2C.STREAM_CODEC, ClientPayloadHandler::handleSacrificeOnClient);
        registrar.commonToClient(PedestalCraftCountS2C.TYPE, PedestalCraftCountS2C.STREAM_CODEC, ClientPayloadHandler::handleCountOnClient);
    }
}

