/*
 * Decompiled with CFR 0.152.
 */
package de.domenikyt1.createdomeniksmod.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.domenikyt1.createdomeniksmod.recipe.ModRecipes;
import de.domenikyt1.createdomeniksmod.recipe.PedestalRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record PedestalRecipe(NonNullList<Ingredient> ingredients, ItemStack output, EntityType<?> entityType) implements Recipe<PedestalRecipeInput>
{
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(PedestalRecipeInput pedestalRecipeInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        if (!((Ingredient)this.ingredients.get(0)).test(pedestalRecipeInput.mainPedestalItem())) {
            return false;
        }
        for (int i = 0; i < pedestalRecipeInput.sidePedestalItems().size(); ++i) {
            if (((Ingredient)this.ingredients.get(i + 1)).test(pedestalRecipeInput.sidePedestalItems().get(i))) continue;
            return false;
        }
        return pedestalRecipeInput.entityType() == this.entityType;
    }

    public ItemStack assemble(PedestalRecipeInput pedestalRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.PEDESTAL_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.PEDESTAL_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<PedestalRecipe> {
        public static final MapCodec<PedestalRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] aingredient = (Ingredient[])list.toArray(Ingredient[]::new);
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(PedestalRecipe::getIngredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(PedestalRecipe::output), (App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entityType").forGetter(PedestalRecipe::entityType)).apply((Applicative)inst, PedestalRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PedestalRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<PedestalRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PedestalRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static PedestalRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int i = buffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(p_319735_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            EntityType entityType = (EntityType)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE).decode((Object)buffer);
            return new PedestalRecipe((NonNullList<Ingredient>)nonnulllist, itemstack, entityType);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, PedestalRecipe recipe) {
            buffer.writeVarInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE).encode((Object)buffer, recipe.entityType);
        }
    }
}

