/*
 * Decompiled with CFR 0.152.
 */
package Oneblock;

import Oneblock.ChestItems;
import Oneblock.Island;
import Oneblock.LegacyConfigSaver;
import Oneblock.Level;
import Oneblock.Messages;
import Oneblock.Oneblock;
import Oneblock.PlData.LowerCaseYaml;
import Oneblock.PlayerInfo;
import Oneblock.RewardManager;
import Oneblock.Utils.Utils;
import Oneblock.Utils.lib.XMaterial;
import Oneblock.WorldGuard.OBWorldGuard;
import Oneblock.gui.GUI;
import com.nexomc.nexo.api.NexoBlocks;
import dev.lone.itemsadder.api.CustomBlock;
import io.th0rgal.oraxen.api.OraxenItems;
import java.io.File;
import java.util.List;
import java.util.UUID;
import net.momirealms.craftengine.bukkit.api.CraftEngineBlocks;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class ConfigManager {
    public YamlConfiguration config_temp;
    public RewardManager reward = new RewardManager();

    public void loadConfigFiles() {
        this.Configfile();
        this.Chestfile();
        this.Blockfile();
        this.Flowerfile();
        this.Messagefile();
        this.reward.loadRewards();
    }

    private void Configfile() {
        File con = new File(Oneblock.plugin.getDataFolder(), "config.yml");
        if (!con.exists()) {
            Oneblock.plugin.saveResource("config.yml", false);
        }
        Oneblock.config = LowerCaseYaml.loadAndFixConfig(con);
        Oneblock.plugin.setPosition(Bukkit.getWorld((String)this.Check("world", "world")), (int)this.Check("x", (double)Oneblock.x), (int)this.Check("y", (double)Oneblock.y), (int)this.Check("z", (double)Oneblock.z));
        Oneblock.plugin.setLeave(Bukkit.getWorld((String)this.Check("leaveworld", "world")), this.Check("xleave", 0.0), this.Check("yleave", 0.0), this.Check("zleave", 0.0), (float)this.Check("yawleave", 0.0));
        if (!Oneblock.superlegacy) {
            Oneblock.Progress_bar = this.Check("progress_bar", true);
            Level.max.color = BarColor.valueOf((String)this.Check("progress_bar_color", "GREEN"));
            Level.max.style = BarStyle.valueOf((String)this.Check("progress_bar_style", "SOLID"));
            Oneblock.TextP = this.Check("progress_bar_text", "level");
            Oneblock.lvl_bar_mode = Oneblock.TextP.equals("level");
        }
        Oneblock.island_for_new_players = this.Check("island_for_new_players", true);
        Level.multiplier = this.Check("level_multiplier", Level.multiplier);
        Oneblock.max_players_team = this.Check("max_players_team", Oneblock.max_players_team);
        this.UpdateBoolParametrs();
        OBWorldGuard.setEnabled(this.Check("worldguard", false));
        OBWorldGuard.flags = this.Check("wgflags", OBWorldGuard.flags);
        Oneblock.offset = this.Check("set", 100);
        if (Oneblock.config.isSet("custom_island") && !Oneblock.legacy) {
            Island.read((FileConfiguration)Oneblock.config);
        }
        LegacyConfigSaver.Save((FileConfiguration)Oneblock.config, con);
    }

    public void UpdateBoolParametrs() {
        Oneblock.CircleMode = this.Check("circlemode", Oneblock.CircleMode);
        Oneblock.UseEmptyIslands = this.Check("useemptyislands", Oneblock.UseEmptyIslands);
        Oneblock.saveplayerinventory = this.Check("saveplayerinventory", Oneblock.saveplayerinventory);
        Oneblock.protection = this.Check("protection", Oneblock.protection);
        Oneblock.autojoin = this.Check("autojoin", Oneblock.autojoin);
        Oneblock.droptossup = this.Check("droptossup", Oneblock.droptossup);
        Oneblock.physics = this.Check("physics", Oneblock.physics);
        Oneblock.particle = this.Check("particle", Oneblock.particle);
        Oneblock.allow_nether = this.Check("allow_nether", Oneblock.allow_nether);
        GUI.enabled = this.Check("gui", GUI.enabled);
        Oneblock.rebirth = this.Check("rebirth_on_the_island", Oneblock.rebirth);
        if (Oneblock.isBorderSupported) {
            Oneblock.Border = this.Check("border", Oneblock.Border);
        }
    }

    public void Blockfile() {
        Oneblock.plugin.blocks.clear();
        Oneblock.plugin.mobs.clear();
        Level.levels.clear();
        File block = new File(Oneblock.plugin.getDataFolder(), "blocks.yml");
        if (!block.exists()) {
            Oneblock.plugin.saveResource("blocks.yml", false);
        }
        this.config_temp = YamlConfiguration.loadConfiguration((File)block);
        if (this.config_temp.isString("MaxLevel")) {
            Level.max.name = Utils.translateColorCodes(this.config_temp.getString("MaxLevel"));
        }
        int i = 0;
        while (this.config_temp.isList(String.format("%d", i))) {
            List bl_temp = this.config_temp.getStringList(String.format("%d", i));
            Level level = new Level(Utils.translateColorCodes((String)bl_temp.get(0)));
            Level.levels.add(level);
            int q = 1;
            if (!Oneblock.superlegacy && q < bl_temp.size()) {
                try {
                    level.color = BarColor.valueOf((String)((String)bl_temp.get(q)).toUpperCase());
                    ++q;
                }
                catch (Exception e) {
                    level.color = Level.max.color;
                }
                try {
                    level.style = BarStyle.valueOf((String)((String)bl_temp.get(q)).toUpperCase());
                    ++q;
                }
                catch (Exception e) {
                    level.style = Level.max.style;
                }
            }
            try {
                int value = Integer.parseInt((String)bl_temp.get(q));
                level.length = value > 0 ? value : 1;
                ++q;
            }
            catch (Exception e) {
                level.length = 16 + level.getId() * Level.multiplier;
            }
            while (q < bl_temp.size()) {
                String text;
                if ((text = (String)bl_temp.get(q++)).charAt(0) == '/') {
                    Oneblock.plugin.blocks.add(text);
                    continue;
                }
                boolean check = false;
                for (String str : ChestItems.getChestNames()) {
                    if (!text.equals(str)) continue;
                    check = Oneblock.plugin.blocks.add(str);
                    break;
                }
                if (check) continue;
                try {
                    Oneblock.plugin.mobs.add(EntityType.valueOf((String)text));
                }
                catch (Exception exception) {
                    Object a;
                    if (Oneblock.legacy) {
                        a = XMaterial.matchXMaterial(text);
                        if (!a.isPresent()) {
                            Oneblock.plugin.blocks.add(null);
                            continue;
                        }
                        XMaterial xmt = (XMaterial)a.get();
                        if (xmt == Oneblock.GRASS_BLOCK) {
                            Oneblock.plugin.blocks.add(null);
                            continue;
                        }
                        if (xmt == XMaterial.CHEST) {
                            Oneblock.plugin.blocks.add(Material.CHEST);
                            continue;
                        }
                        Oneblock.plugin.blocks.add(xmt);
                        continue;
                    }
                    a = Material.matchMaterial((String)text);
                    if (a != null && a.equals(Material.GRASS_BLOCK)) {
                        a = null;
                    }
                    if (a == null) {
                        switch (Oneblock.plugin.placetype) {
                            case ItemsAdder: {
                                CustomBlock customBlock = CustomBlock.getInstance((String)text);
                                if (customBlock == null) break;
                                a = customBlock;
                                break;
                            }
                            case Oraxen: {
                                if (!OraxenItems.exists((String)text)) break;
                                a = text;
                                break;
                            }
                            case Nexo: {
                                if (!NexoBlocks.isCustomBlock((String)text)) break;
                                a = text;
                                break;
                            }
                            case CraftEngine: {
                                Key key;
                                String[] pcid = text.split(":", 2);
                                if (pcid.length != 2 || CraftEngineBlocks.byId((Key)(key = Key.of((String[])pcid))) == null) break;
                                a = key;
                                break;
                            }
                        }
                    }
                    Oneblock.plugin.blocks.add(a);
                }
            }
            level.blocks = Oneblock.plugin.blocks.size();
            level.mobs = Oneblock.plugin.mobs.size();
            ++i;
        }
        Level.max.blocks = Oneblock.plugin.blocks.size();
        Level.max.mobs = Oneblock.plugin.mobs.size();
        if (Level.max.mobs == 0) {
            Oneblock.plugin.getLogger().warning("Mobs are not set in the blocks.yml");
        }
        this.SetupProgressBar();
    }

    public void SetupProgressBar() {
        if (Oneblock.superlegacy) {
            return;
        }
        if (PlayerInfo.size() == 0) {
            return;
        }
        if (Level.max.color == null) {
            Level.max.color = BarColor.GREEN;
        }
        if (Level.max.style == null) {
            Level.max.style = BarStyle.SOLID;
        }
        PlayerInfo.list.forEach(inf -> {
            if (inf.uuid != null) {
                Player p = Bukkit.getPlayer((UUID)inf.uuid);
                if (p == null) {
                    inf.createBar();
                } else {
                    inf.createBar(Oneblock.getBarTitle(p, inf.lvl));
                }
                inf.bar.setVisible(Oneblock.Progress_bar);
            }
        });
    }

    private void Messagefile() {
        File message = new File(Oneblock.plugin.getDataFolder(), "messages.yml");
        if (!message.exists()) {
            Oneblock.plugin.saveResource("messages.yml", false);
        }
        this.config_temp = YamlConfiguration.loadConfiguration((File)message);
        Messages.help = this.MessageCheck("help", Messages.help);
        Messages.help_adm = this.MessageCheck("help_adm", Messages.help_adm);
        Messages.invite_usage = this.MessageCheck("invite_usage", Messages.invite_usage);
        Messages.invite_yourself = this.MessageCheck("invite_yourself", Messages.invite_yourself);
        Messages.invite_no_island = this.MessageCheck("invite_no_island", Messages.invite_no_island);
        Messages.invite_team = this.MessageCheck("invite_team", Messages.invite_team);
        Messages.invited = this.MessageCheck("invited", Messages.invited);
        Messages.invited_succes = this.MessageCheck("invited_succes", Messages.invited_succes);
        Messages.kicked = this.MessageCheck("kicked", Messages.kicked);
        Messages.kick_usage = this.MessageCheck("kick_usage", Messages.kick_usage);
        Messages.kick_yourself = this.MessageCheck("kick_yourself", Messages.kick_yourself);
        Messages.accept_succes = this.MessageCheck("accept_succes", Messages.accept_succes);
        Messages.accept_none = this.MessageCheck("accept_none", Messages.accept_none);
        Messages.idreset = this.MessageCheck("idreset", Messages.idreset);
        Messages.protection = this.MessageCheck("protection", Messages.protection);
        Messages.leave_not_set = this.MessageCheck("leave_not_set", Messages.leave_not_set);
        Messages.not_allow_visit = this.MessageCheck("not_allow_visit", Messages.not_allow_visit);
        Messages.allowed_visit = this.MessageCheck("allowed_visit", Messages.allowed_visit);
        Messages.forbidden_visit = this.MessageCheck("forbidden_visit", Messages.forbidden_visit);
        File gui = new File(Oneblock.plugin.getDataFolder(), "gui.yml");
        if (!gui.exists()) {
            Oneblock.plugin.saveResource("gui.yml", false);
        }
        this.config_temp = YamlConfiguration.loadConfiguration((File)gui);
        Messages.baseGUI = this.MessageCheck("baseGUI", Messages.baseGUI);
        Messages.acceptGUI = this.MessageCheck("acceptGUI", Messages.acceptGUI);
        Messages.acceptGUIignore = this.MessageCheck("acceptGUIignore", Messages.acceptGUIignore);
        Messages.acceptGUIjoin = this.MessageCheck("acceptGUIjoin", Messages.acceptGUIjoin);
        Messages.topGUI = this.MessageCheck("topGUI", Messages.topGUI);
        Messages.visitGUI = this.MessageCheck("visitGUI", Messages.visitGUI);
        Messages.idresetGUI = this.MessageCheck("idresetGUI", Messages.idresetGUI);
    }

    private String MessageCheck(String name, String def_message) {
        if (this.config_temp.isString(name)) {
            return Utils.translateColorCodes(this.config_temp.getString(name));
        }
        return def_message;
    }

    private void Flowerfile() {
        Oneblock.plugin.flowers.clear();
        File flower = new File(Oneblock.plugin.getDataFolder(), "flowers.yml");
        if (!flower.exists()) {
            Oneblock.plugin.saveResource("flowers.yml", false);
        }
        this.config_temp = YamlConfiguration.loadConfiguration((File)flower);
        Oneblock.plugin.flowers.add(Oneblock.GRASS);
        for (String list : this.config_temp.getStringList("flowers")) {
            if (!XMaterial.matchXMaterial(list).isPresent()) {
                Oneblock.plugin.flowers.add(Oneblock.GRASS);
                continue;
            }
            Oneblock.plugin.flowers.add(XMaterial.matchXMaterial(list).get());
        }
    }

    private void Chestfile() {
        File chest = new File(Oneblock.plugin.getDataFolder(), "chests.yml");
        if (!chest.exists()) {
            Oneblock.plugin.saveResource("chests.yml", false);
        }
        ChestItems.chest = chest;
        ChestItems.load();
    }

    String Check(String type, String data) {
        if (!Oneblock.config.isString(type)) {
            Oneblock.config.set(type, (Object)data);
        }
        return Oneblock.config.getString(type);
    }

    int Check(String type, int data) {
        if (!Oneblock.config.isInt(type)) {
            Oneblock.config.set(type, (Object)data);
        }
        return Oneblock.config.getInt(type);
    }

    double Check(String type, double data) {
        if (!Oneblock.config.isDouble(type)) {
            Oneblock.config.set(type, (Object)data);
        }
        return Oneblock.config.getDouble(type);
    }

    boolean Check(String type, boolean data) {
        if (!Oneblock.config.isBoolean(type)) {
            Oneblock.config.set(type, (Object)data);
        }
        return Oneblock.config.getBoolean(type);
    }

    List<String> Check(String type, List<String> data) {
        if (!Oneblock.config.isList(type)) {
            Oneblock.config.set(type, data);
        }
        return Oneblock.config.getStringList(type);
    }
}

