/*
 * Decompiled with CFR 0.152.
 */
package Oneblock.Events;

import Oneblock.Oneblock;
import Oneblock.PlayerInfo;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class BlockEvent
implements Listener {
    private static final double DROP_TELEPORT_HEIGHT_OFFSET = 0.8;
    private static final Vector UPWARD_VELOCITY = new Vector(0.0, 0.1, 0.0);

    @EventHandler(ignoreCancelled=true)
    public void ItemStackSpawn(ItemSpawnEvent e) {
        if (!Oneblock.droptossup) {
            return;
        }
        World world = Oneblock.getWorld();
        if (world == null) {
            return;
        }
        Location loc = e.getLocation();
        if (!world.equals((Object)loc.getWorld())) {
            return;
        }
        if (loc.getBlockY() != Oneblock.y) {
            return;
        }
        if ((Oneblock.x - loc.getBlockX()) % Oneblock.offset != 0) {
            return;
        }
        if ((Oneblock.z - loc.getBlockZ()) % Oneblock.offset != 0) {
            return;
        }
        Item drop = e.getEntity();
        drop.teleport(loc.add(0.0, 0.8, 0.0));
        drop.setVelocity(UPWARD_VELOCITY);
    }

    @EventHandler
    public void BlockBreak(BlockBreakEvent e) {
        World world = Oneblock.getWorld();
        if (world == null) {
            return;
        }
        Block block = e.getBlock();
        if (block.getWorld() != world) {
            return;
        }
        if (block.getY() != Oneblock.y) {
            return;
        }
        Player ponl = e.getPlayer();
        UUID uuid = ponl.getUniqueId();
        int plID = PlayerInfo.GetId(uuid);
        if (plID == -1) {
            return;
        }
        int[] result = Oneblock.plugin.getIslandCoordinates(plID);
        if (block.getX() != result[0]) {
            return;
        }
        if (block.getZ() != result[1]) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Oneblock.plugin, () -> Oneblock.plugin.BlockGen(result[0], result[1], plID, ponl, block), 1L);
    }
}

