/*
 * Decompiled with CFR 0.152.
 */
package Oneblock;

import Oneblock.Oneblock;
import Oneblock.Utils.Utils;
import Oneblock.Utils.lib.XBlock;
import Oneblock.Utils.lib.XMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.FileConfiguration;

public class Island {
    public static BlockData[][][] custom = null;
    private static final int SIZE = 7;
    private static final int HEIGHT = 12;
    private static final int OFFSET_Y = 5;

    public static HashMap<String, List<String>> map() {
        if (custom == null) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (int y = 0; y < 12; ++y) {
            if (Island.isLayerEmpty(y)) continue;
            ArrayList<String> yData = new ArrayList<String>();
            for (int x = 0; x < 7; ++x) {
                for (int z = 0; z < 7; ++z) {
                    yData.add(custom[x][y][z].getAsString());
                }
            }
            map.put(String.format("y%d", y - 5), yData);
        }
        return map;
    }

    public static void read(FileConfiguration config) {
        int y;
        custom = new BlockData[7][12][7];
        BlockData AIR_DATA = Material.AIR.createBlockData();
        for (y = 0; y < 12; ++y) {
            Island.fillLayer(y, AIR_DATA);
        }
        for (y = 0; y < 12; ++y) {
            String configKey = String.format("custom_island.y%d", y - 5);
            if (!config.isList(configKey)) continue;
            List blockDataStrings = config.getStringList(configKey);
            for (int x = 0; x < 7; ++x) {
                for (int z = 0; z < 7; ++z) {
                    Island.custom[x][y][z] = Bukkit.createBlockData((String)((String)blockDataStrings.get(7 * x + z)));
                }
            }
        }
    }

    public static void scan(World world, int x, int y, int z) {
        custom = new BlockData[7][12][7];
        for (int xx = 0; xx < 7; ++xx) {
            for (int yy = 0; yy < 12; ++yy) {
                for (int zz = 0; zz < 7; ++zz) {
                    Block block = world.getBlockAt(x + xx - 3, y + yy - 5, z - 3 + zz);
                    Island.custom[xx][yy][zz] = block.getBlockData();
                }
            }
        }
    }

    public static void clear(World world, int x, int y, int z, int radius) {
        int startX = x - radius;
        int startY = Math.max(y - 12, Utils.getWorldMinHeight(world) + 1);
        int startZ = z - radius;
        int diameter = radius * 2;
        for (int xx = 0; xx < diameter; ++xx) {
            for (int yy = 0; yy < 24; ++yy) {
                for (int zz = 0; zz < diameter; ++zz) {
                    Block block = world.getBlockAt(startX + xx, startY + yy, startZ + zz);
                    if (block.getType().equals((Object)Material.AIR)) continue;
                    block.setType(Material.AIR);
                }
            }
        }
    }

    public static void place(World world, int x, int y, int z) {
        XBlock.setType(Oneblock.getWorld().getBlockAt(x, y, z), XMaterial.GRASS_BLOCK);
        if (!Oneblock.island_for_new_players) {
            return;
        }
        if (custom == null) {
            Island.createDefaultIsland(world, x, y, z);
            return;
        }
        for (int xx = 0; xx < 7; ++xx) {
            for (int yy = 0; yy < 12; ++yy) {
                for (int zz = 0; zz < 7; ++zz) {
                    BlockData blockData = custom[xx][yy][zz];
                    if (blockData.getMaterial().equals((Object)Material.AIR)) continue;
                    Block block = world.getBlockAt(x - 3 + xx, y + yy - 5, z - 3 + zz);
                    block.setBlockData(blockData);
                }
            }
        }
    }

    private static void fillLayer(int y, BlockData blockData) {
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                Island.custom[x][y][z] = blockData;
            }
        }
    }

    private static boolean isLayerEmpty(int y) {
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                if (custom[x][y][z].getMaterial().equals((Object)Material.AIR)) continue;
                return false;
            }
        }
        return true;
    }

    private static void createDefaultIsland(World world, int x, int y, int z) {
        for (int i = -2; i <= 2; ++i) {
            for (int q = -2; q <= 2; ++q) {
                if (Math.abs(i) + Math.abs(q) >= 3) continue;
                XBlock.setType(world.getBlockAt(x + i, y, z + q), XMaterial.GRASS_BLOCK);
            }
        }
    }
}

