/*
 * Decompiled with CFR 0.152.
 */
package Oneblock;

import Oneblock.Level;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class PlayerInfo {
    public static ArrayList<PlayerInfo> list = new ArrayList();
    public static final PlayerInfo not_found = new PlayerInfo(null);
    public UUID uuid;
    public ArrayList<UUID> uuids = new ArrayList();
    public int lvl = 0;
    public int breaks = 0;
    public BossBar bar = null;
    public boolean allow_visit = false;
    public static final Comparator<PlayerInfo> COMPARE_BY_LVL = new Comparator<PlayerInfo>(){

        @Override
        public int compare(PlayerInfo lhs, PlayerInfo rhs) {
            if (rhs.uuid == null) {
                return -1;
            }
            return rhs.lvl - lhs.lvl;
        }
    };

    public PlayerInfo(UUID uuid) {
        this.uuid = uuid;
    }

    public Level lvlup() {
        ++this.lvl;
        this.breaks = 0;
        return Level.get(this.lvl);
    }

    public void createBar() {
        Level level = Level.get(this.lvl);
        this.createBar(level.name, level.color, level.style);
    }

    public void createBar(String title) {
        Level level = Level.get(this.lvl);
        this.createBar(title, level.color, level.style);
    }

    private void createBar(String text, BarColor color, BarStyle style) {
        if (this.bar == null) {
            this.bar = Bukkit.createBossBar((String)text, (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[]{BarFlag.DARKEN_SKY});
            return;
        }
        this.bar.setTitle(text);
        this.bar.setColor(color);
        this.bar.setStyle(style);
    }

    public void removeBar(OfflinePlayer p) {
        if (this.bar == null) {
            return;
        }
        if (!(p instanceof Player)) {
            return;
        }
        this.bar.removePlayer((Player)p);
    }

    public void removeUUID(UUID deleted) {
        if (this.uuid.equals(deleted)) {
            this.uuid = !this.uuids.isEmpty() ? this.uuids.remove(0) : null;
        } else {
            this.uuids.remove(deleted);
        }
    }

    public int getNeed() {
        return Level.get((int)this.lvl).length;
    }

    public double getPercent() {
        return (double)this.breaks / (double)this.getNeed();
    }

    public static void removeBarStatic(Player p) {
        if (list.size() == 0) {
            return;
        }
        PlayerInfo.get(p.getUniqueId()).removeBar((OfflinePlayer)p);
    }

    public static int GetId(UUID name) {
        for (int i = 0; i < PlayerInfo.size(); ++i) {
            PlayerInfo pl = PlayerInfo.get(i);
            if (pl.uuid == null) continue;
            if (pl.uuid.equals(name)) {
                return i;
            }
            if (!pl.uuids.contains(name)) continue;
            return i;
        }
        return -1;
    }

    public static boolean ExistNoInvaitId(UUID name) {
        for (PlayerInfo pl : list) {
            if (pl.uuid == null || !pl.uuid.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static PlayerInfo get(int id) {
        return list.get(id);
    }

    public static PlayerInfo get(UUID uuid) {
        int plID = PlayerInfo.GetId(uuid);
        if (plID == -1) {
            return not_found;
        }
        return list.get(plID);
    }

    public static void set(int id, PlayerInfo pInf) {
        if (id < list.size()) {
            list.set(id, pInf);
        } else {
            list.add(pInf);
        }
    }

    public static int getFreeId(boolean UseEmptyIslands) {
        if (UseEmptyIslands) {
            return PlayerInfo.getNull();
        }
        return PlayerInfo.size();
    }

    public static int size() {
        return list.size();
    }

    private static int getNull() {
        for (int i = 0; list.size() > i; ++i) {
            if (PlayerInfo.list.get((int)i).uuid != null) continue;
            return i;
        }
        return list.size();
    }
}

