/*
 * Decompiled with CFR 0.152.
 */
package Oneblock.Utils;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.World;

public class Utils {
    public static boolean isWorldMinHeightSupported = Utils.findMethod(World.class, "getMinHeight");

    public static boolean findMethod(Class<?> cl, String name) {
        return Arrays.stream(cl.getMethods()).anyMatch(m -> m.getName().equals(name));
    }

    public static String translateColorCodes(String message) {
        if (message == null) {
            return null;
        }
        message = Utils.translateHexColorCodes(message);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private static String translateHexColorCodes(String message) {
        if (!Utils.isHexColorSupported()) {
            return message;
        }
        Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
        Matcher matcher = hexPattern.matcher(message);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            matcher.appendReplacement(buffer, net.md_5.bungee.api.ChatColor.of((String)("#" + hexColor)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static boolean isHexColorSupported() {
        try {
            net.md_5.bungee.api.ChatColor.of((String)"#FFFFFF");
            return true;
        }
        catch (NoSuchMethodError e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getWorldMinHeight(World world) {
        if (isWorldMinHeightSupported) {
            return world.getMinHeight();
        }
        return 0;
    }
}

