/*
 * Decompiled with CFR 0.152.
 */
package Oneblock;

import Oneblock.Oneblock;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ChestItems {
    public static File chest;
    private static Map<String, List<ItemStack>> chests;

    public static void save() {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)chest);
        for (Map.Entry<String, List<ItemStack>> entry : chests.entrySet()) {
            ArrayList<String> simplifiedItems = new ArrayList<String>();
            for (ItemStack item : entry.getValue()) {
                if (item == null || item.getType() == Material.AIR) continue;
                if (!item.hasItemMeta()) {
                    simplifiedItems.add(item.getType().name());
                    continue;
                }
                simplifiedItems.add((String)item);
            }
            config.set(entry.getKey(), simplifiedItems);
        }
        try {
            config.save(chest);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void load() {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)chest);
        chests.clear();
        for (String name : config.getKeys(false)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ChestItems.loadItems(items, config.getList(name));
            chests.put(name, items);
        }
    }

    private static void loadItems(List<ItemStack> arr, List<?> data) {
        if (data == null) {
            return;
        }
        for (Object entry : data) {
            Material m;
            if (entry instanceof ItemStack) {
                arr.add((ItemStack)entry);
                continue;
            }
            if (!(entry instanceof String) || (m = Material.getMaterial((String)((String)entry))) == null) continue;
            arr.add(new ItemStack(m));
        }
    }

    public static ArrayList<String> getChestNames() {
        return new ArrayList<String>(chests.keySet());
    }

    public static List<ItemStack> getChest(String chestType) {
        return chests.get(chestType);
    }

    public static boolean fillChest(Inventory inv, String chestType) {
        List<ItemStack> ch = ChestItems.getChest(chestType);
        int max = Oneblock.rnd.nextInt(3) + 2;
        try {
            for (int i = 0; i < max; ++i) {
                ItemStack m = ch.get(Oneblock.rnd.nextInt(ch.size()));
                if (m.getMaxStackSize() == 1) {
                    m.setAmount(1);
                } else {
                    m.setAmount(Oneblock.rnd.nextInt(4) + 2);
                }
                inv.addItem(new ItemStack[]{m});
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static {
        chests = new HashMap<String, List<ItemStack>>();
    }
}

