/*
 * Decompiled with CFR 0.152.
 */
package Oneblock;

import Oneblock.Oneblock;
import Oneblock.Utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class RewardManager {
    private List<String> allRewards = new ArrayList<String>();
    private Map<Integer, List<String>> levelRewards = new HashMap<Integer, List<String>>();

    public void loadRewards() {
        YamlConfiguration config;
        this.allRewards.clear();
        this.levelRewards.clear();
        File rewardsFile = new File(Oneblock.plugin.getDataFolder(), "rewards.yml");
        if (!rewardsFile.exists()) {
            Oneblock.plugin.saveResource("rewards.yml", false);
        }
        if ((config = YamlConfiguration.loadConfiguration((File)rewardsFile)).isList("all")) {
            List rawRewards = config.getStringList("all");
            this.allRewards = new ArrayList<String>();
            for (String reward : rawRewards) {
                this.allRewards.add(Utils.translateColorCodes(reward));
            }
        }
        if (config.isConfigurationSection("levels")) {
            for (String levelStr : config.getConfigurationSection("levels").getKeys(false)) {
                try {
                    int level = Integer.parseInt(levelStr);
                    List rawRewards = config.getStringList("levels." + levelStr);
                    ArrayList<String> processedRewards = new ArrayList<String>();
                    for (String reward : rawRewards) {
                        processedRewards.add(Utils.translateColorCodes(reward));
                    }
                    this.levelRewards.put(level, processedRewards);
                }
                catch (NumberFormatException e) {
                    Oneblock.plugin.getLogger().warning("Invalid level number in rewards.yml: " + levelStr);
                }
            }
        }
        Oneblock.plugin.getLogger().info("Loaded " + this.allRewards.size() + " general rewards and " + this.levelRewards.size() + " level-specific reward sets");
    }

    public void executeRewards(Player player, int level, String levelName) {
        String playerName = player.getName();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%nick%", playerName);
        placeholders.put("%lvl_number%", String.valueOf(level));
        placeholders.put("%lvl_name%", levelName);
        this.executeCommandList(player, this.allRewards, placeholders);
        if (this.levelRewards.containsKey(level)) {
            this.executeCommandList(player, this.levelRewards.get(level), placeholders);
        }
    }

    private void executeCommandList(Player player, List<String> commands, Map<String, String> placeholders) {
        Iterator<String> iterator = commands.iterator();
        while (iterator.hasNext()) {
            String command;
            String finalCommand = command = iterator.next();
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                finalCommand = finalCommand.replace(entry.getKey(), entry.getValue());
            }
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCommand);
        }
    }

    public void reload() {
        this.loadRewards();
    }
}

