/*
 * Decompiled with CFR 0.152.
 */
package Oneblock.gui;

import Oneblock.ChestItems;
import Oneblock.Messages;
import Oneblock.Oneblock;
import Oneblock.PlayerInfo;
import Oneblock.Utils.lib.XMaterial;
import Oneblock.gui.ChestHolder;
import Oneblock.gui.GUIHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class GUI {
    public static boolean enabled = true;
    public static boolean legacy = false;
    static Inventory topGUI = null;

    public static void openGUI(Player p) {
        if (!enabled) {
            return;
        }
        if (p == null) {
            return;
        }
        Inventory mainGUI = Bukkit.createInventory((InventoryHolder)new GUIHolder(GUIHolder.GUIType.MAIN_MENU), (int)18, (String)Messages.baseGUI);
        mainGUI.addItem(new ItemStack[]{GUI.setMeta(XMaterial.GRASS_BLOCK, ChatColor.GREEN + "/ob join")});
        mainGUI.setItem(9, GUI.setMeta(XMaterial.PODZOL, ChatColor.GREEN + "/ob leave"));
        if (p.hasPermission("Oneblock.visit")) {
            mainGUI.setItem(10, GUI.setMeta(XMaterial.EMERALD_BLOCK, ChatColor.GREEN + "/ob allow_visit"));
            mainGUI.setItem(2, GUI.setMeta(XMaterial.MELON, ChatColor.GREEN + "/ob visit"));
        }
        mainGUI.setItem(4, GUI.setMeta(XMaterial.GOLD_BLOCK, ChatColor.GOLD + "/ob top"));
        mainGUI.setItem(6, GUI.setMeta(XMaterial.PAPER, ChatColor.GRAY + "/ob help"));
        mainGUI.setItem(8, GUI.setMeta(XMaterial.BARRIER, ChatColor.RED + "/ob idreset", Messages.idresetGUI));
        p.openInventory(mainGUI);
    }

    public static void acceptGUI(Player p, String name) {
        if (!enabled) {
            return;
        }
        if (p == null) {
            return;
        }
        Inventory acceptGUI = Bukkit.createInventory((InventoryHolder)new GUIHolder(GUIHolder.GUIType.INVITE), (int)9, (String)Messages.acceptGUI);
        acceptGUI.setItem(6, GUI.setMeta(XMaterial.REDSTONE_BLOCK, Messages.acceptGUIignore));
        acceptGUI.setItem(2, GUI.setMeta(XMaterial.EMERALD_BLOCK, String.format(Messages.acceptGUIjoin, name), Messages.idresetGUI));
        p.openInventory(acceptGUI);
    }

    public static void topGUI(Player p) {
        if (!enabled) {
            return;
        }
        if (p == null) {
            return;
        }
        if (topGUI == null) {
            topGUI = Bukkit.createInventory((InventoryHolder)new GUIHolder(GUIHolder.GUIType.TOP), (int)27, (String)Messages.topGUI);
        }
        PlayerInfo inf = Oneblock.gettop(0);
        topGUI.setItem(4, GUI.setMeta(XMaterial.NETHERITE_BLOCK, ChatColor.GOLD + "1st - " + GUI.parseUUID(inf.uuid), inf.lvl, GUI.parseUUIDs(inf.uuids)));
        inf = Oneblock.gettop(1);
        topGUI.setItem(12, GUI.setMeta(XMaterial.DIAMOND_BLOCK, ChatColor.GRAY + "2nd - " + GUI.parseUUID(inf.uuid), inf.lvl, GUI.parseUUIDs(inf.uuids)));
        inf = Oneblock.gettop(2);
        topGUI.setItem(14, GUI.setMeta(XMaterial.IRON_BLOCK, ChatColor.GRAY + "3rd - " + GUI.parseUUID(inf.uuid), inf.lvl, GUI.parseUUIDs(inf.uuids)));
        inf = Oneblock.gettop(3);
        topGUI.setItem(20, GUI.setMeta(XMaterial.GOLD_BLOCK, ChatColor.DARK_RED + "4th - " + GUI.parseUUID(inf.uuid), inf.lvl, GUI.parseUUIDs(inf.uuids)));
        inf = Oneblock.gettop(4);
        topGUI.setItem(22, GUI.setMeta(XMaterial.COPPER_BLOCK, ChatColor.DARK_RED + "5th - " + GUI.parseUUID(inf.uuid), inf.lvl, GUI.parseUUIDs(inf.uuids)));
        inf = Oneblock.gettop(5);
        topGUI.setItem(24, GUI.setMeta(XMaterial.COAL_BLOCK, ChatColor.DARK_RED + "6th - " + GUI.parseUUID(inf.uuid), inf.lvl, GUI.parseUUIDs(inf.uuids)));
        p.openInventory(topGUI);
    }

    public static void visitGUI(Player p, OfflinePlayer[] offlinePlayers) {
        if (!enabled) {
            return;
        }
        if (p == null) {
            return;
        }
        Inventory visitGUI = Bukkit.createInventory((InventoryHolder)new GUIHolder(GUIHolder.GUIType.VISIT), (int)54, (String)Messages.visitGUI);
        ArrayList<PlayerInfo> list = new ArrayList<PlayerInfo>();
        int size = 0;
        for (OfflinePlayer pl : offlinePlayers) {
            PlayerInfo inf = PlayerInfo.get(pl.getUniqueId());
            if (inf == null || !inf.allow_visit) continue;
            list.add(inf);
            ++size;
        }
        size = size > 54 ? 54 : size;
        for (int i = 0; i < size; ++i) {
            visitGUI.setItem(i, GUI.getPlayerHead(offlinePlayers[i], GUI.parseUUID(((PlayerInfo)list.get((int)i)).uuid)));
        }
        p.openInventory(visitGUI);
    }

    public static ItemStack getPlayerHead(OfflinePlayer player, String title) {
        ItemStack skull = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        if (!legacy) {
            skullMeta.setOwningPlayer(player);
        }
        skullMeta.setDisplayName(title);
        skull.setItemMeta((ItemMeta)skullMeta);
        return skull;
    }

    public static void chestGUI(Player p, String chestType) {
        if (p == null) {
            return;
        }
        List<ItemStack> list = ChestItems.getChest(chestType);
        Inventory chestGUI = Bukkit.createInventory((InventoryHolder)new ChestHolder(), (int)54, (String)String.format("%s %schest. %s", chestType, ChatColor.BLACK, "[Edit only in premium]"));
        for (ItemStack itm : list) {
            if (itm == null) continue;
            chestGUI.addItem(new ItemStack[]{itm});
        }
        p.openInventory(chestGUI);
    }

    private static String parseUUID(UUID uuid) {
        try {
            return Bukkit.getOfflinePlayer((UUID)uuid).getName();
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    private static String[] parseUUIDs(List<UUID> uuids) {
        String[] Lore = new String[uuids.size()];
        for (int i = 0; i < uuids.size(); ++i) {
            Lore[i] = GUI.parseUUID(uuids.get(i));
        }
        return Lore;
    }

    private static ItemStack setMeta(XMaterial material, String title) {
        return GUI.setMeta(material, title, 1, new String[0]);
    }

    private static ItemStack setMeta(XMaterial material, String title, String ... Lore) {
        return GUI.setMeta(material, title, 1, Lore);
    }

    private static ItemStack setMeta(XMaterial material, String title, int amount, String ... Lore) {
        Material m;
        if (amount <= 0) {
            amount = 1;
        }
        ItemStack join = new ItemStack((m = material.get()) == null ? Material.EMERALD_BLOCK : m, amount);
        ItemMeta meta = join.getItemMeta();
        meta.setDisplayName(title);
        meta.setLore(Arrays.asList(Lore));
        join.setItemMeta(meta);
        return join;
    }
}

