/*
 * Decompiled with CFR 0.152.
 */
package Oneblock.PlData;

import Oneblock.PlayerInfo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class JsonSimple {
    public static final Pattern p = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$");

    public static void Write(ArrayList<PlayerInfo> pls, File f) {
        JSONObject main = new JSONObject();
        for (int i = 0; pls.size() > i; ++i) {
            JSONObject user = new JSONObject();
            PlayerInfo pl = pls.get(i);
            if (pl.uuid == null) {
                main.put((Object)i, null);
                continue;
            }
            user.put((Object)"uuid", (Object)pl.uuid.toString());
            user.put((Object)"lvl", (Object)pl.lvl);
            user.put((Object)"breaks", (Object)pl.breaks);
            if (pl.allow_visit) {
                user.put((Object)"visit", (Object)pl.allow_visit);
            }
            JSONArray arr = new JSONArray();
            for (UUID us : pl.uuids) {
                arr.add((Object)us.toString());
            }
            user.put((Object)"invited", (Object)arr);
            main.put((Object)i, (Object)user);
        }
        main.put((Object)"id", (Object)pls.size());
        try {
            FileWriter file = new FileWriter(f);
            file.write(main.toJSONString());
            file.flush();
            file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ArrayList<PlayerInfo> Read(File f) {
        Server server = Bukkit.getServer();
        JSONObject main = null;
        JSONParser parser = new JSONParser();
        try {
            main = (JSONObject)parser.parse((Reader)new FileReader(f));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<PlayerInfo> infs = new ArrayList<PlayerInfo>();
        if (main == null) {
            return infs;
        }
        PlayerInfo nullable = new PlayerInfo(null);
        int id = ((Number)main.get((Object)"id")).intValue();
        for (int i = 0; i < id; ++i) {
            JSONObject user = (JSONObject)main.get((Object)("" + i));
            if (user == null) {
                infs.add(nullable);
                continue;
            }
            PlayerInfo pl = user.containsKey((Object)"uuid") ? new PlayerInfo(UUID.fromString((String)user.get((Object)"uuid"))) : new PlayerInfo(server.getOfflinePlayer((String)user.get((Object)"nick")).getUniqueId());
            pl.lvl = ((Number)user.get((Object)"lvl")).intValue();
            pl.breaks = ((Number)user.get((Object)"breaks")).intValue();
            pl.allow_visit = user.containsKey((Object)"visit");
            JSONArray arr = (JSONArray)(user.containsKey((Object)"invated") ? user.get((Object)"invated") : user.get((Object)"invited"));
            for (int q = 0; q < arr.size(); ++q) {
                String us = (String)arr.get(q);
                if (p.matcher(us).matches()) {
                    pl.uuids.add(UUID.fromString(us));
                    continue;
                }
                pl.uuids.add(server.getOfflinePlayer(us).getUniqueId());
            }
            infs.add(pl);
        }
        return infs;
    }
}

