/*
 * Decompiled with CFR 0.152.
 */
package com.tqk114514.craftmusic.client;

import com.tqk114514.craftmusic.CraftMusic;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;

public final class MusicLibrary {
    private static final String FOLDER_NAME = "CraftMusic";
    private static final String[] EXTENSIONS = new String[]{".ogg", ".mp3", ".flac", ".wav"};
    private static Path libraryDir;
    private static volatile List<Path> tracks;
    private static volatile List<TrackInfo> trackInfos;

    private MusicLibrary() {
    }

    public static void initAndScan() {
        try {
            MusicLibrary.ensureFolderExists();
            MusicLibrary.scan();
        }
        catch (Exception e) {
            CraftMusic.LOGGER.warn("MusicLibrary init error: {}", (Object)e.toString());
        }
    }

    public static void ensureFolderExists() throws IOException {
        Path dir = MusicLibrary.getLibraryDir();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
    }

    public static synchronized void scan() {
        Path dir = MusicLibrary.getLibraryDir();
        ArrayList<Path> resultPaths = new ArrayList<Path>();
        ArrayList<TrackInfo> resultInfos = new ArrayList<TrackInfo>();
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try (Stream<Path> s = Files.list(dir);){
                List audioFiles = s.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(MusicLibrary::isSupported).sorted((a, b) -> a.getFileName().toString().compareToIgnoreCase(b.getFileName().toString())).collect(Collectors.toList());
                for (Path audio : audioFiles) {
                    Path lrc = MusicLibrary.findLyricsFor(audio);
                    boolean hasLyrics = lrc != null && Files.exists(lrc, new LinkOption[0]);
                    resultPaths.add(audio);
                    resultInfos.add(new TrackInfo(audio, hasLyrics, hasLyrics ? lrc : null));
                }
            }
            catch (IOException e) {
                CraftMusic.LOGGER.warn("MusicLibrary scan error: {}", (Object)e.toString());
            }
        }
        tracks = Collections.unmodifiableList(resultPaths);
        trackInfos = Collections.unmodifiableList(resultInfos);
        CraftMusic.LOGGER.info("MusicLibrary scanned {} tracks in {}", (Object)tracks.size(), (Object)dir);
    }

    public static List<Path> getTracks() {
        return tracks;
    }

    public static List<TrackInfo> getTrackInfos() {
        return trackInfos;
    }

    public static Path getLibraryDir() {
        if (libraryDir == null) {
            Path gameDir = Minecraft.getInstance().gameDirectory.toPath();
            libraryDir = gameDir.resolve(FOLDER_NAME);
        }
        return libraryDir;
    }

    private static boolean isSupported(Path p) {
        String name = p.getFileName().toString().toLowerCase(Locale.ROOT);
        for (String ext : EXTENSIONS) {
            if (!name.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private static Path findLyricsFor(Path audioPath) {
        try {
            Path parent = audioPath.getParent();
            if (parent == null) {
                return null;
            }
            String fileName = audioPath.getFileName().toString();
            int dot = fileName.lastIndexOf(46);
            String base = dot > 0 ? fileName.substring(0, dot) : fileName;
            Path candidate = parent.resolve(base + ".lrc");
            if (Files.exists(candidate, new LinkOption[0])) {
                return candidate;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        tracks = Collections.emptyList();
        trackInfos = Collections.emptyList();
    }

    public static final class TrackInfo {
        private final Path audioPath;
        private final boolean hasLyrics;
        private final Path lyricsPath;

        public TrackInfo(Path audioPath, boolean hasLyrics, Path lyricsPath) {
            this.audioPath = audioPath;
            this.hasLyrics = hasLyrics;
            this.lyricsPath = lyricsPath;
        }

        public Path getAudioPath() {
            return this.audioPath;
        }

        public boolean hasLyrics() {
            return this.hasLyrics;
        }

        public Path getLyricsPath() {
            return this.lyricsPath;
        }
    }
}

