/*
 * Decompiled with CFR 0.152.
 */
package com.tqk114514.craftmusic.client.settings.feedback;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;

public class FeedbackInfoScreen
extends Screen {
    private final Screen parent;
    private static final String URL = "https://github.com/tqk114514/CraftMusic/issues/";
    private int contentLeft;
    private int contentWidth;
    private final String tailKey;

    public FeedbackInfoScreen(Screen parent, String tailKey) {
        super((Component)Component.translatable((String)"craftmusic.ui.feedback.info_title"));
        this.parent = parent;
        this.tailKey = tailKey;
    }

    protected void init() {
        this.contentWidth = Math.min(680, Math.max(260, this.width - 60));
        this.contentLeft = (this.width - this.contentWidth) / 2;
        int btnY = this.height - 30;
        int gap = 10;
        int btnW = 95;
        int total = btnW * 2 + gap;
        int left = this.contentLeft + (this.contentWidth - total) / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.back"), b -> Minecraft.getInstance().setScreen(this.parent)).bounds(left, btnY, btnW, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.feedback.proceed"), b -> Minecraft.getInstance().setScreen((Screen)new ConfirmLinkScreen(open -> {
            if (open) {
                try {
                    Util.getPlatform().openUri(URL);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Minecraft.getInstance().setScreen(this.parent);
        }, URL, true))).bounds(left + btnW + gap, btnY, btnW, 20).build());
    }

    public void render(@Nonnull GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(gfx, mouseX, mouseY, partialTick);
        super.render(gfx, mouseX, mouseY, partialTick);
        String breadcrumb = Component.translatable((String)"craftmusic.ui.settings").getString() + " > " + Component.translatable((String)"craftmusic.ui.feedback.menu").getString() + " > " + Component.translatable((String)this.tailKey).getString();
        int titleX = (this.width - this.font.width(breadcrumb)) / 2;
        gfx.drawString(this.font, breadcrumb, titleX, 8, 0xFFFFFF, false);
        int panelPad = 10;
        int textTop = this.height / 6 + 10;
        MutableComponent body = Component.translatable((String)"craftmusic.ui.feedback_and_suggest.info");
        List lines = this.font.split((FormattedText)body, this.contentWidth - panelPad * 2);
        int n = lines.size();
        Objects.requireNonNull(this.font);
        int bodyHeight = n * (9 + 2);
        int panelTop = textTop - panelPad;
        int panelBottom = textTop + bodyHeight + panelPad;
        int panelLeft = this.contentLeft - panelPad;
        int panelRight = this.contentLeft + this.contentWidth + panelPad;
        gfx.fill(panelLeft, panelTop, panelRight, panelBottom, -1879048192);
        int y = textTop;
        for (FormattedCharSequence seq : lines) {
            int lineW = this.font.width(seq);
            int x = this.contentLeft + (this.contentWidth - lineW) / 2;
            gfx.drawString(this.font, seq, x, y, 0xDDDDDD, false);
            Objects.requireNonNull(this.font);
            y += 9 + 2;
        }
    }
}

