/*
 * Decompiled with CFR 0.152.
 */
package com.tqk114514.craftmusic.client.settings.lyrics;

import com.tqk114514.craftmusic.client.ClientConfig;
import com.tqk114514.craftmusic.client.settings.lyrics.FloatingLyricsSettingsScreen;
import com.tqk114514.craftmusic.client.settings.lyrics.OpacitySlider;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class FloatingLyricsColorScreen
extends Screen {
    private final Screen parent;
    private OpacitySlider opacitySlider;
    private FloatingLyricsSettingsScreen.ChannelSlider redSlider;
    private FloatingLyricsSettingsScreen.ChannelSlider greenSlider;
    private FloatingLyricsSettingsScreen.ChannelSlider blueSlider;

    public FloatingLyricsColorScreen(Screen parent) {
        super((Component)Component.translatable((String)"craftmusic.ui.floating_lyrics.color.settings"));
        this.parent = parent;
    }

    protected void init() {
        int y = this.height / 6 + 20;
        int color = ClientConfig.getFloatingLyricsColor();
        int a = color >>> 24 & 0xFF;
        int r = color >>> 16 & 0xFF;
        int g = color >>> 8 & 0xFF;
        int b = color & 0xFF;
        int pct = Math.round((float)a * 100.0f / 255.0f);
        this.opacitySlider = new OpacitySlider(this.width / 2 - 100, y, 200, 20, pct);
        this.addRenderableWidget((GuiEventListener)this.opacitySlider);
        this.redSlider = new FloatingLyricsSettingsScreen.ChannelSlider(this.width / 2 - 100, y += 24, 200, 20, "craftmusic.ui.color.red", r);
        this.addRenderableWidget((GuiEventListener)this.redSlider);
        this.greenSlider = new FloatingLyricsSettingsScreen.ChannelSlider(this.width / 2 - 100, y += 24, 200, 20, "craftmusic.ui.color.green", g);
        this.addRenderableWidget((GuiEventListener)this.greenSlider);
        this.blueSlider = new FloatingLyricsSettingsScreen.ChannelSlider(this.width / 2 - 100, y += 24, 200, 20, "craftmusic.ui.color.blue", b);
        this.addRenderableWidget((GuiEventListener)this.blueSlider);
        int rowX = this.width / 2 - 100;
        int btnW = 36;
        int gap = 4;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.color.preset.white"), btn -> this.applyPreset(-1)).bounds(rowX + 0 * (btnW + gap), y += 24, btnW, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.color.preset.yellow"), btn -> this.applyPreset(this.getAlphaFromPercent() << 24 | 0xFFFF00)).bounds(rowX + 1 * (btnW + gap), y, btnW, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.color.preset.cyan"), btn -> this.applyPreset(this.getAlphaFromPercent() << 24 | 0xFFFF)).bounds(rowX + 2 * (btnW + gap), y, btnW, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.color.preset.lime"), btn -> this.applyPreset(this.getAlphaFromPercent() << 24 | 0xFF00)).bounds(rowX + 3 * (btnW + gap), y, btnW, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.color.preset.pink"), btn -> this.applyPreset(this.getAlphaFromPercent() << 24 | 0xFF66CC)).bounds(rowX + 4 * (btnW + gap), y, btnW, 20).build());
        int closeY = this.height - 30;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.close"), btn -> Minecraft.getInstance().setScreen(this.parent)).bounds(this.width / 2 - 100, closeY, 200, 20).build());
    }

    private void applyPreset(int argb) {
        int a = this.getAlphaFromPercent();
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        if (this.opacitySlider != null) {
            this.opacitySlider.setPercent(Math.round((float)a * 100.0f / 255.0f));
        }
        if (this.redSlider != null) {
            this.redSlider.setIntValue(r);
        }
        if (this.greenSlider != null) {
            this.greenSlider.setIntValue(g);
        }
        if (this.blueSlider != null) {
            this.blueSlider.setIntValue(b);
        }
        this.saveColorFromSliders();
    }

    void saveColorFromSliders() {
        int a = this.getAlphaFromPercent();
        int r = this.redSlider.getIntValue();
        int g = this.greenSlider.getIntValue();
        int b = this.blueSlider.getIntValue();
        int argb = a << 24 | r << 16 | g << 8 | b;
        ClientConfig.setFloatingLyricsColor(argb);
    }

    private int getAlphaFromPercent() {
        int pct;
        int n = pct = this.opacitySlider != null ? this.opacitySlider.getPercent() : 100;
        if (pct <= 0) {
            return 0;
        }
        if (pct >= 100) {
            return 255;
        }
        float gamma = 0.6f;
        float t = (float)Math.pow((float)pct / 100.0f, gamma);
        int a = Math.round(t * 255.0f);
        if (a < 1) {
            a = 1;
        }
        return a;
    }

    public void render(@Nonnull GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(gfx, mouseX, mouseY, partialTick);
        super.render(gfx, mouseX, mouseY, partialTick);
        String breadcrumb = Component.translatable((String)"craftmusic.ui.settings").getString() + " > " + Component.translatable((String)"craftmusic.ui.lyrics.settings").getString() + " > " + Component.translatable((String)"craftmusic.ui.floating_lyrics.settings").getString() + " > " + Component.translatable((String)"craftmusic.ui.floating_lyrics.color.settings").getString();
        int xbc = (this.width - this.font.width(breadcrumb)) / 2;
        gfx.drawString(this.font, breadcrumb, xbc, 8, 0xFFFFFF, false);
        String sample = Component.translatable((String)"craftmusic.ui.floating_lyrics.sample").getString();
        int color = ClientConfig.getFloatingLyricsColor();
        int y = this.height / 6 + 20 + 120 + 6;
        int x = this.width / 2 - this.font.width(sample) / 2;
        if (ClientConfig.isFloatingLyricsOutline()) {
            int shadow = -16777216;
            gfx.drawString(this.font, sample, x + 1, y, shadow, false);
            gfx.drawString(this.font, sample, x - 1, y, shadow, false);
            gfx.drawString(this.font, sample, x, y + 1, shadow, false);
            gfx.drawString(this.font, sample, x, y - 1, shadow, false);
        }
        gfx.drawString(this.font, sample, x, y, color, false);
    }
}

