/*
 * Decompiled with CFR 0.152.
 */
package com.tqk114514.craftmusic.client.settings.lyrics;

import com.tqk114514.craftmusic.client.ClientConfig;
import com.tqk114514.craftmusic.client.settings.lyrics.FloatingLyricsColorScreen;
import com.tqk114514.craftmusic.client.settings.lyrics.FloatingLyricsPositionScreen;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class FloatingLyricsSettingsScreen
extends Screen {
    private final Screen parent;
    private AbstractSliderButton fontScaleSlider;

    public FloatingLyricsSettingsScreen(Screen parent) {
        super((Component)Component.translatable((String)"craftmusic.ui.floating_lyrics.settings"));
        this.parent = parent;
    }

    protected void init() {
        double max;
        double min;
        int y = this.height / 6 + 20;
        float cur = ClientConfig.getFloatingLyricsFontScale();
        double norm = ((double)cur - (min = 0.5)) / ((max = 3.0) - min);
        if (norm < 0.0) {
            norm = 0.0;
        }
        if (norm > 1.0) {
            norm = 1.0;
        }
        this.fontScaleSlider = new AbstractSliderButton(this, this.width / 2 - 100, y, 200, 20, (Component)Component.literal((String)""), norm){

            private void updateLabel() {
                double v = min + this.value * (max - min);
                String txt = String.format(Locale.ROOT, "%s: %.2f", Component.translatable((String)"craftmusic.ui.floating_lyrics.font_scale").getString(), v);
                this.setMessage((Component)Component.literal((String)txt));
            }

            protected void updateMessage() {
                this.updateLabel();
            }

            protected void applyValue() {
                double v = min + this.value * (max - min);
                ClientConfig.setFloatingLyricsFontScale((float)v);
                this.updateLabel();
            }
        };
        this.fontScaleSlider.setMessage((Component)Component.literal((String)String.format(Locale.ROOT, "%s: %.2f", Component.translatable((String)"craftmusic.ui.floating_lyrics.font_scale").getString(), Float.valueOf(cur))));
        this.addRenderableWidget((GuiEventListener)this.fontScaleSlider);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.buildOutlineLabel(), btn -> {
            ClientConfig.setFloatingLyricsOutline(!ClientConfig.isFloatingLyricsOutline());
            btn.setMessage(this.buildOutlineLabel());
        }).bounds(this.width / 2 - 100, y += 24, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.floating_lyrics.color.settings"), btn -> Minecraft.getInstance().setScreen((Screen)new FloatingLyricsColorScreen(this))).bounds(this.width / 2 - 100, y += 24, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.floating_lyrics.position.settings"), btn -> Minecraft.getInstance().setScreen((Screen)new FloatingLyricsPositionScreen(this))).bounds(this.width / 2 - 100, y += 24, 200, 20).build());
        int closeY = this.height - 30;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.close"), btn -> Minecraft.getInstance().setScreen(this.parent)).bounds(this.width / 2 - 100, closeY, 200, 20).build());
    }

    private Component buildOutlineLabel() {
        return Component.translatable((String)(ClientConfig.isFloatingLyricsOutline() ? "craftmusic.ui.floating_lyrics.outline.on" : "craftmusic.ui.floating_lyrics.outline.off"));
    }

    public void render(@Nonnull GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(gfx, mouseX, mouseY, partialTick);
        super.render(gfx, mouseX, mouseY, partialTick);
        String breadcrumb = Component.translatable((String)"craftmusic.ui.settings").getString() + " > " + Component.translatable((String)"craftmusic.ui.lyrics.settings").getString() + " > " + Component.translatable((String)"craftmusic.ui.floating_lyrics.settings").getString();
        int x = (this.width - this.font.width(breadcrumb)) / 2;
        gfx.drawString(this.font, breadcrumb, x, 8, 0xFFFFFF, false);
    }

    static class ChannelSlider
    extends AbstractSliderButton {
        private final String labelKey;

        ChannelSlider(int x, int y, int w, int h, String labelKey, int initial) {
            super(x, y, w, h, (Component)Component.literal((String)""), Math.max(0.0, Math.min(1.0, (double)initial / 255.0)));
            this.labelKey = labelKey;
            this.updateMessage();
        }

        int getIntValue() {
            return (int)Math.round(this.value * 255.0);
        }

        void setIntValue(int v) {
            this.value = Math.max(0.0, Math.min(1.0, (double)v / 255.0));
            this.updateMessage();
        }

        protected void updateMessage() {
            int v = this.getIntValue();
            this.setMessage((Component)Component.literal((String)(Component.translatable((String)this.labelKey).getString() + ": " + v)));
        }

        protected void applyValue() {
        }

        public void onRelease(double mouseX, double mouseY) {
            super.onRelease(mouseX, mouseY);
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof FloatingLyricsColorScreen) {
                FloatingLyricsColorScreen s = (FloatingLyricsColorScreen)screen;
                s.saveColorFromSliders();
            }
        }

        public void onClick(double mouseX, double mouseY) {
            super.onClick(mouseX, mouseY);
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof FloatingLyricsColorScreen) {
                FloatingLyricsColorScreen s = (FloatingLyricsColorScreen)screen;
                s.saveColorFromSliders();
            }
        }

        public void onDrag(double mouseX, double mouseY, double dx, double dy) {
            super.onDrag(mouseX, mouseY, dx, dy);
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof FloatingLyricsColorScreen) {
                FloatingLyricsColorScreen s = (FloatingLyricsColorScreen)screen;
                s.saveColorFromSliders();
            }
        }
    }
}

