/*
 * Decompiled with CFR 0.152.
 */
package com.tqk114514.craftmusic;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tqk114514.craftmusic.CraftMusic;
import com.tqk114514.craftmusic.audio.MiniaudioPlayer;
import com.tqk114514.craftmusic.client.ClientConfig;
import com.tqk114514.craftmusic.client.LrcParser;
import com.tqk114514.craftmusic.client.Lyrics;
import com.tqk114514.craftmusic.client.MusicLibrary;
import com.tqk114514.craftmusic.client.PlaybackController;
import com.tqk114514.craftmusic.client.QuickPlayScreen;
import com.tqk114514.craftmusic.client.settings.lyrics.FloatingLyricsPositionScreen;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;

@Mod(value="craftmusic", dist={Dist.CLIENT})
@EventBusSubscriber(modid="craftmusic", value={Dist.CLIENT})
public class CraftMusicClient {
    private static MiniaudioPlayer PLAYER;
    private static KeyMapping OPEN_UI_KEY;
    private static volatile Lyrics overlayLyrics;
    private static volatile String overlayLyricsForPath;
    private static volatile float lastAppliedVolume;

    public CraftMusicClient(ModContainer container) {
        container.getEventBus().addListener(this::onClientSetup);
        container.getEventBus().addListener(this::registerKeyMappings);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        CraftMusic.LOGGER.info("CraftMusic client setup initialized");
        ClientConfig.initAndLoad();
        float cfgVol = ClientConfig.getVolume();
        CraftMusic.LOGGER.info("CraftMusic load volume from config: {}", (Object)Float.valueOf(cfgVol));
        PLAYER = new MiniaudioPlayer(48000, 2);
        if (!PLAYER.isOutputReady()) {
            CraftMusic.LOGGER.warn("Native audio library not loaded. Playback will be disabled until JNI is provided.");
        } else {
            try {
                PLAYER.setVolume(cfgVol);
                CraftMusic.LOGGER.info("CraftMusic applied initial volume: {}", (Object)Float.valueOf(cfgVol));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        lastAppliedVolume = cfgVol;
        MusicLibrary.initAndScan();
    }

    @SubscribeEvent
    static void registerClientCommands(RegisterClientCommandsEvent event) {
        LiteralArgumentBuilder play = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"craftmusic").then(Commands.literal((String)"play").then(Commands.argument((String)"path", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String raw = StringArgumentType.getString((CommandContext)ctx, (String)"path").trim();
            String path = CraftMusicClient.sanitizePath(raw);
            if (PLAYER == null || !PLAYER.isOutputReady()) {
                CraftMusic.LOGGER.warn("Audio output not ready.");
                Minecraft mc0 = Minecraft.getInstance();
                if (mc0.player != null) {
                    mc0.player.displayClientMessage((Component)Component.translatable((String)"craftmusic.error.output_not_ready"), false);
                }
                return 0;
            }
            CraftMusic.LOGGER.info("Playing via cmd: {}", (Object)path);
            int rc = PLAYER.play(path);
            if (rc != 0) {
                CraftMusic.LOGGER.warn("Play failed with code {}", (Object)rc);
                Minecraft mc = Minecraft.getInstance();
                LocalPlayer player = mc.player;
                if (player != null) {
                    MutableComponent err = Component.translatable((String)CraftMusicClient.errorKey(rc));
                    player.displayClientMessage((Component)Component.translatable((String)"craftmusic.play.failed", (Object[])new Object[]{err, Integer.toString(rc)}), false);
                }
                return 0;
            }
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"craftmusic.play.start", (Object[])new Object[]{path}), false);
            }
            return 1;
        })))).then(Commands.literal((String)"stop").executes(ctx -> {
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (PLAYER != null && PLAYER.isOutputReady()) {
                PLAYER.stop();
                if (player != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"craftmusic.play.stop"), false);
                }
            } else if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"craftmusic.error.output_not_ready"), false);
            }
            return 1;
        }))).then(Commands.literal((String)"ui").executes(ctx -> {
            if (PLAYER != null) {
                Minecraft.getInstance().setScreen((Screen)new QuickPlayScreen(PLAYER));
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"tone").executes(ctx -> {
            if (PLAYER == null || !PLAYER.isOutputReady()) {
                CraftMusic.LOGGER.warn("Audio output not ready.");
                Minecraft mc0 = Minecraft.getInstance();
                LocalPlayer player0 = mc0.player;
                if (player0 != null) {
                    player0.displayClientMessage((Component)Component.translatable((String)"craftmusic.error.output_not_ready"), false);
                }
                return 0;
            }
            PLAYER.playTone(440, 1000);
            return 1;
        })).then(Commands.argument((String)"hz", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"ms", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            int ms;
            int hz;
            if (PLAYER == null || !PLAYER.isOutputReady()) {
                return 0;
            }
            try {
                hz = Integer.parseInt(StringArgumentType.getString((CommandContext)ctx, (String)"hz"));
                ms = Integer.parseInt(StringArgumentType.getString((CommandContext)ctx, (String)"ms"));
            }
            catch (NumberFormatException ex) {
                CraftMusic.LOGGER.warn("Invalid tone args");
                return 0;
            }
            PLAYER.playTone(hz, ms);
            return 1;
        }))));
        event.getDispatcher().register(play);
    }

    public static MiniaudioPlayer getPlayer() {
        return PLAYER;
    }

    private static String sanitizePath(String input) {
        if (input == null) {
            return null;
        }
        String s = input.trim();
        if ((s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) && s.length() >= 2) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static String errorKey(int code) {
        return switch (code) {
            case 0 -> "craftmusic.error.ok";
            case -2 -> "craftmusic.error.invalid_args";
            case -7 -> "craftmusic.error.not_found";
            case -9 -> "craftmusic.error.format_not_supported";
            case -10 -> "craftmusic.error.invalid_file";
            case -1 -> "craftmusic.error.unknown";
            default -> "craftmusic.error.unknown";
        };
    }

    @SubscribeEvent
    static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen) {
            TitleScreen screen2 = (TitleScreen)screen;
            int width = screen2.width;
            int x = width - 110;
            int y = 5;
            Button btn = Button.builder((Component)Component.translatable((String)"craftmusic.button.open"), b -> {
                if (PLAYER != null) {
                    Minecraft.getInstance().setScreen((Screen)new QuickPlayScreen(PLAYER));
                } else {
                    Minecraft mc = Minecraft.getInstance();
                    if (mc.player != null) {
                        mc.player.displayClientMessage((Component)Component.translatable((String)"craftmusic.error.output_not_ready"), false);
                    }
                }
            }).bounds(x, y, 100, 20).build();
            event.addListener((GuiEventListener)btn);
        }
    }

    private void registerKeyMappings(RegisterKeyMappingsEvent event) {
        OPEN_UI_KEY = new KeyMapping("key.craftmusic.open_ui", InputConstants.Type.KEYSYM, 77, "key.categories.craftmusic");
        event.register(OPEN_UI_KEY);
    }

    @SubscribeEvent
    static void onClientTick(ClientTickEvent.Post event) {
        if (OPEN_UI_KEY != null && OPEN_UI_KEY.consumeClick()) {
            Minecraft.getInstance().setScreen((Screen)new QuickPlayScreen(PLAYER));
        }
        PlaybackController.update(PLAYER);
        try {
            if (PLAYER != null && PLAYER.isOutputReady()) {
                float cfg = ClientConfig.getVolume();
                float cur = PLAYER.getVolume();
                if (Math.abs(cur - cfg) > 0.02f || Math.abs(lastAppliedVolume - cfg) > 0.001f) {
                    PLAYER.setVolume(cfg);
                    lastAppliedVolume = cfg;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    static void onRenderGui(RenderGuiEvent.Post event) {
        boolean inWorld = Minecraft.getInstance().level != null;
        String scope = ClientConfig.getFloatingLyricsRender();
        if (Minecraft.getInstance().screen == null && ("GLOBAL".equals(scope) || "WORLD".equals(scope) && inWorld)) {
            CraftMusicClient.renderFloatingLyrics(event.getGuiGraphics());
        }
    }

    @SubscribeEvent
    static void onScreenRender(ScreenEvent.Render.Post event) {
        String scope = ClientConfig.getFloatingLyricsRender();
        if ("GLOBAL".equals(scope)) {
            if (event.getScreen() instanceof FloatingLyricsPositionScreen) {
                return;
            }
            CraftMusicClient.renderFloatingLyrics(event.getGuiGraphics());
        }
    }

    private static void renderFloatingLyrics(GuiGraphics gfx) {
        boolean nearRight;
        List<Object> lines;
        if (!ClientConfig.isFloatingLyrics()) {
            return;
        }
        if (PLAYER == null || !PLAYER.isOutputReady()) {
            return;
        }
        String path = PLAYER.getLastPlayedAbsolutePath();
        if (path == null || path.isBlank()) {
            return;
        }
        if (overlayLyricsForPath == null || !overlayLyricsForPath.equalsIgnoreCase(path)) {
            Lyrics lyr;
            block15: {
                lyr = Lyrics.empty();
                try {
                    List<MusicLibrary.TrackInfo> infos = MusicLibrary.getTrackInfos();
                    if (infos == null) break block15;
                    for (MusicLibrary.TrackInfo info : infos) {
                        if (info == null || info.getAudioPath() == null || !info.getAudioPath().toAbsolutePath().toString().equalsIgnoreCase(path)) continue;
                        Path lrc = info.getLyricsPath();
                        if (lrc != null) {
                            lyr = LrcParser.parse(lrc);
                        }
                        break;
                    }
                }
                catch (Throwable infos) {
                    // empty catch block
                }
            }
            overlayLyrics = lyr;
            overlayLyricsForPath = path;
        }
        List<Object> list = lines = overlayLyrics != null ? overlayLyrics.getLines() : List.of();
        if (lines.isEmpty()) {
            return;
        }
        int curMs = 0;
        try {
            curMs = PLAYER.getPositionMs();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int idx = CraftMusicClient.findCurrentLineIndex(lines, curMs);
        if (idx < 0 || idx >= lines.size()) {
            return;
        }
        String text = ((Lyrics.Line)lines.get((int)idx)).text;
        if (text == null || text.isBlank()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        float scale = ClientConfig.getFloatingLyricsFontScale();
        int color = ClientConfig.getFloatingLyricsColor();
        boolean outline = ClientConfig.isFloatingLyricsOutline();
        int screenW = mc.getWindow().getGuiScaledWidth();
        int screenH = mc.getWindow().getGuiScaledHeight();
        int anchorX = Math.round(ClientConfig.getFloatingLyricsPosX() * (float)screenW);
        int anchorY = Math.round(ClientConfig.getFloatingLyricsPosY() * (float)screenH);
        Font font = Minecraft.getInstance().font;
        int textW = Math.round((float)font.width(text) * scale);
        Objects.requireNonNull(font);
        int textH = Math.round(9.0f * scale);
        int snap = 12;
        boolean nearLeft = Math.abs(anchorX - 0) < snap;
        boolean bl = nearRight = Math.abs(anchorX - screenW) < snap;
        int drawX = anchorX - (nearLeft ? 0 : (nearRight ? textW : textW / 2));
        int drawY = Math.max(0, Math.min(anchorY, screenH - textH));
        PoseStack pose = gfx.pose();
        pose.pushPose();
        pose.translate((float)drawX, (float)drawY, 0.0f);
        pose.scale(scale, scale, 1.0f);
        int a = color >>> 24 & 0xFF;
        if (a <= 0) {
            pose.popPose();
            return;
        }
        if (outline) {
            int outlineColor = a << 24;
            gfx.drawString(font, text, 1, 0, outlineColor, false);
            gfx.drawString(font, text, -1, 0, outlineColor, false);
            gfx.drawString(font, text, 0, 1, outlineColor, false);
            gfx.drawString(font, text, 0, -1, outlineColor, false);
        }
        gfx.drawString(font, text, 0, 0, color, false);
        pose.popPose();
    }

    private static int findCurrentLineIndex(List<Lyrics.Line> lines, int curMs) {
        if (lines == null || lines.isEmpty()) {
            return -1;
        }
        int lo = 0;
        int hi = lines.size() - 1;
        int ans = -1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int t = lines.get((int)mid).timeMs;
            if (t <= curMs) {
                ans = mid;
                lo = mid + 1;
                continue;
            }
            hi = mid - 1;
        }
        return ans;
    }

    public static String getCurrentFloatingLyricText() {
        try {
            if (PLAYER == null || !PLAYER.isOutputReady()) {
                return null;
            }
            String path = PLAYER.getLastPlayedAbsolutePath();
            if (path == null || path.isBlank()) {
                return null;
            }
            if (overlayLyricsForPath == null || !overlayLyricsForPath.equalsIgnoreCase(path)) {
                Lyrics lyr;
                block12: {
                    lyr = Lyrics.empty();
                    try {
                        List<MusicLibrary.TrackInfo> infos = MusicLibrary.getTrackInfos();
                        if (infos == null) break block12;
                        for (MusicLibrary.TrackInfo info : infos) {
                            if (info == null || info.getAudioPath() == null || !info.getAudioPath().toAbsolutePath().toString().equalsIgnoreCase(path)) continue;
                            Path lrc = info.getLyricsPath();
                            if (lrc != null) {
                                lyr = LrcParser.parse(lrc);
                            }
                            break;
                        }
                    }
                    catch (Throwable infos) {
                        // empty catch block
                    }
                }
                overlayLyrics = lyr;
                overlayLyricsForPath = path;
            }
            if (overlayLyrics == null) {
                return null;
            }
            List<Lyrics.Line> lines = overlayLyrics.getLines();
            if (lines == null || lines.isEmpty()) {
                return null;
            }
            int curMs = PLAYER != null ? PLAYER.getPositionMs() : 0;
            int idx = CraftMusicClient.findCurrentLineIndex(lines, curMs);
            if (idx < 0 || idx >= lines.size()) {
                return null;
            }
            String text = lines.get((int)idx).text;
            return text == null || text.isBlank() ? null : text;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    static {
        overlayLyrics = Lyrics.empty();
        overlayLyricsForPath = null;
        lastAppliedVolume = -1.0f;
    }
}

