/*
 * Decompiled with CFR 0.152.
 */
package com.tqk114514.craftmusic.audio;

import com.tqk114514.craftmusic.CraftMusic;
import com.tqk114514.craftmusic.audio.NativeAudio;
import com.tqk114514.craftmusic.client.ClientConfig;

public final class MiniaudioPlayer
implements AutoCloseable {
    private volatile boolean outputReady;
    private volatile boolean initialized;
    private volatile boolean playing;
    private volatile String lastPlayedAbsolutePath;
    private volatile boolean paused;
    private volatile float volume = 1.0f;

    public MiniaudioPlayer(int sampleRate, int channels) {
        try {
            NativeAudio.ensureLoaded();
            this.outputReady = MiniaudioPlayer.nInit(sampleRate, channels);
            this.initialized = true;
            this.playing = false;
            this.lastPlayedAbsolutePath = null;
            this.paused = false;
        }
        catch (Throwable t) {
            CraftMusic.LOGGER.warn("Failed to load native audio library: {}", (Object)t.toString());
            this.outputReady = false;
            this.initialized = false;
            this.playing = false;
            this.lastPlayedAbsolutePath = null;
            this.paused = false;
        }
    }

    public boolean isOutputReady() {
        return this.outputReady;
    }

    public int play(String absolutePath) {
        if (!this.outputReady) {
            return -1;
        }
        if (absolutePath == null || absolutePath.isBlank()) {
            return -2;
        }
        int rc = MiniaudioPlayer.nPlayFile(absolutePath);
        boolean bl = this.playing = rc == 0;
        if (rc == 0) {
            this.lastPlayedAbsolutePath = absolutePath;
            this.paused = false;
            try {
                float cfg = ClientConfig.getVolume();
                this.volume = Math.max(0.0f, Math.min(1.0f, cfg));
                MiniaudioPlayer.nSetVolume(this.volume);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return rc;
    }

    public void stop() {
        if (!this.outputReady) {
            return;
        }
        MiniaudioPlayer.nStop();
        this.playing = false;
        this.paused = false;
    }

    public void playTone(int hz, int durationMs) {
        if (!this.outputReady) {
            return;
        }
        MiniaudioPlayer.nPlayTone(hz, durationMs);
        this.playing = true;
        this.lastPlayedAbsolutePath = null;
        this.paused = false;
        try {
            float cfg = ClientConfig.getVolume();
            this.volume = Math.max(0.0f, Math.min(1.0f, cfg));
            MiniaudioPlayer.nSetVolume(this.volume);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        if (!this.initialized) {
            return;
        }
        try {
            MiniaudioPlayer.nDispose();
        }
        finally {
            this.initialized = false;
            this.outputReady = false;
            this.playing = false;
            this.lastPlayedAbsolutePath = null;
            this.paused = false;
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public String getLastPlayedAbsolutePath() {
        return this.lastPlayedAbsolutePath;
    }

    public int getLengthMs() {
        if (!this.outputReady) {
            return 0;
        }
        return MiniaudioPlayer.nGetLengthMs();
    }

    public int getPositionMs() {
        if (!this.outputReady) {
            return 0;
        }
        return MiniaudioPlayer.nGetPositionMs();
    }

    public void seekToMs(int ms) {
        if (!this.outputReady) {
            return;
        }
        MiniaudioPlayer.nSeekMs(ms);
    }

    public void pause() {
        if (!this.outputReady) {
            return;
        }
        MiniaudioPlayer.nPause();
        this.playing = false;
        this.paused = true;
    }

    public void resume() {
        if (!this.outputReady) {
            return;
        }
        MiniaudioPlayer.nResume();
        this.playing = true;
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setVolume(float v) {
        this.volume = Math.max(0.0f, Math.min(1.0f, v));
        if (!this.outputReady) {
            return;
        }
        MiniaudioPlayer.nSetVolume(this.volume);
    }

    public float getVolume() {
        if (!this.outputReady) {
            return this.volume;
        }
        try {
            this.volume = MiniaudioPlayer.nGetVolume();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.volume;
    }

    public int getSpectrum(float[] out, int bands) {
        if (!this.outputReady || out == null || bands <= 0) {
            return 0;
        }
        return MiniaudioPlayer.nGetSpectrum(out, bands);
    }

    private static native boolean nInit(int var0, int var1);

    private static native int nPlayFile(String var0);

    private static native void nStop();

    private static native void nDispose();

    private static native void nPlayTone(int var0, int var1);

    private static native int nGetLengthMs();

    private static native int nGetPositionMs();

    private static native void nSeekMs(int var0);

    private static native void nPause();

    private static native void nResume();

    private static native void nSetVolume(float var0);

    private static native float nGetVolume();

    private static native int nGetSpectrum(float[] var0, int var1);
}

