/*
 * Decompiled with CFR 0.152.
 */
package com.tqk114514.craftmusic.client;

import com.tqk114514.craftmusic.client.Lyrics;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LrcParser {
    private static final Pattern TIME_TOKEN = Pattern.compile("\\[(\\d{1,2}):(\\d{1,2})(?:\\.(\\d{1,3}))?]\\s*(.*)");
    private static final Pattern TAG_TOKEN = Pattern.compile("\\[(ar|ti|al|by|offset):([^]]*)]", 2);

    private LrcParser() {
    }

    public static Lyrics parse(Path lrcPath) {
        if (lrcPath == null || !Files.isRegularFile(lrcPath, new LinkOption[0])) {
            return Lyrics.empty();
        }
        for (Charset cs : new Charset[]{StandardCharsets.UTF_8, Charset.forName("GBK")}) {
            try {
                Lyrics l = LrcParser.parseWithCharset(lrcPath, cs);
                if (l.isEmpty() && !cs.equals(StandardCharsets.UTF_8)) continue;
                return l;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Lyrics.empty();
    }

    private static Lyrics parseWithCharset(Path lrcPath, Charset cs) throws IOException {
        ArrayList<Lyrics.Line> lines = new ArrayList<Lyrics.Line>();
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        int globalOffset = 0;
        try (BufferedReader br = Files.newBufferedReader(lrcPath, cs);){
            String raw;
            while ((raw = br.readLine()) != null) {
                Matcher m;
                String line = raw.strip();
                if (line.isEmpty()) continue;
                Matcher tm = TAG_TOKEN.matcher(line);
                boolean matchedAnyTag = false;
                while (tm.find()) {
                    matchedAnyTag = true;
                    String key = tm.group(1).toLowerCase(Locale.ROOT);
                    String value = tm.group(2).trim();
                    if ("offset".equals(key)) {
                        try {
                            globalOffset = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    tags.put(key, value);
                }
                if (matchedAnyTag && !line.startsWith("[") || !(m = TIME_TOKEN.matcher(line)).matches()) continue;
                int mm = LrcParser.parseInt(m.group(1));
                int ss = LrcParser.parseInt(m.group(2));
                int ms = LrcParser.parseMs(m.group(3));
                int timeMs = mm * 60000 + ss * 1000 + ms;
                String text = m.group(4).strip();
                lines.add(new Lyrics.Line(timeMs, text));
            }
        }
        if (globalOffset != 0) {
            for (int i = 0; i < lines.size(); ++i) {
                Lyrics.Line ln = (Lyrics.Line)lines.get(i);
                lines.set(i, new Lyrics.Line(Math.max(0, ln.timeMs + globalOffset), ln.text));
            }
        }
        lines.sort(Comparator.comparingInt(a -> a.timeMs));
        ArrayList<Lyrics.Line> dedup = new ArrayList<Lyrics.Line>();
        int lastTime = -1;
        String lastText = null;
        for (Lyrics.Line ln : lines) {
            if (ln.timeMs == lastTime && Objects.equals(ln.text, lastText)) continue;
            dedup.add(ln);
            lastTime = ln.timeMs;
            lastText = ln.text;
        }
        return new Lyrics(dedup, tags, globalOffset);
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int parseMs(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        try {
            if (s.length() == 1) {
                return Integer.parseInt(s) * 100;
            }
            if (s.length() == 2) {
                return Integer.parseInt(s) * 10;
            }
            return Integer.parseInt(s.substring(0, Math.min(3, s.length())));
        }
        catch (Exception e) {
            return 0;
        }
    }
}

