/*
 * Decompiled with CFR 0.152.
 */
package com.tqk114514.craftmusic.client.settings;

import com.tqk114514.craftmusic.client.ClientConfig;
import com.tqk114514.craftmusic.client.settings.lyrics.FloatingLyricsSettingsScreen;
import com.tqk114514.craftmusic.util.NullSafetyUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class LyricsSettingsScreen
extends Screen {
    private final Screen parent;

    public LyricsSettingsScreen(Screen parent) {
        super(NullSafetyUtils.safeTranslatable("craftmusic.ui.lyrics.settings"));
        this.parent = parent;
    }

    protected void init() {
        int y = this.height / 6 + 20;
        this.addRenderableWidget((GuiEventListener)NullSafetyUtils.safeButton(Button.builder((Component)this.buildLyricEffectsLabel(), btn -> {
            boolean v = !ClientConfig.isLyricEffects();
            ClientConfig.setLyricEffects(v);
            btn.setMessage(this.buildLyricEffectsLabel());
        }).bounds(this.width / 2 - 100, y, 200, 20)));
        this.addRenderableWidget((GuiEventListener)NullSafetyUtils.safeButton(Button.builder((Component)this.buildFloatingLyricsRenderLabel(), btn -> {
            String cur = ClientConfig.getFloatingLyricsRender();
            String next = "GLOBAL".equals(cur) ? "WORLD" : "GLOBAL";
            ClientConfig.setFloatingLyricsRender(next);
            btn.setMessage(this.buildFloatingLyricsRenderLabel());
        }).bounds(this.width / 2 - 100, y += 24, 200, 20)));
        this.addRenderableWidget((GuiEventListener)NullSafetyUtils.safeButton(Button.builder((Component)NullSafetyUtils.safeTranslatable("craftmusic.ui.floating_lyrics.settings"), btn -> Minecraft.getInstance().setScreen((Screen)new FloatingLyricsSettingsScreen(this))).bounds(this.width / 2 - 100, y += 24, 200, 20)));
        int closeY = this.height - 30;
        this.addRenderableWidget((GuiEventListener)NullSafetyUtils.safeButton(Button.builder((Component)NullSafetyUtils.safeTranslatable("craftmusic.ui.close"), btn -> Minecraft.getInstance().setScreen(this.parent)).bounds(this.width / 2 - 100, closeY, 200, 20)));
    }

    @Nonnull
    private Component buildLyricEffectsLabel() {
        String key = ClientConfig.isLyricEffects() ? "craftmusic.ui.lyric_effects.on" : "craftmusic.ui.lyric_effects.off";
        return NullSafetyUtils.safeTranslatable(key);
    }

    @Nonnull
    private Component buildFloatingLyricsRenderLabel() {
        String scope = ClientConfig.getFloatingLyricsRender();
        String key = "GLOBAL".equals(scope) ? "craftmusic.ui.floating_lyrics.render.global" : "craftmusic.ui.floating_lyrics.render.world";
        return NullSafetyUtils.safeTranslatable(key);
    }

    public void render(@Nonnull GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(gfx, mouseX, mouseY, partialTick);
        super.render(gfx, mouseX, mouseY, partialTick);
        String breadcrumb = Component.translatable((String)"craftmusic.ui.settings").getString() + " > " + Component.translatable((String)"craftmusic.ui.lyrics.settings").getString();
        int x = (this.width - this.font.width(breadcrumb)) / 2;
        gfx.drawString(this.font, breadcrumb, x, 8, 0xFFFFFF, false);
    }
}

