/*
 * Decompiled with CFR 0.152.
 */
package com.tqk114514.craftmusic.client.settings.lyrics;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tqk114514.craftmusic.CraftMusicClient;
import com.tqk114514.craftmusic.client.ClientConfig;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FloatingLyricsPositionScreen
extends Screen {
    private final Screen parent;
    private float posX;
    private float posY;
    private boolean dragging = false;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;

    public FloatingLyricsPositionScreen(Screen parent) {
        super((Component)Component.translatable((String)"craftmusic.ui.floating_lyrics.position.settings"));
        this.parent = parent;
    }

    protected void init() {
        this.posX = ClientConfig.getFloatingLyricsPosX();
        this.posY = ClientConfig.getFloatingLyricsPosY();
        int closeY = this.height - 30;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.done"), b -> {
            ClientConfig.setFloatingLyricsPos(this.posX, this.posY);
            Minecraft.getInstance().setScreen(this.parent);
        }).bounds(this.width / 2 - 100, closeY, 95, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.buildSnapLabel(), b -> {
            ClientConfig.setFloatingLyricsSnap(!ClientConfig.isFloatingLyricsSnap());
            b.setMessage(this.buildSnapLabel());
        }).bounds(this.width / 2 + 5, closeY, 95, 20).build());
    }

    private Component buildSnapLabel() {
        return Component.translatable((String)(ClientConfig.isFloatingLyricsSnap() ? "craftmusic.ui.floating_lyrics.snap.on" : "craftmusic.ui.floating_lyrics.snap.off"));
    }

    public void render(@Nonnull GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        boolean nearBottom;
        String text;
        this.renderBackground(gfx, mouseX, mouseY, partialTick);
        super.render(gfx, mouseX, mouseY, partialTick);
        float scale = ClientConfig.getFloatingLyricsFontScale();
        boolean outline = ClientConfig.isFloatingLyricsOutline();
        int color = ClientConfig.getFloatingLyricsColor();
        String rawText = CraftMusicClient.getCurrentFloatingLyricText();
        if (rawText == null || rawText.isBlank()) {
            MutableComponent sampleComponent = Component.translatable((String)"craftmusic.ui.floating_lyrics.sample");
            String sampleText = sampleComponent != null ? sampleComponent.getString() : null;
            text = sampleText != null && !sampleText.isBlank() ? sampleText : "Sample Lyrics";
        } else {
            text = rawText;
        }
        int baseX = (int)(this.posX * (float)this.width);
        int baseY = (int)(this.posY * (float)this.height);
        int snap = 12;
        boolean useSnap = ClientConfig.isFloatingLyricsSnap();
        if (useSnap && Math.abs(baseX - 0) < snap) {
            baseX = 0;
        }
        if (useSnap && Math.abs(baseY - 0) < snap) {
            baseY = 0;
        }
        if (useSnap && Math.abs(baseX - this.width) < snap) {
            baseX = this.width;
        }
        if (useSnap && Math.abs(baseY - this.height) < snap) {
            baseY = this.height;
        }
        if (baseX < 0) {
            baseX = 0;
        }
        if (baseX > this.width) {
            baseX = this.width;
        }
        if (baseY < 0) {
            baseY = 0;
        }
        if (baseY > this.height) {
            baseY = this.height;
        }
        Font lyricsFont = this.font;
        int textW = (int)Math.ceil((float)lyricsFont.width(text) * scale);
        Objects.requireNonNull(lyricsFont);
        int textH = (int)Math.ceil(9.0f * scale);
        boolean nearLeft = useSnap && Math.abs(baseX - 0) < snap;
        boolean nearRight = useSnap && Math.abs(baseX - this.width) < snap;
        boolean nearTop = useSnap && Math.abs(baseY - 0) < snap;
        boolean bl = nearBottom = useSnap && Math.abs(baseY - this.height) < snap;
        int drawX = baseX - (nearLeft ? 0 : (nearRight ? textW : textW / 2));
        int drawY = baseY - (nearTop ? 0 : (nearBottom ? textH : 0));
        PoseStack pose = gfx.pose();
        pose.pushPose();
        pose.translate((float)drawX, (float)drawY, 0.0f);
        pose.scale(scale, scale, 1.0f);
        int a = color >>> 24 & 0xFF;
        if (a <= 0) {
            pose.popPose();
            return;
        }
        if (outline) {
            int outlineColor = a << 24;
            gfx.drawString(lyricsFont, text, 1, 0, outlineColor, false);
            gfx.drawString(lyricsFont, text, -1, 0, outlineColor, false);
            gfx.drawString(lyricsFont, text, 0, 1, outlineColor, false);
            gfx.drawString(lyricsFont, text, 0, -1, outlineColor, false);
        }
        gfx.drawString(lyricsFont, text, 0, 0, color, false);
        pose.popPose();
        gfx.fill(drawX - 1, drawY - 1, drawX + textW + 1, drawY, 0x40FFFFFF);
        gfx.fill(drawX - 1, drawY + textH, drawX + textW + 1, drawY + textH + 1, 0x40FFFFFF);
        gfx.fill(drawX - 1, drawY, drawX, drawY + textH, 0x40FFFFFF);
        gfx.fill(drawX + textW, drawY, drawX + textW + 1, drawY + textH, 0x40FFFFFF);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            boolean nearBottom;
            float scale = ClientConfig.getFloatingLyricsFontScale();
            String text = CraftMusicClient.getCurrentFloatingLyricText();
            if (text == null || text.isBlank()) {
                text = Component.translatable((String)"craftmusic.ui.floating_lyrics.sample").getString();
            }
            int baseX = (int)(this.posX * (float)this.width);
            int baseY = (int)(this.posY * (float)this.height);
            int w = (int)Math.ceil((float)this.font.width(text) * scale);
            Objects.requireNonNull(this.font);
            int h = (int)Math.ceil(9.0f * scale);
            int snap = 12;
            boolean useSnap = ClientConfig.isFloatingLyricsSnap();
            if (useSnap && Math.abs(baseX - 0) < snap) {
                baseX = 0;
            }
            if (useSnap && Math.abs(baseX - this.width) < snap) {
                baseX = this.width;
            }
            if (useSnap && Math.abs(baseY - 0) < snap) {
                baseY = 0;
            }
            if (useSnap && Math.abs(baseY - this.height) < snap) {
                baseY = this.height;
            }
            if (baseX < 0) {
                baseX = 0;
            }
            if (baseX > this.width) {
                baseX = this.width;
            }
            if (baseY < 0) {
                baseY = 0;
            }
            if (baseY > this.height) {
                baseY = this.height;
            }
            boolean nearLeft = useSnap && Math.abs(baseX - 0) < snap;
            boolean nearRight = useSnap && Math.abs(baseX - this.width) < snap;
            boolean nearTop = useSnap && Math.abs(baseY - 0) < snap;
            boolean bl = nearBottom = useSnap && Math.abs(baseY - this.height) < snap;
            int drawX = baseX - (nearLeft ? 0 : (nearRight ? w : w / 2));
            int drawY = baseY - (nearTop ? 0 : (nearBottom ? h : 0));
            if (mouseX >= (double)drawX && mouseX <= (double)(drawX + w) && mouseY >= (double)drawY && mouseY <= (double)(drawY + h)) {
                this.dragging = true;
                this.dragOffsetX = (int)mouseX - drawX;
                this.dragOffsetY = (int)mouseY - drawY;
                return true;
            }
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.dragging && button == 0) {
            int x = (int)mouseX - this.dragOffsetX;
            int y = (int)mouseY - this.dragOffsetY;
            float scale = ClientConfig.getFloatingLyricsFontScale();
            String text = CraftMusicClient.getCurrentFloatingLyricText();
            if (text == null || text.isBlank()) {
                text = Component.translatable((String)"craftmusic.ui.floating_lyrics.sample").getString();
            }
            int w = (int)Math.ceil((float)this.font.width(text) * scale);
            Objects.requireNonNull(this.font);
            int h = (int)Math.ceil(9.0f * scale);
            int maxX = Math.max(0, this.width - w);
            int maxY = Math.max(0, this.height - h);
            int snap = 12;
            boolean useSnap = ClientConfig.isFloatingLyricsSnap();
            if (useSnap && Math.abs(x - 0) < snap) {
                x = 0;
            }
            if (useSnap && Math.abs(y - 0) < snap) {
                y = 0;
            }
            if (useSnap && Math.abs(this.width - w - x) < snap) {
                x = this.width - w;
            }
            if (useSnap && Math.abs(this.height - h - y) < snap) {
                y = this.height - h;
            }
            if (x < 0) {
                x = 0;
            }
            if (x > maxX) {
                x = maxX;
            }
            if (y < 0) {
                y = 0;
            }
            if (y > maxY) {
                y = maxY;
            }
            int anchorX = useSnap && Math.abs(x + w - this.width) < snap ? this.width : (useSnap && Math.abs(x - 0) < snap ? 0 : x + w / 2);
            int anchorY = useSnap && Math.abs(y + h - this.height) < snap ? this.height : (useSnap && Math.abs(y - 0) < snap ? 0 : y);
            this.posX = FloatingLyricsPositionScreen.clamp((float)anchorX / (float)this.width);
            this.posY = FloatingLyricsPositionScreen.clamp((float)anchorY / (float)this.height);
            ClientConfig.setFloatingLyricsPos(this.posX, this.posY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dx, dy);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.dragging && button == 0) {
            this.dragging = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private static float clamp(float v) {
        return Math.max(0.0f, Math.min(1.0f, v));
    }
}

