/*
 * Decompiled with CFR 0.152.
 */
package com.tqk114514.craftmusic.client.settings.lyrics;

import com.tqk114514.craftmusic.client.settings.lyrics.FloatingLyricsColorScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

class OpacitySlider
extends AbstractSliderButton {
    private int percent;

    OpacitySlider(int x, int y, int w, int h, int initialPercent) {
        super(x, y, w, h, (Component)Component.literal((String)""), Math.max(0.0, Math.min(1.0, (double)initialPercent / 100.0)));
        this.percent = initialPercent;
        this.updateMessage();
    }

    int getPercent() {
        return this.percent;
    }

    void setPercent(int p) {
        this.percent = Math.max(0, Math.min(100, p));
        this.value = (double)this.percent / 100.0;
        this.updateMessage();
    }

    protected void updateMessage() {
        this.setMessage((Component)Component.literal((String)(Component.translatable((String)"craftmusic.ui.color.opacity").getString() + ": " + this.percent + "%")));
    }

    protected void applyValue() {
        this.percent = (int)Math.round(this.value * 100.0);
        this.updateMessage();
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof FloatingLyricsColorScreen) {
            FloatingLyricsColorScreen s = (FloatingLyricsColorScreen)screen;
            s.saveColorFromSliders();
        }
    }
}

