/*
 * Decompiled with CFR 0.152.
 */
package com.tqk114514.craftmusic.util;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class NullSafetyUtils {
    @Nonnull
    public static Component safeTranslatable(@Nonnull String key) {
        MutableComponent component = Component.translatable((String)key);
        return (Component)Objects.requireNonNull(component, "Component.translatable returned null for key: " + key);
    }

    @Nonnull
    public static Component safeTranslatable(@Nonnull String key, Object ... args) {
        MutableComponent component = Component.translatable((String)key, (Object[])args);
        return (Component)Objects.requireNonNull(component, "Component.translatable returned null for key: " + key);
    }

    @Nonnull
    public static Component safeLiteral(@Nonnull String text) {
        MutableComponent component = Component.literal((String)text);
        return (Component)Objects.requireNonNull(component, "Component.literal returned null for text: " + text);
    }

    @Nonnull
    public static Button safeButton(@Nonnull Button.Builder builder) {
        Button button = builder.build();
        return Objects.requireNonNull(button, "Button.Builder.build() returned null");
    }

    @Nonnull
    public static String safeGetString(Component component) {
        if (component == null) {
            return "";
        }
        String str = component.getString();
        return str != null ? str : "";
    }
}

