/*
 * Decompiled with CFR 0.152.
 */
package com.tqk114514.craftmusic.client;

import com.tqk114514.craftmusic.CraftMusic;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.Minecraft;
import net.neoforged.fml.loading.FMLPaths;

public final class ClientConfig {
    private static final String FILE_NAME = "craftmusic-client.json";
    private static volatile boolean initialized = false;
    private static volatile float volume = 1.0f;
    private static volatile String mode = "REPEAT_ALL";
    private static volatile boolean lyricEffects = true;
    private static volatile boolean floatingLyrics = false;
    private static volatile String floatingLyricsRender = "GLOBAL";
    private static volatile float floatingLyricsPosX = 0.02f;
    private static volatile float floatingLyricsPosY = 0.02f;
    private static volatile float floatingLyricsFontScale = 1.0f;
    private static volatile boolean floatingLyricsOutline = false;
    private static volatile int floatingLyricsColor = -1;
    private static volatile boolean spectrumEnabled = false;
    private static volatile boolean floatingLyricsSnap = true;

    private ClientConfig() {
    }

    public static synchronized void initAndLoad() {
        boolean needSave;
        block38: {
            if (initialized) {
                return;
            }
            initialized = true;
            Path f = ClientConfig.getConfigFile();
            needSave = false;
            if (Files.exists(f, new LinkOption[0])) {
                try {
                    Boolean le;
                    String m;
                    String json = Files.readString(f, StandardCharsets.UTF_8);
                    Float v = ClientConfig.parseVolume(json);
                    if (v != null) {
                        volume = ClientConfig.clamp(v.floatValue());
                    }
                    if ((m = ClientConfig.parseMode(json)) != null && !m.isBlank()) {
                        mode = m.trim();
                    }
                    if ((le = ClientConfig.parseBoolean(json, "lyricEffects")) != null) {
                        lyricEffects = le;
                    } else {
                        needSave = true;
                    }
                    Boolean fl = ClientConfig.parseBoolean(json, "floatingLyrics");
                    if (fl != null) {
                        floatingLyrics = fl;
                    } else {
                        needSave = true;
                    }
                    String fr = ClientConfig.parseString(json, "floatingLyricsRender");
                    if (fr != null && !fr.isBlank()) {
                        ClientConfig.setFloatingLyricsRenderInternal(fr.trim());
                    } else {
                        needSave = true;
                    }
                    String fp = ClientConfig.parseString(json, "floatingLyricsPosition");
                    if (fp != null && !fp.isBlank()) {
                        String p;
                        switch (p = fp.trim().toUpperCase()) {
                            case "TOP_LEFT": {
                                floatingLyricsPosX = 0.02f;
                                floatingLyricsPosY = 0.02f;
                                break;
                            }
                            case "TOP_RIGHT": {
                                floatingLyricsPosX = 0.98f;
                                floatingLyricsPosY = 0.02f;
                                break;
                            }
                            case "BOTTOM_LEFT": {
                                floatingLyricsPosX = 0.02f;
                                floatingLyricsPosY = 0.95f;
                                break;
                            }
                            case "BOTTOM_RIGHT": {
                                floatingLyricsPosX = 0.98f;
                                floatingLyricsPosY = 0.95f;
                                break;
                            }
                            default: {
                                floatingLyricsPosX = 0.02f;
                                floatingLyricsPosY = 0.02f;
                            }
                        }
                        needSave = true;
                    }
                    Float px = ClientConfig.parseFloat(json, "floatingLyricsPosX");
                    Float py = ClientConfig.parseFloat(json, "floatingLyricsPosY");
                    if (px != null && py != null) {
                        floatingLyricsPosX = ClientConfig.clamp(px.floatValue());
                        floatingLyricsPosY = ClientConfig.clamp(py.floatValue());
                    } else {
                        needSave = true;
                    }
                    Float fs = ClientConfig.parseFloat(json, "floatingLyricsFontScale");
                    if (fs != null) {
                        floatingLyricsFontScale = ClientConfig.clampRange(fs.floatValue(), 0.5f, 3.0f);
                    } else {
                        needSave = true;
                    }
                    Boolean fo = ClientConfig.parseBoolean(json, "floatingLyricsOutline");
                    if (fo != null) {
                        floatingLyricsOutline = fo;
                    } else {
                        needSave = true;
                    }
                    Integer col = ClientConfig.parseInt(json, "floatingLyricsColor");
                    if (col != null) {
                        floatingLyricsColor = col;
                    } else {
                        needSave = true;
                    }
                    Boolean snap = ClientConfig.parseBoolean(json, "floatingLyricsSnap");
                    if (snap != null) {
                        floatingLyricsSnap = snap;
                    } else {
                        needSave = true;
                    }
                    Boolean sp = ClientConfig.parseBoolean(json, "spectrumEnabled");
                    if (sp != null) {
                        spectrumEnabled = sp;
                        break block38;
                    }
                    needSave = true;
                }
                catch (IOException e) {
                    CraftMusic.LOGGER.warn("ClientConfig load failed: {}", (Object)e.toString());
                }
            } else {
                needSave = true;
            }
        }
        if (needSave) {
            ClientConfig.save();
        }
    }

    public static float getVolume() {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        return volume;
    }

    public static void setVolume(float v) {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        volume = ClientConfig.clamp(v);
        ClientConfig.save();
    }

    private static void save() {
        try {
            Path f = ClientConfig.getConfigFile();
            if (!Files.exists(f.getParent(), new LinkOption[0])) {
                Files.createDirectories(f.getParent(), new FileAttribute[0]);
            }
            String json = "{\n  \"volume\": " + Float.toString(volume) + ",\n  \"mode\": \"" + mode + "\",\n  \"lyricEffects\": " + Boolean.toString(lyricEffects) + ",\n  \"floatingLyrics\": " + Boolean.toString(floatingLyrics) + ",\n  \"floatingLyricsRender\": \"" + floatingLyricsRender + "\",\n  \"floatingLyricsPosX\": " + floatingLyricsPosX + ",\n  \"floatingLyricsPosY\": " + floatingLyricsPosY + ",\n  \"floatingLyricsFontScale\": " + floatingLyricsFontScale + ",\n  \"floatingLyricsOutline\": " + Boolean.toString(floatingLyricsOutline) + ",\n  \"floatingLyricsColor\": " + floatingLyricsColor + ",\n  \"floatingLyricsSnap\": " + Boolean.toString(floatingLyricsSnap) + ",\n  \"spectrumEnabled\": " + Boolean.toString(spectrumEnabled) + "\n}";
            Files.writeString(f, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            CraftMusic.LOGGER.warn("ClientConfig save failed: {}", (Object)e.toString());
        }
    }

    private static Path getConfigFile() {
        try {
            Path cfgDir = FMLPaths.CONFIGDIR.get();
            return cfgDir.resolve(FILE_NAME);
        }
        catch (Throwable ignored) {
            Minecraft mc = Minecraft.getInstance();
            Path gameDir = mc != null && mc.gameDirectory != null ? mc.gameDirectory.toPath() : Path.of(".", new String[0]);
            Path cfgDir = gameDir.resolve("config");
            return cfgDir.resolve(FILE_NAME);
        }
    }

    private static Float parseVolume(String json) {
        char c;
        int end;
        int start;
        if (json == null) {
            return null;
        }
        int idx = json.indexOf("\"volume\"");
        if (idx < 0) {
            return null;
        }
        int colon = json.indexOf(58, idx);
        if (colon < 0) {
            return null;
        }
        for (start = colon + 1; start < json.length() && Character.isWhitespace(json.charAt(start)); ++start) {
        }
        for (end = start; end < json.length() && ((c = json.charAt(end)) == '+' || c == '-' || c == '.' || c >= '0' && c <= '9' || c == 'e' || c == 'E'); ++end) {
        }
        String token = json.substring(start, end).trim();
        if (token.isEmpty()) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(token));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static String parseMode(String json) {
        int end;
        char c;
        int start;
        if (json == null) {
            return null;
        }
        int idx = json.indexOf("\"mode\"");
        if (idx < 0) {
            return null;
        }
        int colon = json.indexOf(58, idx);
        if (colon < 0) {
            return null;
        }
        for (start = colon + 1; start < json.length() && Character.isWhitespace(json.charAt(start)); ++start) {
        }
        char c2 = c = start < json.length() ? json.charAt(start) : (char)'\u0000';
        if (c == '\"' || c == '\'') {
            char quote = c;
            int end2 = json.indexOf(quote, start + 1);
            if (end2 > start) {
                return json.substring(start + 1, end2);
            }
            return null;
        }
        for (end = start; end < json.length() && !Character.isWhitespace(json.charAt(end)) && json.charAt(end) != ',' && json.charAt(end) != '}'; ++end) {
        }
        return json.substring(start, end).trim();
    }

    public static String getMode() {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        return mode;
    }

    public static void setMode(String m) {
        if (m == null || m.isBlank()) {
            return;
        }
        mode = m.trim();
        ClientConfig.save();
    }

    public static boolean isLyricEffects() {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        return lyricEffects;
    }

    public static void setLyricEffects(boolean v) {
        lyricEffects = v;
        ClientConfig.save();
    }

    public static boolean isFloatingLyrics() {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        return floatingLyrics;
    }

    public static void setFloatingLyrics(boolean v) {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        floatingLyrics = v;
        ClientConfig.save();
    }

    public static String getFloatingLyricsRender() {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        return floatingLyricsRender;
    }

    public static void setFloatingLyricsRender(String mode) {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        ClientConfig.setFloatingLyricsRenderInternal(mode);
        ClientConfig.save();
    }

    private static void setFloatingLyricsRenderInternal(String mode) {
        String m;
        String string = m = mode == null ? "" : mode.toUpperCase();
        if (!"GLOBAL".equals(m) && !"WORLD".equals(m)) {
            m = "GLOBAL";
        }
        floatingLyricsRender = m;
    }

    public static float getFloatingLyricsPosX() {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        return floatingLyricsPosX;
    }

    public static float getFloatingLyricsPosY() {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        return floatingLyricsPosY;
    }

    public static void setFloatingLyricsPos(float x, float y) {
        floatingLyricsPosX = ClientConfig.clamp(x);
        floatingLyricsPosY = ClientConfig.clamp(y);
        ClientConfig.save();
    }

    public static float getFloatingLyricsFontScale() {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        return floatingLyricsFontScale;
    }

    public static void setFloatingLyricsFontScale(float s) {
        floatingLyricsFontScale = ClientConfig.clampRange(s, 0.5f, 3.0f);
        ClientConfig.save();
    }

    public static boolean isFloatingLyricsOutline() {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        return floatingLyricsOutline;
    }

    public static void setFloatingLyricsOutline(boolean v) {
        floatingLyricsOutline = v;
        ClientConfig.save();
    }

    public static int getFloatingLyricsColor() {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        return floatingLyricsColor;
    }

    public static void setFloatingLyricsColor(int c) {
        floatingLyricsColor = c;
        ClientConfig.save();
    }

    public static boolean isSpectrumEnabled() {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        return spectrumEnabled;
    }

    public static void setSpectrumEnabled(boolean v) {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        spectrumEnabled = v;
        ClientConfig.save();
    }

    public static boolean isFloatingLyricsSnap() {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        return floatingLyricsSnap;
    }

    public static void setFloatingLyricsSnap(boolean v) {
        if (!initialized) {
            ClientConfig.initAndLoad();
        }
        floatingLyricsSnap = v;
        ClientConfig.save();
    }

    private static Integer parseInt(String json, String key) {
        Float f = ClientConfig.parseFloat(json, key);
        if (f == null) {
            return null;
        }
        return (int)f.floatValue();
    }

    private static Boolean parseBoolean(String json, String key) {
        int start;
        if (json == null || key == null) {
            return null;
        }
        int idx = json.indexOf("\"" + key + "\"");
        if (idx < 0) {
            return null;
        }
        int colon = json.indexOf(58, idx);
        if (colon < 0) {
            return null;
        }
        for (start = colon + 1; start < json.length() && Character.isWhitespace(json.charAt(start)); ++start) {
        }
        if (json.regionMatches(true, start, "true", 0, 4)) {
            return true;
        }
        if (json.regionMatches(true, start, "false", 0, 5)) {
            return false;
        }
        return null;
    }

    private static String parseString(String json, String key) {
        int end;
        char c;
        int start;
        if (json == null || key == null) {
            return null;
        }
        int idx = json.indexOf("\"" + key + "\"");
        if (idx < 0) {
            return null;
        }
        int colon = json.indexOf(58, idx);
        if (colon < 0) {
            return null;
        }
        for (start = colon + 1; start < json.length() && Character.isWhitespace(json.charAt(start)); ++start) {
        }
        char c2 = c = start < json.length() ? json.charAt(start) : (char)'\u0000';
        if (c == '\"' || c == '\'') {
            char quote = c;
            int end2 = json.indexOf(quote, start + 1);
            if (end2 > start) {
                return json.substring(start + 1, end2);
            }
            return null;
        }
        for (end = start; end < json.length() && !Character.isWhitespace(json.charAt(end)) && json.charAt(end) != ',' && json.charAt(end) != '}'; ++end) {
        }
        return json.substring(start, end).trim();
    }

    private static Float parseFloat(String json, String key) {
        char c;
        int end;
        int start;
        if (json == null || key == null) {
            return null;
        }
        int idx = json.indexOf("\"" + key + "\"");
        if (idx < 0) {
            return null;
        }
        int colon = json.indexOf(58, idx);
        if (colon < 0) {
            return null;
        }
        for (start = colon + 1; start < json.length() && Character.isWhitespace(json.charAt(start)); ++start) {
        }
        for (end = start; end < json.length() && ((c = json.charAt(end)) == '+' || c == '-' || c == '.' || c >= '0' && c <= '9' || c == 'e' || c == 'E'); ++end) {
        }
        try {
            return Float.valueOf(Float.parseFloat(json.substring(start, end).trim()));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static float clamp(float v) {
        return Math.max(0.0f, Math.min(1.0f, v));
    }

    private static float clampRange(float v, float lo, float hi) {
        if (v < lo) {
            return lo;
        }
        if (v > hi) {
            return hi;
        }
        return v;
    }
}

